/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.data.DataBuffer;
import com.google.android.gms.common.internal.Preconditions;
import java.util.Iterator;
import java.util.NoSuchElementException;

@KeepForSdk
public class DataBufferIterator<T>
implements Iterator<T> {
    protected final DataBuffer<T> zalk;
    protected int zall;

    public DataBufferIterator(DataBuffer<T> dataBuffer) {
        this.zalk = (DataBuffer)Preconditions.checkNotNull(dataBuffer);
        this.zall = -1;
    }

    @Override
    public boolean hasNext() {
        return this.zall < this.zalk.getCount() - 1;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            int n = this.zall;
            throw new NoSuchElementException(new StringBuilder(46).append("Cannot advance the iterator beyond ").append(n).toString());
        }
        return this.zalk.get(++this.zall);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove elements from a DataBufferIterator");
    }
}

