/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.os.Bundle;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.data.DataBuffer;
import com.google.android.gms.common.data.DataBufferIterator;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.SingleRefDataBufferIterator;
import java.util.Iterator;

public abstract class AbstractDataBuffer<T>
implements DataBuffer<T> {
    protected final DataHolder mDataHolder;

    @KeepForSdk
    protected AbstractDataBuffer(DataHolder dataHolder) {
        this.mDataHolder = dataHolder;
    }

    @Override
    public int getCount() {
        if (this.mDataHolder == null) {
            return 0;
        }
        return this.mDataHolder.getCount();
    }

    @Override
    public abstract T get(int var1);

    @Override
    @Deprecated
    public final void close() {
        this.release();
    }

    @Override
    @Deprecated
    public boolean isClosed() {
        return this.mDataHolder == null || this.mDataHolder.isClosed();
    }

    @Override
    public Bundle getMetadata() {
        return this.mDataHolder.getMetadata();
    }

    @Override
    public Iterator<T> iterator() {
        return new DataBufferIterator(this);
    }

    @Override
    public Iterator<T> singleRefIterator() {
        return new SingleRefDataBufferIterator(this);
    }

    @Override
    public void release() {
        if (this.mDataHolder != null) {
            this.mDataHolder.close();
        }
    }
}

