/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.SignInConnectionListener;
import com.google.android.gms.common.api.internal.zaah;
import com.google.android.gms.common.api.internal.zaak;
import com.google.android.gms.common.api.internal.zaav;
import com.google.android.gms.common.api.internal.zaaw;
import com.google.android.gms.common.api.internal.zabd;
import com.google.android.gms.common.api.internal.zabf;
import com.google.android.gms.common.api.internal.zabg;
import com.google.android.gms.common.api.internal.zabs;
import com.google.android.gms.common.api.internal.zabt;
import com.google.android.gms.common.api.internal.zaq;
import com.google.android.gms.common.api.internal.zar;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.signin.SignInOptions;
import com.google.android.gms.signin.zad;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.GuardedBy;

public final class zabe
implements zabs,
zar {
    private final Lock zaeo;
    private final Condition zahn;
    private final Context mContext;
    private final GoogleApiAvailabilityLight zaey;
    private final zabg zaho;
    final Map<Api.AnyClientKey<?>, Api.Client> zagz;
    final Map<Api.AnyClientKey<?>, ConnectionResult> zahp = new HashMap();
    private final ClientSettings zaet;
    private final Map<Api<?>, Boolean> zaew;
    private final Api.AbstractClientBuilder<? extends zad, SignInOptions> zace;
    private volatile zabd zahq;
    private ConnectionResult zahr = null;
    int zahs;
    final zaaw zaee;
    final zabt zaht;

    public zabe(Context context, zaaw zaaw2, Lock lock, Looper looper, GoogleApiAvailabilityLight googleApiAvailabilityLight, Map<Api.AnyClientKey<?>, Api.Client> map, ClientSettings clientSettings, Map<Api<?>, Boolean> map2, Api.AbstractClientBuilder<? extends zad, SignInOptions> abstractClientBuilder, ArrayList<zaq> arrayList, zabt zabt2) {
        this.mContext = context;
        this.zaeo = lock;
        this.zaey = googleApiAvailabilityLight;
        this.zagz = map;
        this.zaet = clientSettings;
        this.zaew = map2;
        this.zace = abstractClientBuilder;
        this.zaee = zaaw2;
        this.zaht = zabt2;
        ArrayList<zaq> arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            zaq zaq2 = arrayList2.get(i);
            zaq2.zaa(this);
        }
        this.zaho = new zabg(this, looper);
        this.zahn = lock.newCondition();
        this.zahq = new zaav(this);
    }

    @Override
    @GuardedBy(value="mLock")
    public final <A extends Api.AnyClient, R extends Result, T extends BaseImplementation.ApiMethodImpl<R, A>> T enqueue(@NonNull T t) {
        t.zau();
        return this.zahq.enqueue(t);
    }

    @Override
    @GuardedBy(value="mLock")
    public final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T execute(@NonNull T t) {
        t.zau();
        return this.zahq.execute(t);
    }

    @Override
    @GuardedBy(value="mLock")
    public final void connect() {
        this.zahq.connect();
    }

    @Override
    @GuardedBy(value="mLock")
    public final ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.zahn.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.RESULT_SUCCESS;
        }
        if (this.zahr != null) {
            return this.zahr;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    @GuardedBy(value="mLock")
    public final ConnectionResult blockingConnect(long l, TimeUnit timeUnit) {
        this.connect();
        long l2 = timeUnit.toNanos(l);
        while (this.isConnecting()) {
            try {
                if (l2 <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l2 = this.zahn.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.RESULT_SUCCESS;
        }
        if (this.zahr != null) {
            return this.zahr;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    @GuardedBy(value="mLock")
    public final void disconnect() {
        if (this.zahq.disconnect()) {
            this.zahp.clear();
        }
    }

    @Override
    @GuardedBy(value="mLock")
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        Api.AnyClientKey<?> anyClientKey = api.getClientKey();
        if (this.zagz.containsKey(anyClientKey)) {
            if (this.zagz.get(anyClientKey).isConnected()) {
                return ConnectionResult.RESULT_SUCCESS;
            }
            if (this.zahp.containsKey(anyClientKey)) {
                return this.zahp.get(anyClientKey);
            }
        }
        return null;
    }

    final void zaaz() {
        this.zaeo.lock();
        try {
            this.zahq = new zaak(this, this.zaet, this.zaew, this.zaey, this.zace, this.zaeo, this.mContext);
            this.zahq.begin();
            this.zahn.signalAll();
            return;
        }
        finally {
            this.zaeo.unlock();
        }
    }

    final void zaba() {
        this.zaeo.lock();
        try {
            this.zaee.zaaw();
            this.zahq = new zaah(this);
            this.zahq.begin();
            this.zahn.signalAll();
            return;
        }
        finally {
            this.zaeo.unlock();
        }
    }

    final void zaf(ConnectionResult connectionResult) {
        this.zaeo.lock();
        try {
            this.zahr = connectionResult;
            this.zahq = new zaav(this);
            this.zahq.begin();
            this.zahn.signalAll();
            return;
        }
        finally {
            this.zaeo.unlock();
        }
    }

    @Override
    public final boolean isConnected() {
        return this.zahq instanceof zaah;
    }

    @Override
    public final boolean isConnecting() {
        return this.zahq instanceof zaak;
    }

    @Override
    public final boolean maybeSignIn(SignInConnectionListener signInConnectionListener) {
        return false;
    }

    @Override
    public final void maybeSignOut() {
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zaw() {
        if (this.isConnected()) {
            ((zaah)this.zahq).zaam();
        }
    }

    @Override
    public final void zaa(@NonNull ConnectionResult connectionResult, @NonNull Api<?> api, boolean bl) {
        this.zaeo.lock();
        try {
            this.zahq.zaa(connectionResult, api, bl);
            return;
        }
        finally {
            this.zaeo.unlock();
        }
    }

    @Override
    public final void onConnected(@Nullable Bundle bundle) {
        this.zaeo.lock();
        try {
            this.zahq.onConnected(bundle);
            return;
        }
        finally {
            this.zaeo.unlock();
        }
    }

    @Override
    public final void onConnectionSuspended(int n) {
        this.zaeo.lock();
        try {
            this.zahq.onConnectionSuspended(n);
            return;
        }
        finally {
            this.zaeo.unlock();
        }
    }

    final void zaa(zabf zabf2) {
        Message message = this.zaho.obtainMessage(1, zabf2);
        this.zaho.sendMessage(message);
    }

    final void zab(RuntimeException runtimeException) {
        Message message = this.zaho.obtainMessage(2, runtimeException);
        this.zaho.sendMessage(message);
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3 = String.valueOf(string2).concat("  ");
        printWriter.append(string2).append("mState=").println(this.zahq);
        for (Api<?> api : this.zaew.keySet()) {
            printWriter.append(string2).append(api.getName()).println(":");
            this.zagz.get(api.getClientKey()).dump(string3, fileDescriptor, printWriter, stringArray);
        }
    }

    static /* synthetic */ Lock zaa(zabe zabe2) {
        return zabe2.zaeo;
    }

    static /* synthetic */ zabd zab(zabe zabe2) {
        return zabe2.zahq;
    }
}

