/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.GuardedBy;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.NotificationCompat;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.widget.ProgressBar;
import com.google.android.gms.base.R;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.ErrorDialogFragment;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.SupportErrorDialogFragment;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiActivity;
import com.google.android.gms.common.api.internal.GoogleApiManager;
import com.google.android.gms.common.api.internal.LifecycleFragment;
import com.google.android.gms.common.api.internal.zabq;
import com.google.android.gms.common.api.internal.zabr;
import com.google.android.gms.common.api.internal.zabu;
import com.google.android.gms.common.internal.ConnectionErrorMessages;
import com.google.android.gms.common.internal.DialogRedirect;
import com.google.android.gms.common.internal.HideFirstParty;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.util.DeviceProperties;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.internal.base.zap;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.util.ArrayList;
import java.util.Arrays;

public class GoogleApiAvailability
extends GoogleApiAvailabilityLight {
    private static final Object mLock = new Object();
    private static final GoogleApiAvailability zaao = new GoogleApiAvailability();
    @GuardedBy(value="mLock")
    private String zaap;
    public static final int GOOGLE_PLAY_SERVICES_VERSION_CODE = GoogleApiAvailabilityLight.GOOGLE_PLAY_SERVICES_VERSION_CODE;
    public static final String GOOGLE_PLAY_SERVICES_PACKAGE = "com.google.android.gms";

    public static GoogleApiAvailability getInstance() {
        return zaao;
    }

    @VisibleForTesting
    public GoogleApiAvailability() {
    }

    @MainThread
    public Task<Void> makeGooglePlayServicesAvailable(Activity activity) {
        int n = GOOGLE_PLAY_SERVICES_VERSION_CODE;
        Activity activity2 = activity;
        GoogleApiAvailability googleApiAvailability = this;
        Preconditions.checkMainThread((String)"makeGooglePlayServicesAvailable must be called from the main thread");
        int n2 = googleApiAvailability.isGooglePlayServicesAvailable((Context)activity2, n);
        if (n2 == 0) {
            return Tasks.forResult(null);
        }
        zabu zabu2 = zabu.zac(activity2);
        ConnectionResult connectionResult = new ConnectionResult(n2, null);
        zabu2.zab(connectionResult, 0);
        return zabu2.getTask();
    }

    public Dialog getErrorDialog(Activity activity, int n, int n2) {
        return this.getErrorDialog(activity, n, n2, null);
    }

    public Dialog getErrorDialog(Activity activity, int n, int n2, DialogInterface.OnCancelListener onCancelListener) {
        Intent intent = this.getErrorResolutionIntent((Context)activity, n, "d");
        return GoogleApiAvailability.zaa((Context)activity, n, DialogRedirect.getInstance(activity, intent, n2), onCancelListener);
    }

    public boolean showErrorDialogFragment(Activity activity, int n, int n2) {
        return this.showErrorDialogFragment(activity, n, n2, null);
    }

    public final boolean zaa(Activity activity, @NonNull LifecycleFragment lifecycleFragment, int n, int n2, DialogInterface.OnCancelListener onCancelListener) {
        Intent intent = this.getErrorResolutionIntent((Context)activity, n, "d");
        Dialog dialog = GoogleApiAvailability.zaa((Context)activity, n, DialogRedirect.getInstance(lifecycleFragment, intent, 2), onCancelListener);
        if (dialog == null) {
            return false;
        }
        GoogleApiAvailability.zaa(activity, dialog, "GooglePlayServicesErrorDialog", onCancelListener);
        return true;
    }

    public boolean showErrorDialogFragment(Activity activity, int n, int n2, DialogInterface.OnCancelListener onCancelListener) {
        Dialog dialog = this.getErrorDialog(activity, n, n2, onCancelListener);
        if (dialog == null) {
            return false;
        }
        GoogleApiAvailability.zaa(activity, dialog, "GooglePlayServicesErrorDialog", onCancelListener);
        return true;
    }

    public void showErrorNotification(Context context, int n) {
        Context context2 = context;
        GoogleApiAvailability googleApiAvailability = this;
        PendingIntent pendingIntent = googleApiAvailability.getErrorResolutionPendingIntent(context2, n, 0, "n");
        googleApiAvailability.zaa(context2, n, null, pendingIntent);
    }

    public void showErrorNotification(Context context, ConnectionResult connectionResult) {
        PendingIntent pendingIntent = this.getErrorResolutionPendingIntent(context, connectionResult);
        this.zaa(context, connectionResult.getErrorCode(), null, pendingIntent);
    }

    public final boolean zaa(Context context, ConnectionResult connectionResult, int n) {
        PendingIntent pendingIntent = this.getErrorResolutionPendingIntent(context, connectionResult);
        if (pendingIntent != null) {
            this.zaa(context, connectionResult.getErrorCode(), null, GoogleApiActivity.zaa(context, pendingIntent, n));
            return true;
        }
        return false;
    }

    public static Dialog zaa(Activity activity, DialogInterface.OnCancelListener onCancelListener) {
        ProgressBar progressBar = new ProgressBar((Context)activity, null, 16842874);
        progressBar.setIndeterminate(true);
        progressBar.setVisibility(0);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
        builder.setView((View)progressBar);
        builder.setMessage((CharSequence)ConnectionErrorMessages.getErrorMessage((Context)activity, 18));
        builder.setPositiveButton((CharSequence)"", null);
        AlertDialog alertDialog = builder.create();
        GoogleApiAvailability.zaa(activity, (Dialog)alertDialog, "GooglePlayServicesUpdatingDialog", onCancelListener);
        return alertDialog;
    }

    @Nullable
    public final zabq zaa(Context context, zabr zabr2) {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.PACKAGE_ADDED");
        intentFilter.addDataScheme("package");
        zabq zabq2 = new zabq(zabr2);
        context.registerReceiver((BroadcastReceiver)zabq2, intentFilter);
        zabq2.zac(context);
        if (!this.isUninstalledAppPossiblyUpdating(context, GOOGLE_PLAY_SERVICES_PACKAGE)) {
            zabr2.zas();
            zabq2.unregister();
            return null;
        }
        return zabq2;
    }

    public Task<Void> checkApiAvailability(GoogleApi<?> googleApi, GoogleApi<?> ... googleApiArray) {
        GoogleApi<?>[] googleApiArray2 = googleApiArray;
        GoogleApi<?> googleApi2 = googleApi;
        Preconditions.checkNotNull(googleApi2, (Object)"Requested API must not be null.");
        Object object = googleApiArray2;
        int n = googleApiArray2.length;
        for (int i = 0; i < n; ++i) {
            Preconditions.checkNotNull(object[i], (Object)"Requested API must not be null.");
        }
        object = new ArrayList(googleApiArray2.length + 1);
        object.add(googleApi2);
        object.addAll(Arrays.asList(googleApiArray2));
        return GoogleApiManager.zabc().zaa((Iterable<? extends GoogleApi<?>>)object).continueWith((Continuation)new com.google.android.gms.common.zaa(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting(otherwise=2)
    private final String zag() {
        Object object = mLock;
        synchronized (object) {
            return this.zaap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=26)
    public void setDefaultNotificationChannelId(@NonNull Context context, @NonNull String string2) {
        if (PlatformVersion.isAtLeastO()) {
            Preconditions.checkNotNull((Object)((NotificationManager)context.getSystemService("notification")).getNotificationChannel(string2));
        }
        Object object = mLock;
        synchronized (object) {
            this.zaap = string2;
            return;
        }
    }

    @HideFirstParty
    public int isGooglePlayServicesAvailable(Context context) {
        return super.isGooglePlayServicesAvailable(context);
    }

    @ShowFirstParty
    @KeepForSdk
    public int isGooglePlayServicesAvailable(Context context, int n) {
        return super.isGooglePlayServicesAvailable(context, n);
    }

    public final boolean isUserResolvableError(int n) {
        return super.isUserResolvableError(n);
    }

    @Nullable
    @ShowFirstParty
    @KeepForSdk
    public Intent getErrorResolutionIntent(Context context, int n, @Nullable String string2) {
        return super.getErrorResolutionIntent(context, n, string2);
    }

    @Nullable
    public PendingIntent getErrorResolutionPendingIntent(Context context, int n, int n2) {
        return super.getErrorResolutionPendingIntent(context, n, n2);
    }

    @Nullable
    public PendingIntent getErrorResolutionPendingIntent(Context context, ConnectionResult connectionResult) {
        if (connectionResult.hasResolution()) {
            return connectionResult.getResolution();
        }
        return this.getErrorResolutionPendingIntent(context, connectionResult.getErrorCode(), 0);
    }

    @ShowFirstParty
    @KeepForSdk
    public int getClientVersion(Context context) {
        return super.getClientVersion(context);
    }

    public final String getErrorString(int n) {
        return super.getErrorString(n);
    }

    static Dialog zaa(Context context, int n, DialogRedirect dialogRedirect, DialogInterface.OnCancelListener onCancelListener) {
        String string2;
        String string3;
        if (n == 0) {
            return null;
        }
        AlertDialog.Builder builder = null;
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(16843529, typedValue, true);
        String string4 = context.getResources().getResourceEntryName(typedValue.resourceId);
        if ("Theme.Dialog.Alert".equals(string4)) {
            builder = new AlertDialog.Builder(context, 5);
        }
        if (builder == null) {
            builder = new AlertDialog.Builder(context);
        }
        builder.setMessage((CharSequence)ConnectionErrorMessages.getErrorMessage(context, n));
        if (onCancelListener != null) {
            builder.setOnCancelListener(onCancelListener);
        }
        if ((string3 = ConnectionErrorMessages.getErrorDialogButtonMessage(context, n)) != null) {
            builder.setPositiveButton((CharSequence)string3, (DialogInterface.OnClickListener)dialogRedirect);
        }
        if ((string2 = ConnectionErrorMessages.getErrorTitle(context, n)) != null) {
            builder.setTitle((CharSequence)string2);
        }
        return builder.create();
    }

    static void zaa(Activity activity, Dialog dialog, String string2, DialogInterface.OnCancelListener onCancelListener) {
        boolean bl = activity instanceof FragmentActivity;
        if (bl) {
            FragmentManager fragmentManager = ((FragmentActivity)activity).getSupportFragmentManager();
            SupportErrorDialogFragment.newInstance(dialog, onCancelListener).show(fragmentManager, string2);
            return;
        }
        android.app.FragmentManager fragmentManager = activity.getFragmentManager();
        ErrorDialogFragment.newInstance(dialog, onCancelListener).show(fragmentManager, string2);
    }

    @TargetApi(value=20)
    private final void zaa(Context context, int n, String string2, PendingIntent pendingIntent) {
        int n2;
        if (n == 18) {
            this.zaa(context);
            return;
        }
        if (pendingIntent == null) {
            if (n == 6) {
                Log.w((String)"GoogleApiAvailability", (String)"Missing resolution for ConnectionResult.RESOLUTION_REQUIRED. Call GoogleApiAvailability#showErrorNotification(Context, ConnectionResult) instead.");
            }
            return;
        }
        String string3 = ConnectionErrorMessages.getErrorNotificationTitle(context, n);
        String string4 = ConnectionErrorMessages.getErrorNotificationMessage(context, n);
        Resources resources = context.getResources();
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context).setLocalOnly(true).setAutoCancel(true).setContentTitle((CharSequence)string3).setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)string4));
        if (DeviceProperties.isWearable((Context)context)) {
            Preconditions.checkState((boolean)PlatformVersion.isAtLeastKitKatWatch());
            builder.setSmallIcon(context.getApplicationInfo().icon).setPriority(2);
            if (DeviceProperties.isWearableWithoutPlayStore((Context)context)) {
                builder.addAction(R.drawable.common_full_open_on_phone, (CharSequence)resources.getString(R.string.common_open_on_phone), pendingIntent);
            } else {
                builder.setContentIntent(pendingIntent);
            }
        } else {
            builder.setSmallIcon(17301642).setTicker((CharSequence)resources.getString(R.string.common_google_play_services_notification_ticker)).setWhen(System.currentTimeMillis()).setContentIntent(pendingIntent).setContentText((CharSequence)string4);
        }
        NotificationCompat.Builder builder2 = builder;
        NotificationManager notificationManager2 = notificationManager;
        Context context2 = context;
        GoogleApiAvailability googleApiAvailability = this;
        if (PlatformVersion.isAtLeastO()) {
            NotificationManager notificationManager3 = notificationManager2;
            Context context3 = context2;
            GoogleApiAvailability googleApiAvailability2 = googleApiAvailability;
            Preconditions.checkState((boolean)PlatformVersion.isAtLeastO());
            String string5 = googleApiAvailability2.zag();
            if (string5 == null) {
                string5 = "com.google.android.gms.availability";
                NotificationChannel notificationChannel = notificationManager3.getNotificationChannel(string5);
                String string6 = ConnectionErrorMessages.getDefaultNotificationChannelName(context3);
                if (notificationChannel == null) {
                    notificationManager3.createNotificationChannel(new NotificationChannel(string5, (CharSequence)string6, 4));
                } else if (!string6.contentEquals(notificationChannel.getName())) {
                    notificationChannel.setName((CharSequence)string6);
                    notificationManager3.createNotificationChannel(notificationChannel);
                }
            }
            String string7 = string5;
            builder2.setChannelId(string7);
        }
        Notification notification = builder.build();
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                n2 = 10436;
                GooglePlayServicesUtilLight.sCanceledAvailabilityNotification.set(false);
                break;
            }
            default: {
                n2 = 39789;
            }
        }
        notificationManager.notify(n2, notification);
    }

    final void zaa(Context context) {
        new zaa(context).sendEmptyMessageDelayed(1, 120000L);
    }

    @SuppressLint(value={"HandlerLeak"})
    private final class zaa
    extends zap {
        private final Context zaaq;

        public zaa(Context context) {
            super(Looper.myLooper() == null ? Looper.getMainLooper() : Looper.myLooper());
            this.zaaq = context.getApplicationContext();
        }

        public final void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    int n = GoogleApiAvailability.this.isGooglePlayServicesAvailable(this.zaaq);
                    if (!GoogleApiAvailability.this.isUserResolvableError(n)) break;
                    GoogleApiAvailability.this.showErrorNotification(this.zaaq, n);
                    return;
                }
                default: {
                    int n = message.what;
                    Log.w((String)"GoogleApiAvailability", (String)new StringBuilder(50).append("Don't know how to handle this message: ").append(n).toString());
                }
            }
        }
    }
}

