/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.base;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import com.google.android.gms.internal.base.zag;
import com.google.android.gms.internal.base.zai;

public final class zae
extends Drawable
implements Drawable.Callback {
    private int zang = 0;
    private long zanh;
    private int mFrom;
    private int zani;
    private int zanj = 255;
    private int zank;
    private int mAlpha = 0;
    private boolean zamy = true;
    private boolean zanl;
    private zai zanm;
    private Drawable zann;
    private Drawable zano;
    private boolean zanp;
    private boolean zanq;
    private boolean zanr;
    private int zans;

    public zae(Drawable drawable2, Drawable drawable3) {
        this(null);
        if (drawable2 == null) {
            drawable2 = zag.zacg();
        }
        this.zann = drawable2;
        drawable2.setCallback((Drawable.Callback)this);
        this.zanm.zanv |= drawable2.getChangingConfigurations();
        if (drawable3 == null) {
            drawable3 = zag.zacg();
        }
        this.zano = drawable3;
        drawable3.setCallback((Drawable.Callback)this);
        this.zanm.zanv |= drawable3.getChangingConfigurations();
    }

    zae(zai zai2) {
        this.zanm = new zai(zai2);
    }

    public final void invalidateDrawable(Drawable drawable2) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public final void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.scheduleDrawable((Drawable)this, runnable, l);
        }
    }

    public final void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.unscheduleDrawable((Drawable)this, runnable);
        }
    }

    public final int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.zanm.mChangingConfigurations | this.zanm.zanv;
    }

    public final void setAlpha(int n) {
        if (this.mAlpha == this.zanj) {
            this.mAlpha = n;
        }
        this.zanj = n;
        this.invalidateSelf();
    }

    public final void setColorFilter(ColorFilter colorFilter) {
        this.zann.setColorFilter(colorFilter);
        this.zano.setColorFilter(colorFilter);
    }

    public final int getIntrinsicWidth() {
        return Math.max(this.zann.getIntrinsicWidth(), this.zano.getIntrinsicWidth());
    }

    public final int getIntrinsicHeight() {
        return Math.max(this.zann.getIntrinsicHeight(), this.zano.getIntrinsicHeight());
    }

    protected final void onBoundsChange(Rect rect) {
        this.zann.setBounds(rect);
        this.zano.setBounds(rect);
    }

    public final Drawable.ConstantState getConstantState() {
        if (this.canConstantState()) {
            this.zanm.mChangingConfigurations = this.getChangingConfigurations();
            return this.zanm;
        }
        return null;
    }

    public final int getOpacity() {
        if (!this.zanr) {
            this.zans = Drawable.resolveOpacity((int)this.zann.getOpacity(), (int)this.zano.getOpacity());
            this.zanr = true;
        }
        return this.zans;
    }

    private final boolean canConstantState() {
        if (!this.zanp) {
            this.zanq = this.zann.getConstantState() != null && this.zano.getConstantState() != null;
            this.zanp = true;
        }
        return this.zanq;
    }

    public final Drawable mutate() {
        if (!this.zanl && super.mutate() == this) {
            if (!this.canConstantState()) {
                throw new IllegalStateException("One or more children of this LayerDrawable does not have constant state; this drawable cannot be mutated.");
            }
            this.zann.mutate();
            this.zano.mutate();
            this.zanl = true;
        }
        return this;
    }

    public final Drawable zacf() {
        return this.zano;
    }

    public final void startTransition(int n) {
        this.mFrom = 0;
        this.zani = this.zanj;
        this.mAlpha = 0;
        this.zank = 250;
        this.zang = 1;
        this.invalidateSelf();
    }

    public final void draw(Canvas canvas) {
        boolean bl = true;
        switch (this.zang) {
            case 1: {
                this.zanh = SystemClock.uptimeMillis();
                bl = false;
                this.zang = 2;
                break;
            }
            case 2: {
                float f;
                if (this.zanh < 0L) break;
                float f2 = (float)(SystemClock.uptimeMillis() - this.zanh) / (float)this.zank;
                bl = f >= 1.0f;
                if (bl) {
                    this.zang = 0;
                }
                f2 = Math.min(f2, 1.0f);
                this.mAlpha = (int)(0.0f + (float)this.zani * f2);
            }
        }
        int n = this.mAlpha;
        boolean bl2 = this.zamy;
        Drawable drawable2 = this.zann;
        Drawable drawable3 = this.zano;
        if (bl) {
            if (!bl2 || n == 0) {
                drawable2.draw(canvas);
            }
            if (n == this.zanj) {
                drawable3.setAlpha(this.zanj);
                drawable3.draw(canvas);
            }
            return;
        }
        if (bl2) {
            drawable2.setAlpha(this.zanj - n);
        }
        drawable2.draw(canvas);
        if (bl2) {
            drawable2.setAlpha(this.zanj);
        }
        if (n > 0) {
            drawable3.setAlpha(n);
            drawable3.draw(canvas);
            drawable3.setAlpha(this.zanj);
        }
        this.invalidateSelf();
    }
}

