/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultCallbacks;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.api.internal.zacc;
import com.google.android.gms.common.api.internal.zacn;
import com.google.android.gms.common.api.internal.zaco;
import com.google.android.gms.common.internal.Preconditions;
import java.lang.ref.WeakReference;
import javax.annotation.concurrent.GuardedBy;

public final class zacm<R extends Result>
extends TransformedResult<R>
implements ResultCallback<R> {
    private ResultTransform<? super R, ? extends Result> zakn = null;
    private zacm<? extends Result> zako = null;
    private volatile ResultCallbacks<? super R> zakp = null;
    private PendingResult<R> zakq = null;
    private final Object zadn = new Object();
    private Status zakr = null;
    private final WeakReference<GoogleApiClient> zadp;
    private final zaco zaks;
    private boolean zakt = false;

    public zacm(WeakReference<GoogleApiClient> weakReference) {
        Preconditions.checkNotNull(weakReference, (Object)"GoogleApiClient reference must not be null");
        this.zadp = weakReference;
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zadp.get();
        this.zaks = new zaco(this, googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public final <S extends Result> TransformedResult<S> then(@NonNull ResultTransform<? super R, ? extends S> resultTransform) {
        Object object = this.zadn;
        synchronized (object) {
            Preconditions.checkState((this.zakn == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            Preconditions.checkState((this.zakp == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zakn = resultTransform;
            zacm<R> zacm2 = new zacm<R>(this.zadp);
            this.zako = zacm2;
            this.zabu();
            return zacm2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void andFinally(@NonNull ResultCallbacks<? super R> resultCallbacks) {
        Object object = this.zadn;
        synchronized (object) {
            Preconditions.checkState((this.zakp == null ? 1 : 0) != 0, (Object)"Cannot call andFinally() twice.");
            Preconditions.checkState((this.zakn == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zakp = resultCallbacks;
            this.zabu();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onResult(R r) {
        Object object = this.zadn;
        synchronized (object) {
            if (r.getStatus().isSuccess()) {
                if (this.zakn != null) {
                    zacc.zabb().submit(new zacn(this, (Result)r));
                } else if (this.zabw()) {
                    this.zakp.onSuccess(r);
                }
            } else {
                this.zad(r.getStatus());
                zacm.zab(r);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zaa(PendingResult<?> pendingResult) {
        Object object = this.zadn;
        synchronized (object) {
            this.zakq = pendingResult;
            this.zabu();
            return;
        }
    }

    @GuardedBy(value="mSyncToken")
    private final void zabu() {
        if (this.zakn == null && this.zakp == null) {
            return;
        }
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zadp.get();
        if (!this.zakt && this.zakn != null && googleApiClient != null) {
            googleApiClient.zaa(this);
            this.zakt = true;
        }
        if (this.zakr != null) {
            this.zae(this.zakr);
            return;
        }
        if (this.zakq != null) {
            this.zakq.setResultCallback(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zad(Status status) {
        Object object = this.zadn;
        synchronized (object) {
            this.zakr = status;
            this.zae(this.zakr);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zae(Status status) {
        Object object = this.zadn;
        synchronized (object) {
            if (this.zakn != null) {
                Status status2 = this.zakn.onFailure(status);
                Preconditions.checkNotNull((Object)status2, (Object)"onFailure must not return null");
                super.zad(status2);
            } else if (this.zabw()) {
                this.zakp.onFailure(status);
            }
            return;
        }
    }

    final void zabv() {
        this.zakp = null;
    }

    @GuardedBy(value="mSyncToken")
    private final boolean zabw() {
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zadp.get();
        return this.zakp != null && googleApiClient != null;
    }

    private static void zab(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
                return;
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"TransformedResultImpl", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    static /* synthetic */ ResultTransform zac(zacm zacm2) {
        return zacm2.zakn;
    }

    static /* synthetic */ zaco zad(zacm zacm2) {
        return zacm2.zaks;
    }

    static /* synthetic */ void zaa(zacm zacm2, Result result) {
        zacm.zab(result);
    }

    static /* synthetic */ WeakReference zae(zacm zacm2) {
        return zacm2.zadp;
    }

    static /* synthetic */ Object zaf(zacm zacm2) {
        return zacm2.zadn;
    }

    static /* synthetic */ zacm zag(zacm zacm2) {
        return zacm2.zako;
    }

    static /* synthetic */ void zaa(zacm zacm2, Status status) {
        zacm2.zad(status);
    }
}

