/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.support.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.OptionalPendingResult;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.api.internal.BasePendingResult;
import java.util.concurrent.TimeUnit;

@KeepForSdk
public final class OptionalPendingResultImpl<R extends Result>
extends OptionalPendingResult<R> {
    private final BasePendingResult<R> zajp;

    public OptionalPendingResultImpl(PendingResult<R> pendingResult) {
        this.zajp = (BasePendingResult)pendingResult;
    }

    @Override
    public final boolean isDone() {
        return this.zajp.isReady();
    }

    @Override
    public final R get() {
        if (((OptionalPendingResult)this).isDone()) {
            return ((PendingResult)this).await(0L, TimeUnit.MILLISECONDS);
        }
        throw new IllegalStateException("Result is not available. Check that isDone() returns true before calling get().");
    }

    @Override
    public final R await() {
        return ((PendingResult)this.zajp).await();
    }

    @Override
    public final R await(long l, TimeUnit timeUnit) {
        return ((PendingResult)this.zajp).await(l, timeUnit);
    }

    @Override
    public final void cancel() {
        ((PendingResult)this.zajp).cancel();
    }

    @Override
    public final boolean isCanceled() {
        return ((PendingResult)this.zajp).isCanceled();
    }

    @Override
    public final void setResultCallback(ResultCallback<? super R> resultCallback) {
        ((PendingResult)this.zajp).setResultCallback(resultCallback);
    }

    @Override
    public final void setResultCallback(ResultCallback<? super R> resultCallback, long l, TimeUnit timeUnit) {
        ((PendingResult)this.zajp).setResultCallback(resultCallback, l, timeUnit);
    }

    @Override
    public final void addStatusListener(PendingResult.StatusListener statusListener) {
        ((PendingResult)this.zajp).addStatusListener(statusListener);
    }

    @Override
    @NonNull
    public final <S extends Result> TransformedResult<S> then(@NonNull ResultTransform<? super R, ? extends S> resultTransform) {
        return ((PendingResult)this.zajp).then(resultTransform);
    }

    @Override
    public final Integer zam() {
        return ((PendingResult)this.zajp).zam();
    }
}

