/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.server.converter;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.server.converter.StringToIntConverterCreator;
import com.google.android.gms.common.server.converter.StringToIntConverterEntryCreator;
import com.google.android.gms.common.server.response.FastJsonResponse;
import java.util.ArrayList;
import java.util.HashMap;

@SafeParcelable.Class(creator="StringToIntConverterCreator")
public final class StringToIntConverter
extends AbstractSafeParcelable
implements FastJsonResponse.FieldConverter<String, Integer> {
    public static final Parcelable.Creator<StringToIntConverter> CREATOR = new StringToIntConverterCreator();
    @SafeParcelable.VersionField(id=1)
    private final int zzal;
    private final HashMap<String, Integer> zzwe;
    private final SparseArray<String> zzwf;
    @SafeParcelable.Field(id=2, getter="getSerializedMap")
    private final ArrayList<Entry> zzwg;

    @SafeParcelable.Constructor
    StringToIntConverter(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) ArrayList<Entry> arrayList) {
        this.zzal = n;
        this.zzwe = new HashMap();
        this.zzwf = new SparseArray();
        this.zzwg = null;
        ArrayList<Entry> arrayList2 = arrayList;
        StringToIntConverter stringToIntConverter = this;
        ArrayList<Entry> arrayList3 = arrayList2;
        int n2 = arrayList3.size();
        for (int i = 0; i < n2; ++i) {
            Entry entry = arrayList3.get(i);
            Entry entry2 = entry;
            stringToIntConverter.add(entry2.zzwh, entry2.zzwi);
        }
    }

    public StringToIntConverter() {
        this.zzal = 1;
        this.zzwe = new HashMap();
        this.zzwf = new SparseArray();
        this.zzwg = null;
    }

    public final StringToIntConverter add(String string2, int n) {
        this.zzwe.put(string2, n);
        this.zzwf.put(n, (Object)string2);
        return this;
    }

    @Override
    public final int getTypeIn() {
        return 7;
    }

    @Override
    public final int getTypeOut() {
        return 0;
    }

    @Override
    public final Integer convert(String string2) {
        Integer n = this.zzwe.get(string2);
        if (n == null) {
            n = this.zzwe.get("gms_unknown");
        }
        return n;
    }

    @Override
    public final String convertBack(Integer n) {
        String string2 = (String)this.zzwf.get(n.intValue());
        if (string2 == null && this.zzwe.containsKey("gms_unknown")) {
            return "gms_unknown";
        }
        return string2;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        StringToIntConverter stringToIntConverter = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1, (int)stringToIntConverter.zzal);
        StringToIntConverter stringToIntConverter2 = stringToIntConverter;
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        for (String string2 : stringToIntConverter2.zzwe.keySet()) {
            arrayList.add(new Entry(string2, stringToIntConverter2.zzwe.get(string2)));
        }
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)2, arrayList, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @SafeParcelable.Class(creator="StringToIntConverterEntryCreator")
    public static final class Entry
    extends AbstractSafeParcelable {
        public static final Parcelable.Creator<Entry> CREATOR = new StringToIntConverterEntryCreator();
        @SafeParcelable.VersionField(id=1)
        private final int versionCode;
        @SafeParcelable.Field(id=2)
        final String zzwh;
        @SafeParcelable.Field(id=3)
        final int zzwi;

        @SafeParcelable.Constructor
        Entry(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) String string2, @SafeParcelable.Param(id=3) int n2) {
            this.versionCode = n;
            this.zzwh = string2;
            this.zzwi = n2;
        }

        Entry(String string2, int n) {
            this.versionCode = 1;
            this.zzwh = string2;
            this.zzwi = n;
        }

        public final void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            Entry entry = this;
            int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
            SafeParcelWriter.writeInt((Parcel)parcel2, (int)1, (int)entry.versionCode);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)entry.zzwh, (boolean)false);
            SafeParcelWriter.writeInt((Parcel)parcel2, (int)3, (int)entry.zzwi);
            SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
        }
    }
}

