/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.oob;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AccountManagerCallback;
import android.accounts.AccountManagerFuture;
import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.text.TextUtils;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import java.io.IOException;

@VisibleForTesting
public class SignUp {
    public static final String ACTION_OOB_SIGN_UP = "com.google.android.gms.common.oob.OOB_SIGN_UP";
    public static final String EXTRA_ACCOUNT_NAME = "com.google.android.gms.common.oob.EXTRA_ACCOUNT_NAME";
    public static final String EXTRA_BACK_BUTTON_NAME = "com.google.android.gms.common.oob.EXTRA_BACK_BUTTON_NAME";
    public static final String EXTRAS_PROMO_APP_TEXT = "com.google.android.gms.common.oob.EXTRAS_PROMO_APP_TEXT";
    public static final String EXTRAS_PROMO_APP_PACKAGE = "com.google.android.gms.common.oob.EXTRAS_PROMO_APP_PACKAGE";
    public static final String EXTRAS_CALLING_APP_DESCRIPTION = "com.google.android.gms.common.oob.EXTRAS_APP_DESCRIPTION";
    public static final String EXTRAS_CLIENT_CALLING_APP_PACKAGE = "com.google.android.gms.common.oob.EXTRAS_CLIENT_CALLING_APP_PACKAGE";
    public static final String EXTRA_OVERRIDE_THEME = "com.google.android.gms.plus.OVERRIDE_THEME";
    public static final String EXTRA_GPSRC = "com.google.android.gms.plus.GPSRC";
    public static final int THEME_DEFAULT = 0;
    public static final int THEME_FULL = 1;
    public static final int THEME_SETUP_WIZARD = 2;
    public static final String[] GOOGLE_PLUS_REQUIRED_FEATURES = BaseGmsClient.GOOGLE_PLUS_REQUIRED_FEATURES;

    private SignUp() {
    }

    public static Intent newSignUpIntent(String string2) {
        return SignUp.newSignUpIntent(string2, null);
    }

    public static Intent newSignUpIntent(String string2, String string3) {
        Intent intent = new Intent();
        intent.setPackage("com.google.android.gms");
        intent.setAction(ACTION_OOB_SIGN_UP);
        intent.putExtra(EXTRA_ACCOUNT_NAME, string2);
        intent.putExtra(EXTRA_BACK_BUTTON_NAME, string3);
        return intent;
    }

    public static Intent newSignUpIntent(String string2, String string3, String string4, String string5) {
        Intent intent = new Intent();
        intent.setPackage("com.google.android.gms");
        intent.setAction(ACTION_OOB_SIGN_UP);
        intent.putExtra(EXTRA_ACCOUNT_NAME, string2);
        intent.putExtra(EXTRA_BACK_BUTTON_NAME, string3);
        intent.putExtra(EXTRAS_PROMO_APP_PACKAGE, string4);
        intent.putExtra(EXTRAS_PROMO_APP_TEXT, string5);
        return intent;
    }

    public static AccountManagerFuture<Boolean> checkSignUpState(Context context, String string2, String[] stringArray, AccountManagerCallback<Boolean> accountManagerCallback, Handler handler) {
        Preconditions.checkArgument((!TextUtils.isEmpty((CharSequence)string2) ? 1 : 0) != 0, (Object)"The accountName is required");
        Preconditions.checkArgument((stringArray != null ? 1 : 0) != 0, (Object)"The requiredFeatures parameter is required");
        AccountManager accountManager = AccountManager.get((Context)context);
        boolean bl = false;
        for (Account account : accountManager.getAccountsByType("com.google")) {
            if (!string2.equals(account.name)) continue;
            bl = true;
        }
        if (!bl) {
            throw new IllegalStateException("Given account does not exist on the device");
        }
        return accountManager.hasFeatures(new Account(string2, "com.google"), stringArray, accountManagerCallback, handler);
    }

    public static boolean isSignedUpBlocking(Context context, String string2, String[] stringArray) throws AuthenticatorException, OperationCanceledException, IOException {
        return (Boolean)SignUp.checkSignUpState(context, string2, stringArray, null, null).getResult();
    }
}

