/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.content.Context;
import android.support.v4.util.ArraySet;
import android.view.View;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.signin.SignInOptions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

@VisibleForTesting
public final class ClientSettings {
    private final Account zzs;
    private final Set<Scope> zzcv;
    private final Set<Scope> zzrz;
    private final Map<Api<?>, OptionalApiSettings> zzsa;
    private final int zzcx;
    private final View zzcy;
    private final String zzcz;
    private final String zzda;
    private final SignInOptions zzsb;
    private Integer zzsc;
    public static final String KEY_CLIENT_SESSION_ID = "com.google.android.gms.common.internal.ClientSettings.sessionId";

    public static ClientSettings createDefault(Context context) {
        return new GoogleApiClient.Builder(context).buildClientSettings();
    }

    public ClientSettings(Account account, Set<Scope> set, Map<Api<?>, OptionalApiSettings> map, int n, View view, String string2, String string3, SignInOptions signInOptions) {
        this.zzs = account;
        this.zzcv = set == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(set);
        this.zzsa = map == null ? Collections.EMPTY_MAP : map;
        this.zzcy = view;
        this.zzcx = n;
        this.zzcz = string2;
        this.zzda = string3;
        this.zzsb = signInOptions;
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zzcv);
        for (OptionalApiSettings optionalApiSettings : this.zzsa.values()) {
            hashSet.addAll(optionalApiSettings.mScopes);
        }
        this.zzrz = Collections.unmodifiableSet(hashSet);
    }

    @Deprecated
    @Nullable
    public final String getAccountName() {
        if (this.zzs != null) {
            return this.zzs.name;
        }
        return null;
    }

    @Nullable
    public final Account getAccount() {
        return this.zzs;
    }

    public final Account getAccountOrDefault() {
        if (this.zzs != null) {
            return this.zzs;
        }
        return new Account("<<default account>>", "com.google");
    }

    public final int getGravityForPopups() {
        return this.zzcx;
    }

    public final Set<Scope> getRequiredScopes() {
        return this.zzcv;
    }

    public final Set<Scope> getAllRequestedScopes() {
        return this.zzrz;
    }

    public final Map<Api<?>, OptionalApiSettings> getOptionalApiSettings() {
        return this.zzsa;
    }

    @Nullable
    public final String getRealClientPackageName() {
        return this.zzcz;
    }

    @Nullable
    public final String getRealClientClassName() {
        return this.zzda;
    }

    @Nullable
    public final View getViewForPopups() {
        return this.zzcy;
    }

    @Nullable
    public final SignInOptions getSignInOptions() {
        return this.zzsb;
    }

    @Nullable
    public final Integer getClientSessionId() {
        return this.zzsc;
    }

    public final void setClientSessionId(Integer n) {
        this.zzsc = n;
    }

    public final Set<Scope> getApplicableScopes(Api<?> api) {
        OptionalApiSettings optionalApiSettings = this.zzsa.get(api);
        if (optionalApiSettings == null || optionalApiSettings.mScopes.isEmpty()) {
            return this.zzcv;
        }
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zzcv);
        hashSet.addAll(optionalApiSettings.mScopes);
        return hashSet;
    }

    public static final class Builder {
        private Account zzs;
        private ArraySet<Scope> zzsd;
        private Map<Api<?>, OptionalApiSettings> zzsa;
        private int zzcx = 0;
        private View zzcy;
        private String zzcz;
        private String zzda;
        private SignInOptions zzsb = SignInOptions.DEFAULT;

        public Builder() {
        }

        public final Builder setAccount(Account account) {
            this.zzs = account;
            return this;
        }

        public final Builder addRequiredScope(Scope scope) {
            if (this.zzsd == null) {
                this.zzsd = new ArraySet();
            }
            this.zzsd.add((Object)scope);
            return this;
        }

        public final Builder addAllRequiredScopes(Collection<Scope> collection) {
            if (this.zzsd == null) {
                this.zzsd = new ArraySet();
            }
            this.zzsd.addAll(collection);
            return this;
        }

        public final Builder setOptionalApiSettingsMap(Map<Api<?>, OptionalApiSettings> map) {
            this.zzsa = map;
            return this;
        }

        public final Builder setGravityForPopups(int n) {
            this.zzcx = n;
            return this;
        }

        public final Builder setViewForPopups(View view) {
            this.zzcy = view;
            return this;
        }

        public final Builder setRealClientPackageName(String string2) {
            this.zzcz = string2;
            return this;
        }

        public final Builder setRealClientClassName(String string2) {
            this.zzda = string2;
            return this;
        }

        public final Builder setSignInOptions(SignInOptions signInOptions) {
            this.zzsb = signInOptions;
            return this;
        }

        public final ClientSettings build() {
            return new ClientSettings(this.zzs, (Set<Scope>)this.zzsd, this.zzsa, this.zzcx, this.zzcy, this.zzcz, this.zzda, this.zzsb);
        }
    }

    public static final class OptionalApiSettings {
        public final Set<Scope> mScopes;

        public OptionalApiSettings(Set<Scope> set) {
            Preconditions.checkNotNull(set);
            this.mScopes = Collections.unmodifiableSet(set);
        }
    }
}

