/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images.internal;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;

public final class CrossFadingDrawable
extends Drawable
implements Drawable.Callback {
    private int zzpw = 0;
    private long zzpx;
    private int mFrom;
    private int zzpy;
    private int zzpz = 255;
    private int zzqa;
    private int mAlpha = 0;
    private boolean zzpl = true;
    private boolean zzqb;
    private zzb zzqc;
    private Drawable zzqd;
    private Drawable zzqe;
    private boolean zzqf;
    private boolean zzqg;
    private boolean zzqh;
    private int zzqi;

    public CrossFadingDrawable(Drawable drawable2, Drawable drawable3) {
        this(null);
        if (drawable2 == null) {
            drawable2 = zza.zzqj;
        }
        this.zzqd = drawable2;
        drawable2.setCallback((Drawable.Callback)this);
        this.zzqc.zzql |= drawable2.getChangingConfigurations();
        if (drawable3 == null) {
            drawable3 = zza.zzqj;
        }
        this.zzqe = drawable3;
        drawable3.setCallback((Drawable.Callback)this);
        this.zzqc.zzql |= drawable3.getChangingConfigurations();
    }

    CrossFadingDrawable(zzb zzb2) {
        this.zzqc = new zzb(zzb2);
    }

    public final void invalidateDrawable(Drawable drawable2) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public final void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.scheduleDrawable((Drawable)this, runnable, l);
        }
    }

    public final void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.unscheduleDrawable((Drawable)this, runnable);
        }
    }

    public final int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.zzqc.mChangingConfigurations | this.zzqc.zzql;
    }

    public final void setAlpha(int n) {
        if (this.mAlpha == this.zzpz) {
            this.mAlpha = n;
        }
        this.zzpz = n;
        this.invalidateSelf();
    }

    public final void setColorFilter(ColorFilter colorFilter) {
        this.zzqd.setColorFilter(colorFilter);
        this.zzqe.setColorFilter(colorFilter);
    }

    public final int getIntrinsicWidth() {
        return Math.max(this.zzqd.getIntrinsicWidth(), this.zzqe.getIntrinsicWidth());
    }

    public final int getIntrinsicHeight() {
        return Math.max(this.zzqd.getIntrinsicHeight(), this.zzqe.getIntrinsicHeight());
    }

    protected final void onBoundsChange(Rect rect) {
        this.zzqd.setBounds(rect);
        this.zzqe.setBounds(rect);
    }

    public final Drawable.ConstantState getConstantState() {
        if (this.canConstantState()) {
            this.zzqc.mChangingConfigurations = this.getChangingConfigurations();
            return this.zzqc;
        }
        return null;
    }

    public final int getOpacity() {
        if (!this.zzqh) {
            this.zzqi = Drawable.resolveOpacity((int)this.zzqd.getOpacity(), (int)this.zzqe.getOpacity());
            this.zzqh = true;
        }
        return this.zzqi;
    }

    public final boolean canConstantState() {
        if (!this.zzqf) {
            this.zzqg = this.zzqd.getConstantState() != null && this.zzqe.getConstantState() != null;
            this.zzqf = true;
        }
        return this.zzqg;
    }

    public final Drawable mutate() {
        if (!this.zzqb && super.mutate() == this) {
            if (!this.canConstantState()) {
                throw new IllegalStateException("One or more children of this LayerDrawable does not have constant state; this drawable cannot be mutated.");
            }
            this.zzqd.mutate();
            this.zzqe.mutate();
            this.zzqb = true;
        }
        return this;
    }

    public final Drawable getStartDrawable() {
        return this.zzqd;
    }

    public final Drawable getEndDrawable() {
        return this.zzqe;
    }

    public final void startTransition(int n) {
        this.mFrom = 0;
        this.zzpy = this.zzpz;
        this.mAlpha = 0;
        this.zzqa = n;
        this.zzpw = 1;
        this.invalidateSelf();
    }

    public final void resetTransition() {
        this.mAlpha = 0;
        this.zzpw = 0;
        this.invalidateSelf();
    }

    public final void setCrossFadeEnabled(boolean bl) {
        this.zzpl = bl;
    }

    public final void draw(Canvas canvas) {
        boolean bl = true;
        switch (this.zzpw) {
            case 1: {
                this.zzpx = SystemClock.uptimeMillis();
                bl = false;
                this.zzpw = 2;
                break;
            }
            case 2: {
                float f;
                if (this.zzpx < 0L) break;
                float f2 = (float)(SystemClock.uptimeMillis() - this.zzpx) / (float)this.zzqa;
                bl = f >= 1.0f;
                if (bl) {
                    this.zzpw = 0;
                }
                f2 = Math.min(f2, 1.0f);
                this.mAlpha = (int)(0.0f + (float)this.zzpy * f2);
            }
        }
        int n = this.mAlpha;
        boolean bl2 = this.zzpl;
        Drawable drawable2 = this.zzqd;
        Drawable drawable3 = this.zzqe;
        if (bl) {
            if (!bl2 || n == 0) {
                drawable2.draw(canvas);
            }
            if (n == this.zzpz) {
                drawable3.setAlpha(this.zzpz);
                drawable3.draw(canvas);
            }
            return;
        }
        if (bl2) {
            drawable2.setAlpha(this.zzpz - n);
        }
        drawable2.draw(canvas);
        if (bl2) {
            drawable2.setAlpha(this.zzpz);
        }
        if (n > 0) {
            drawable3.setAlpha(n);
            drawable3.draw(canvas);
            drawable3.setAlpha(this.zzpz);
        }
        this.invalidateSelf();
    }

    private static final class zza
    extends Drawable {
        private static final zza zzqj = new zza();
        private static final com.google.android.gms.common.images.internal.zzb zzqk = new com.google.android.gms.common.images.internal.zzb(null);

        private zza() {
        }

        public final void draw(Canvas canvas) {
        }

        public final void setAlpha(int n) {
        }

        public final void setColorFilter(ColorFilter colorFilter) {
        }

        public final int getOpacity() {
            return -2;
        }

        public final Drawable.ConstantState getConstantState() {
            return zzqk;
        }
    }

    static final class zzb
    extends Drawable.ConstantState {
        int mChangingConfigurations;
        int zzql;

        zzb(zzb zzb2) {
            if (zzb2 != null) {
                this.mChangingConfigurations = zzb2.mChangingConfigurations;
                this.zzql = zzb2.zzql;
            }
        }

        public final Drawable newDrawable() {
            return new CrossFadingDrawable(this);
        }

        public final int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }
    }
}

