/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import com.google.android.gms.common.data.AbstractDataBuffer;
import com.google.android.gms.common.data.FilteredDataBuffer;
import java.util.ArrayList;
import java.util.HashSet;

public final class PositionFilteredDataBuffer<T>
extends FilteredDataBuffer<T> {
    private final HashSet<Integer> zzoe = new HashSet();
    private final ArrayList<Integer> zzob = new ArrayList();

    public PositionFilteredDataBuffer(AbstractDataBuffer<T> abstractDataBuffer) {
        super(abstractDataBuffer);
        this.zzcl();
    }

    @Override
    public final int getCount() {
        return this.mDataBuffer.getCount() - this.zzoe.size();
    }

    @Override
    public final int computeRealPosition(int n) {
        if (n < 0 || n >= this.getCount()) {
            throw new IllegalArgumentException(new StringBuilder(53).append("Position ").append(n).append(" is out of bounds for this buffer").toString());
        }
        return this.zzob.get(n);
    }

    public final void filterOut(int n) {
        if (n >= 0 && n <= this.mDataBuffer.getCount()) {
            this.zzoe.add(n);
            this.zzcl();
        }
    }

    public final void unfilter(int n) {
        this.zzoe.remove(n);
        this.zzcl();
    }

    public final void clearFilters() {
        this.zzoe.clear();
        this.zzcl();
    }

    private final void zzcl() {
        this.zzob.clear();
        int n = this.mDataBuffer.getCount();
        for (int i = 0; i < n; ++i) {
            if (this.zzoe.contains(i)) continue;
            this.zzob.add(i);
        }
    }
}

