/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;

public class DataBufferRef {
    protected final DataHolder mDataHolder;
    protected int mDataRow;
    private int zznj;

    public DataBufferRef(DataHolder dataHolder, int n) {
        this.mDataHolder = (DataHolder)Preconditions.checkNotNull((Object)dataHolder);
        this.setDataRow(n);
    }

    protected int getDataRow() {
        return this.mDataRow;
    }

    protected void setDataRow(int n) {
        Preconditions.checkState((n >= 0 && n < this.mDataHolder.getCount() ? 1 : 0) != 0);
        this.mDataRow = n;
        this.zznj = this.mDataHolder.getWindowIndex(this.mDataRow);
    }

    public boolean isDataValid() {
        return !this.mDataHolder.isClosed();
    }

    public boolean hasColumn(String string2) {
        return this.mDataHolder.hasColumn(string2);
    }

    protected long getLong(String string2) {
        return this.mDataHolder.getLong(string2, this.mDataRow, this.zznj);
    }

    protected int getInteger(String string2) {
        return this.mDataHolder.getInteger(string2, this.mDataRow, this.zznj);
    }

    protected boolean getBoolean(String string2) {
        return this.mDataHolder.getBoolean(string2, this.mDataRow, this.zznj);
    }

    protected String getString(String string2) {
        return this.mDataHolder.getString(string2, this.mDataRow, this.zznj);
    }

    protected float getFloat(String string2) {
        return this.mDataHolder.getFloat(string2, this.mDataRow, this.zznj);
    }

    protected double getDouble(String string2) {
        return this.mDataHolder.getDouble(string2, this.mDataRow, this.zznj);
    }

    protected byte[] getByteArray(String string2) {
        return this.mDataHolder.getByteArray(string2, this.mDataRow, this.zznj);
    }

    protected Uri parseUri(String string2) {
        return this.mDataHolder.parseUri(string2, this.mDataRow, this.zznj);
    }

    protected void copyToBuffer(String string2, CharArrayBuffer charArrayBuffer) {
        this.mDataHolder.copyToBuffer(string2, this.mDataRow, this.zznj, charArrayBuffer);
    }

    protected boolean hasNull(String string2) {
        return this.mDataHolder.hasNull(string2, this.mDataRow, this.zznj);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mDataRow, this.zznj, this.mDataHolder});
    }

    public boolean equals(Object object) {
        if (object instanceof DataBufferRef) {
            DataBufferRef dataBufferRef = (DataBufferRef)object;
            return Objects.equal((Object)dataBufferRef.mDataRow, (Object)this.mDataRow) && Objects.equal((Object)dataBufferRef.zznj, (Object)this.zznj) && dataBufferRef.mDataHolder == this.mDataHolder;
        }
        return false;
    }
}

