/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultCallbacks;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.api.internal.zzbw;
import com.google.android.gms.common.api.internal.zzci;
import com.google.android.gms.common.api.internal.zzcj;
import com.google.android.gms.common.internal.Preconditions;
import java.lang.ref.WeakReference;
import javax.annotation.concurrent.GuardedBy;

public final class zzch<R extends Result>
extends TransformedResult<R>
implements ResultCallback<R> {
    private ResultTransform<? super R, ? extends Result> zzmd = null;
    private zzch<? extends Result> zzme = null;
    private volatile ResultCallbacks<? super R> zzmf = null;
    private PendingResult<R> zzmg = null;
    private final Object zzfa = new Object();
    private Status zzmh = null;
    private final WeakReference<GoogleApiClient> zzfc;
    private final zzcj zzmi;
    private boolean zzmj = false;

    public zzch(WeakReference<GoogleApiClient> weakReference) {
        Preconditions.checkNotNull(weakReference, (Object)"GoogleApiClient reference must not be null");
        this.zzfc = weakReference;
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzfc.get();
        this.zzmi = new zzcj(this, googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public final <S extends Result> TransformedResult<S> then(@NonNull ResultTransform<? super R, ? extends S> resultTransform) {
        Object object = this.zzfa;
        synchronized (object) {
            Preconditions.checkState((this.zzmd == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            Preconditions.checkState((this.zzmf == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zzmd = resultTransform;
            zzch<R> zzch2 = new zzch<R>(this.zzfc);
            this.zzme = zzch2;
            this.zzcb();
            return zzch2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void andFinally(@NonNull ResultCallbacks<? super R> resultCallbacks) {
        Object object = this.zzfa;
        synchronized (object) {
            Preconditions.checkState((this.zzmf == null ? 1 : 0) != 0, (Object)"Cannot call andFinally() twice.");
            Preconditions.checkState((this.zzmd == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zzmf = resultCallbacks;
            this.zzcb();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onResult(R r) {
        Object object = this.zzfa;
        synchronized (object) {
            if (r.getStatus().isSuccess()) {
                if (this.zzmd != null) {
                    zzbw.zzbe().submit(new zzci(this, (Result)r));
                } else if (this.zzcd()) {
                    this.zzmf.onSuccess(r);
                }
            } else {
                this.zzd(r.getStatus());
                zzch.zzb(r);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(PendingResult<?> pendingResult) {
        Object object = this.zzfa;
        synchronized (object) {
            this.zzmg = pendingResult;
            this.zzcb();
            return;
        }
    }

    @GuardedBy(value="mSyncToken")
    private final void zzcb() {
        if (this.zzmd == null && this.zzmf == null) {
            return;
        }
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzfc.get();
        if (!this.zzmj && this.zzmd != null && googleApiClient != null) {
            googleApiClient.zza(this);
            this.zzmj = true;
        }
        if (this.zzmh != null) {
            this.zze(this.zzmh);
            return;
        }
        if (this.zzmg != null) {
            this.zzmg.setResultCallback(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzd(Status status) {
        Object object = this.zzfa;
        synchronized (object) {
            this.zzmh = status;
            this.zze(this.zzmh);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zze(Status status) {
        Object object = this.zzfa;
        synchronized (object) {
            if (this.zzmd != null) {
                Status status2 = this.zzmd.onFailure(status);
                Preconditions.checkNotNull((Object)status2, (Object)"onFailure must not return null");
                super.zzd(status2);
            } else if (this.zzcd()) {
                this.zzmf.onFailure(status);
            }
            return;
        }
    }

    final void zzcc() {
        this.zzmf = null;
    }

    @GuardedBy(value="mSyncToken")
    private final boolean zzcd() {
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzfc.get();
        return this.zzmf != null && googleApiClient != null;
    }

    private static void zzb(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
                return;
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"TransformedResultImpl", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    static /* synthetic */ ResultTransform zzc(zzch zzch2) {
        return zzch2.zzmd;
    }

    static /* synthetic */ zzcj zzd(zzch zzch2) {
        return zzch2.zzmi;
    }

    static /* synthetic */ void zza(zzch zzch2, Result result) {
        zzch.zzb(result);
    }

    static /* synthetic */ WeakReference zze(zzch zzch2) {
        return zzch2.zzfc;
    }

    static /* synthetic */ Object zzf(zzch zzch2) {
        return zzch2.zzfa;
    }

    static /* synthetic */ zzch zzg(zzch zzch2) {
        return zzch2.zzme;
    }

    static /* synthetic */ void zza(zzch zzch2, Status status) {
        zzch2.zzd(status);
    }
}

