/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Application;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.support.v4.util.ArraySet;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.UnsupportedApiCallException;
import com.google.android.gms.common.api.internal.BackgroundDetector;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.RegisterListenerMethod;
import com.google.android.gms.common.api.internal.StatusExceptionMapper;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.api.internal.UnregisterListenerMethod;
import com.google.android.gms.common.api.internal.zzaa;
import com.google.android.gms.common.api.internal.zzad;
import com.google.android.gms.common.api.internal.zzae;
import com.google.android.gms.common.api.internal.zzbh;
import com.google.android.gms.common.api.internal.zzbi;
import com.google.android.gms.common.api.internal.zzbj;
import com.google.android.gms.common.api.internal.zzbk;
import com.google.android.gms.common.api.internal.zzbl;
import com.google.android.gms.common.api.internal.zzbn;
import com.google.android.gms.common.api.internal.zzbu;
import com.google.android.gms.common.api.internal.zzbv;
import com.google.android.gms.common.api.internal.zzby;
import com.google.android.gms.common.api.internal.zzcb;
import com.google.android.gms.common.api.internal.zzd;
import com.google.android.gms.common.api.internal.zze;
import com.google.android.gms.common.api.internal.zzf;
import com.google.android.gms.common.api.internal.zzg;
import com.google.android.gms.common.api.internal.zzh;
import com.google.android.gms.common.api.internal.zzj;
import com.google.android.gms.common.api.internal.zzq;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.GoogleApiAvailabilityCache;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.SimpleClientAdapter;
import com.google.android.gms.common.util.ArrayUtils;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.signin.SignInClient;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;

@KeepForSdk
public class GoogleApiManager
implements Handler.Callback {
    public static final Status zzjj = new Status(4, "Sign-out occurred while this API call was in progress.");
    private static final Status zzjk = new Status(4, "The user must be signed in to make this API call.");
    private long zzjl = 5000L;
    private long zzjm = 120000L;
    private long zzjn = 10000L;
    private static final Object lock = new Object();
    @GuardedBy(value="lock")
    private static GoogleApiManager zzjo;
    private final Context zzjp;
    private final GoogleApiAvailability zzjq;
    private final GoogleApiAvailabilityCache zzjr;
    private final AtomicInteger zzjs = new AtomicInteger(1);
    private final AtomicInteger zzjt = new AtomicInteger(0);
    private final Map<zzh<?>, zza<?>> zzju = new ConcurrentHashMap(5, 0.75f, 1);
    @GuardedBy(value="lock")
    private zzad zzjv = null;
    @GuardedBy(value="lock")
    private final Set<zzh<?>> zzjw = new ArraySet();
    private final Set<zzh<?>> zzjx = new ArraySet();
    private final Handler handler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GoogleApiManager zzb(Context context) {
        Object object = lock;
        synchronized (object) {
            if (zzjo == null) {
                HandlerThread handlerThread = new HandlerThread("GoogleApiHandler", 9);
                handlerThread.start();
                Looper looper = handlerThread.getLooper();
                zzjo = new GoogleApiManager(context.getApplicationContext(), looper, GoogleApiAvailability.getInstance());
            }
            return zzjo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GoogleApiManager zzbf() {
        Object object = lock;
        synchronized (object) {
            Preconditions.checkNotNull((Object)zzjo, (Object)"Must guarantee manager is non-null before using getInstance");
            return zzjo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public static void reportSignOut() {
        Object object = lock;
        synchronized (object) {
            if (zzjo != null) {
                GoogleApiManager googleApiManager = zzjo;
                googleApiManager.zzjt.incrementAndGet();
                googleApiManager.handler.sendMessageAtFrontOfQueue(googleApiManager.handler.obtainMessage(10));
            }
            return;
        }
    }

    @KeepForSdk
    private GoogleApiManager(Context context, Looper looper, GoogleApiAvailability googleApiAvailability) {
        this.zzjp = context;
        this.handler = new Handler(looper, (Handler.Callback)this);
        this.zzjq = googleApiAvailability;
        this.zzjr = new GoogleApiAvailabilityCache(googleApiAvailability);
        this.handler.sendMessage(this.handler.obtainMessage(6));
    }

    public final int zzbg() {
        return this.zzjs.getAndIncrement();
    }

    public final void zza(GoogleApi<?> googleApi) {
        this.handler.sendMessage(this.handler.obtainMessage(7, googleApi));
    }

    @WorkerThread
    private final void zzb(GoogleApi<?> googleApi) {
        zzh<?> zzh2 = googleApi.zzm();
        zza<?> zza2 = this.zzju.get(zzh2);
        if (zza2 == null) {
            zza2 = new zza(googleApi);
            this.zzju.put(zzh2, zza2);
        }
        if (zza2.requiresSignIn()) {
            this.zzjx.add(zzh2);
        }
        zza2.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(@NonNull zzad zzad2) {
        Object object = lock;
        synchronized (object) {
            if (this.zzjv != zzad2) {
                this.zzjv = zzad2;
                this.zzjw.clear();
            }
            this.zzjw.addAll((Collection<zzh<?>>)zzad2.zzam());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzb(@NonNull zzad zzad2) {
        Object object = lock;
        synchronized (object) {
            if (this.zzjv == zzad2) {
                this.zzjv = null;
                this.zzjw.clear();
            }
            return;
        }
    }

    public final Task<Map<zzh<?>, String>> zza(Iterable<? extends GoogleApi<?>> iterable) {
        zzj zzj2 = new zzj(iterable);
        this.handler.sendMessage(this.handler.obtainMessage(2, (Object)zzj2));
        return zzj2.getTask();
    }

    public final void zzr() {
        this.handler.sendMessage(this.handler.obtainMessage(3));
    }

    final void maybeSignOut() {
        this.zzjt.incrementAndGet();
        this.handler.sendMessage(this.handler.obtainMessage(10));
    }

    public final Task<Boolean> zzc(GoogleApi<?> googleApi) {
        zzae zzae2 = new zzae(googleApi.zzm());
        this.handler.sendMessage(this.handler.obtainMessage(14, (Object)zzae2));
        return zzae2.zzao().getTask();
    }

    public final <O extends Api.ApiOptions> void zza(GoogleApi<O> googleApi, int n, BaseImplementation.ApiMethodImpl<? extends Result, Api.AnyClient> apiMethodImpl) {
        zzd<BaseImplementation.ApiMethodImpl<? extends Result, Api.AnyClient>> zzd2 = new zzd<BaseImplementation.ApiMethodImpl<? extends Result, Api.AnyClient>>(n, apiMethodImpl);
        this.handler.sendMessage(this.handler.obtainMessage(4, (Object)new zzbu(zzd2, this.zzjt.get(), googleApi)));
    }

    public final <O extends Api.ApiOptions, ResultT> void zza(GoogleApi<O> googleApi, int n, TaskApiCall<Api.AnyClient, ResultT> taskApiCall, TaskCompletionSource<ResultT> taskCompletionSource, StatusExceptionMapper statusExceptionMapper) {
        zzf<ResultT> zzf2 = new zzf<ResultT>(n, taskApiCall, taskCompletionSource, statusExceptionMapper);
        this.handler.sendMessage(this.handler.obtainMessage(4, (Object)new zzbu(zzf2, this.zzjt.get(), googleApi)));
    }

    public final <O extends Api.ApiOptions> Task<Void> zza(@NonNull GoogleApi<O> googleApi, @NonNull RegisterListenerMethod<Api.AnyClient, ?> registerListenerMethod, @NonNull UnregisterListenerMethod<Api.AnyClient, ?> unregisterListenerMethod) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zze zze2 = new zze(new zzbv(registerListenerMethod, unregisterListenerMethod), (TaskCompletionSource<Void>)taskCompletionSource);
        this.handler.sendMessage(this.handler.obtainMessage(8, (Object)new zzbu(zze2, this.zzjt.get(), googleApi)));
        return taskCompletionSource.getTask();
    }

    public final <O extends Api.ApiOptions> Task<Boolean> zza(@NonNull GoogleApi<O> googleApi, @NonNull ListenerHolder.ListenerKey<?> listenerKey) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzg zzg2 = new zzg(listenerKey, (TaskCompletionSource<Boolean>)taskCompletionSource);
        this.handler.sendMessage(this.handler.obtainMessage(13, (Object)new zzbu(zzg2, this.zzjt.get(), googleApi)));
        return taskCompletionSource.getTask();
    }

    @WorkerThread
    public boolean handleMessage(Message message) {
        block0 : switch (message.what) {
            case 1: {
                boolean bl = (Boolean)message.obj;
                GoogleApiManager googleApiManager = this;
                this.zzjn = bl ? 10000L : 300000L;
                googleApiManager.handler.removeMessages(12);
                for (zzh<?> zzh2 : googleApiManager.zzju.keySet()) {
                    googleApiManager.handler.sendMessageDelayed(googleApiManager.handler.obtainMessage(12, zzh2), googleApiManager.zzjn);
                }
                break;
            }
            case 2: {
                zzj zzj2 = (zzj)message.obj;
                GoogleApiManager googleApiManager = this;
                for (zzh<?> zzh3 : zzj2.zzs()) {
                    zza<?> zza2 = googleApiManager.zzju.get(zzh3);
                    if (zza2 == null) {
                        ConnectionResult connectionResult = new ConnectionResult(13);
                        zzj2.zza(zzh3, connectionResult, null);
                        break block0;
                    }
                    if (zza2.isConnected()) {
                        zzj2.zza(zzh3, ConnectionResult.RESULT_SUCCESS, zza2.zzae().getEndpointPackageName());
                        continue;
                    }
                    if (zza2.zzbp() != null) {
                        zzj2.zza(zzh3, zza2.zzbp(), null);
                        continue;
                    }
                    zza2.zza(zzj2);
                }
                break;
            }
            case 3: {
                for (zza<?> zza3 : this.zzju.values()) {
                    zza3.zzbo();
                    zza3.connect();
                }
                break;
            }
            case 4: 
            case 8: 
            case 13: {
                zzbu zzbu2 = (zzbu)message.obj;
                GoogleApiManager googleApiManager = this;
                zza<?> zza4 = googleApiManager.zzju.get(zzbu2.zzlr.zzm());
                if (zza4 == null) {
                    googleApiManager.zzb(zzbu2.zzlr);
                    zza4 = googleApiManager.zzju.get(zzbu2.zzlr.zzm());
                }
                if (zza4.requiresSignIn() && googleApiManager.zzjt.get() != zzbu2.zzlq) {
                    zzbu2.zzlp.zza(zzjj);
                    zza4.zzbm();
                    break;
                }
                zza4.zza(zzbu2.zzlp);
                break;
            }
            case 5: {
                ConnectionResult connectionResult = (ConnectionResult)message.obj;
                int n = message.arg1;
                GoogleApiManager googleApiManager = this;
                zza<?> zza5 = null;
                for (zza<?> zza6 : googleApiManager.zzju.values()) {
                    if (zza6.getInstanceId() != n) continue;
                    zza5 = zza6;
                    break;
                }
                if (zza5 != null) {
                    zza<?> zza6;
                    String string2 = googleApiManager.zzjq.getErrorString(connectionResult.getErrorCode());
                    zza6 = connectionResult.getErrorMessage();
                    zza5.zzc(new Status(17, new StringBuilder(69 + String.valueOf(string2).length() + String.valueOf(zza6).length()).append("Error resolution was canceled by the user, original error message: ").append(string2).append(": ").append((String)((Object)zza6)).toString()));
                    break;
                }
                Log.wtf((String)"GoogleApiManager", (String)new StringBuilder(76).append("Could not find API instance ").append(n).append(" while trying to fail enqueued calls.").toString(), (Throwable)new Exception());
                break;
            }
            case 6: {
                GoogleApiManager googleApiManager = this;
                if (!PlatformVersion.isAtLeastIceCreamSandwich() || !(googleApiManager.zzjp.getApplicationContext() instanceof Application)) break;
                BackgroundDetector.initialize((Application)((Application)googleApiManager.zzjp.getApplicationContext()));
                BackgroundDetector.getInstance().addListener((BackgroundDetector.BackgroundStateChangeListener)new zzbh(googleApiManager));
                if (BackgroundDetector.getInstance().readCurrentStateIfPossible(true)) break;
                googleApiManager.zzjn = 300000L;
                break;
            }
            case 7: {
                this.zzb((GoogleApi)message.obj);
                break;
            }
            case 9: {
                if (!this.zzju.containsKey(message.obj)) break;
                this.zzju.get(message.obj).resume();
                break;
            }
            case 10: {
                GoogleApiManager googleApiManager = this;
                for (zzh<?> zzh4 : googleApiManager.zzjx) {
                    googleApiManager.zzju.remove(zzh4).zzbm();
                }
                googleApiManager.zzjx.clear();
                break;
            }
            case 11: {
                if (!this.zzju.containsKey(message.obj)) break;
                this.zzju.get(message.obj).zzay();
                break;
            }
            case 12: {
                if (!this.zzju.containsKey(message.obj)) break;
                this.zzju.get(message.obj).zzbs();
                break;
            }
            case 14: {
                zzae zzae2 = (zzae)message.obj;
                GoogleApiManager googleApiManager = this;
                zzh<?> zzh5 = zzae2.zzm();
                if (!googleApiManager.zzju.containsKey(zzh5)) {
                    zzae2.zzao().setResult((Object)false);
                    break;
                }
                boolean bl = ((zza)googleApiManager.zzju.get(zzh5)).zzb(false);
                zzae2.zzao().setResult((Object)bl);
                break;
            }
            case 15: {
                zzb zzb2 = (zzb)message.obj;
                if (!this.zzju.containsKey(zzb2.zzkn)) break;
                ((zza)this.zzju.get(zzb2.zzkn)).zza(zzb2);
                break;
            }
            case 16: {
                zzb zzb3 = (zzb)message.obj;
                if (!this.zzju.containsKey(zzb3.zzkn)) break;
                ((zza)this.zzju.get(zzb3.zzkn)).zzb(zzb3);
                break;
            }
            default: {
                int n = message.what;
                Log.w((String)"GoogleApiManager", (String)new StringBuilder(31).append("Unknown message id: ").append(n).toString());
                return false;
            }
        }
        return true;
    }

    final PendingIntent zza(zzh<?> zzh2, int n) {
        zza<?> zza2 = this.zzju.get(zzh2);
        if (zza2 == null) {
            return null;
        }
        SignInClient signInClient = zza2.zzbt();
        if (signInClient == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)this.zzjp, (int)n, (Intent)signInClient.getSignInIntent(), (int)0x8000000);
    }

    final boolean zzc(ConnectionResult connectionResult, int n) {
        return this.zzjq.showWrappedErrorNotification(this.zzjp, connectionResult, n);
    }

    public final void zza(ConnectionResult connectionResult, int n) {
        if (!this.zzc(connectionResult, n)) {
            this.handler.sendMessage(this.handler.obtainMessage(5, n, 0, (Object)connectionResult));
        }
    }

    private static final class zzb {
        private final zzh<?> zzkn;
        private final Feature zzdr;

        private zzb(zzh<?> zzh2, Feature feature) {
            this.zzkn = zzh2;
            this.zzdr = feature;
        }

        public final boolean equals(Object object) {
            if (object != null && object instanceof zzb) {
                zzb zzb2 = (zzb)object;
                return Objects.equal(this.zzkn, zzb2.zzkn) && Objects.equal((Object)this.zzdr, (Object)zzb2.zzdr);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.zzkn, this.zzdr});
        }

        public final String toString() {
            return Objects.toStringHelper((Object)this).add("key", this.zzkn).add("feature", (Object)this.zzdr).toString();
        }

        /* synthetic */ zzb(zzh zzh2, Feature feature, zzbh zzbh2) {
            this(zzh2, feature);
        }
    }

    private final class zzc
    implements zzcb,
    BaseGmsClient.ConnectionProgressReportCallbacks {
        private final Api.Client zzka;
        private final zzh<?> zzhc;
        private IAccountAccessor zzko = null;
        private Set<Scope> zzkp = null;
        private boolean zzkq = false;

        public zzc(Api.Client client, zzh<?> zzh2) {
            this.zzka = client;
            this.zzhc = zzh2;
        }

        public final void onReportServiceBinding(@NonNull ConnectionResult connectionResult) {
            GoogleApiManager.this.handler.post((Runnable)new zzbn(this, connectionResult));
        }

        @Override
        @WorkerThread
        public final void zzg(ConnectionResult connectionResult) {
            ((zza)GoogleApiManager.this.zzju.get(this.zzhc)).zzg(connectionResult);
        }

        @Override
        @WorkerThread
        public final void zza(IAccountAccessor iAccountAccessor, Set<Scope> set) {
            if (iAccountAccessor == null || set == null) {
                Log.wtf((String)"GoogleApiManager", (String)"Received null response from onSignInSuccess", (Throwable)new Exception());
                this.zzg(new ConnectionResult(4));
                return;
            }
            this.zzko = iAccountAccessor;
            this.zzkp = set;
            this.zzbu();
        }

        @WorkerThread
        private final void zzbu() {
            if (this.zzkq && this.zzko != null) {
                this.zzka.getRemoteService(this.zzko, this.zzkp);
            }
        }

        static /* synthetic */ boolean zza(zzc zzc2, boolean bl) {
            zzc2.zzkq = true;
            return true;
        }

        static /* synthetic */ Api.Client zza(zzc zzc2) {
            return zzc2.zzka;
        }

        static /* synthetic */ void zzb(zzc zzc2) {
            zzc2.zzbu();
        }

        static /* synthetic */ zzh zzc(zzc zzc2) {
            return zzc2.zzhc;
        }
    }

    public final class zza<O extends Api.ApiOptions>
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener,
    zzq {
        private final Queue<com.google.android.gms.common.api.internal.zzb> zzjz = new LinkedList<com.google.android.gms.common.api.internal.zzb>();
        private final Api.Client zzka;
        private final Api.AnyClient zzkb;
        private final zzh<O> zzhc;
        private final zzaa zzkc;
        private final Set<zzj> zzkd = new HashSet<zzj>();
        private final Map<ListenerHolder.ListenerKey<?>, zzbv> zzke = new HashMap();
        private final int zzkf;
        private final zzby zzkg;
        private boolean zzkh;
        private final List<zzb> zzki = new ArrayList<zzb>();
        private ConnectionResult zzkj = null;

        @WorkerThread
        public zza(GoogleApi<O> googleApi) {
            this.zzka = googleApi.zza(GoogleApiManager.this.handler.getLooper(), this);
            this.zzkb = this.zzka instanceof SimpleClientAdapter ? ((SimpleClientAdapter)this.zzka).getClient() : this.zzka;
            this.zzhc = googleApi.zzm();
            this.zzkc = new zzaa();
            this.zzkf = googleApi.getInstanceId();
            if (this.zzka.requiresSignIn()) {
                this.zzkg = googleApi.zza(GoogleApiManager.this.zzjp, GoogleApiManager.this.handler);
                return;
            }
            this.zzkg = null;
        }

        @Override
        public final void onConnected(@Nullable Bundle bundle) {
            if (Looper.myLooper() == GoogleApiManager.this.handler.getLooper()) {
                this.zzbj();
                return;
            }
            GoogleApiManager.this.handler.post((Runnable)new zzbi(this));
        }

        @WorkerThread
        private final void zzbj() {
            this.zzbo();
            this.zzi(ConnectionResult.RESULT_SUCCESS);
            this.zzbq();
            for (zzbv zzbv2 : this.zzke.values()) {
                try {
                    zzbv2.zzlt.registerListener(this.zzkb, (TaskCompletionSource<Void>)new TaskCompletionSource());
                }
                catch (DeadObjectException deadObjectException) {
                    this.onConnectionSuspended(1);
                    this.zzka.disconnect();
                    break;
                }
                catch (RemoteException remoteException) {
                }
            }
            this.zzbl();
            this.zzbr();
        }

        @Override
        public final void onConnectionSuspended(int n) {
            if (Looper.myLooper() == GoogleApiManager.this.handler.getLooper()) {
                this.zzbk();
                return;
            }
            GoogleApiManager.this.handler.post((Runnable)new zzbj(this));
        }

        @WorkerThread
        private final void zzbk() {
            this.zzbo();
            this.zzkh = true;
            this.zzkc.zzal();
            GoogleApiManager.this.handler.sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.this.handler, (int)9, this.zzhc), GoogleApiManager.this.zzjl);
            GoogleApiManager.this.handler.sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.this.handler, (int)11, this.zzhc), GoogleApiManager.this.zzjm);
            GoogleApiManager.this.zzjr.flush();
        }

        @WorkerThread
        public final void zzg(@NonNull ConnectionResult connectionResult) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            this.zzka.disconnect();
            this.onConnectionFailed(connectionResult);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        private final boolean zzh(@NonNull ConnectionResult connectionResult) {
            Object object = lock;
            synchronized (object) {
                if (GoogleApiManager.this.zzjv != null && GoogleApiManager.this.zzjw.contains(this.zzhc)) {
                    GoogleApiManager.this.zzjv.zzb(connectionResult, this.zzkf);
                    return true;
                }
                return false;
            }
        }

        @Override
        public final void zza(ConnectionResult connectionResult, Api<?> api, boolean bl) {
            if (Looper.myLooper() == GoogleApiManager.this.handler.getLooper()) {
                this.onConnectionFailed(connectionResult);
                return;
            }
            GoogleApiManager.this.handler.post((Runnable)new zzbk(this, connectionResult));
        }

        @Override
        @WorkerThread
        public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            if (this.zzkg != null) {
                this.zzkg.zzbz();
            }
            this.zzbo();
            GoogleApiManager.this.zzjr.flush();
            this.zzi(connectionResult);
            if (connectionResult.getErrorCode() == 4) {
                this.zzc(zzjk);
                return;
            }
            if (this.zzjz.isEmpty()) {
                this.zzkj = connectionResult;
                return;
            }
            if (this.zzh(connectionResult)) {
                return;
            }
            if (!GoogleApiManager.this.zzc(connectionResult, this.zzkf)) {
                if (connectionResult.getErrorCode() == 18) {
                    this.zzkh = true;
                }
                if (this.zzkh) {
                    GoogleApiManager.this.handler.sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.this.handler, (int)9, this.zzhc), GoogleApiManager.this.zzjl);
                    return;
                }
                String string2 = this.zzhc.zzq();
                this.zzc(new Status(17, new StringBuilder(38 + String.valueOf(string2).length()).append("API: ").append(string2).append(" is not available on this device.").toString()));
            }
        }

        @WorkerThread
        private final void zzbl() {
            ArrayList<com.google.android.gms.common.api.internal.zzb> arrayList = new ArrayList<com.google.android.gms.common.api.internal.zzb>(this.zzjz);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                com.google.android.gms.common.api.internal.zzb zzb2 = arrayList.get(i);
                com.google.android.gms.common.api.internal.zzb zzb3 = zzb2;
                if (!this.zzka.isConnected()) break;
                if (!this.zzb(zzb3)) continue;
                this.zzjz.remove(zzb3);
            }
        }

        @WorkerThread
        public final void zza(com.google.android.gms.common.api.internal.zzb zzb2) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            if (this.zzka.isConnected()) {
                if (this.zzb(zzb2)) {
                    this.zzbr();
                    return;
                }
                this.zzjz.add(zzb2);
                return;
            }
            this.zzjz.add(zzb2);
            if (this.zzkj != null && this.zzkj.hasResolution()) {
                this.onConnectionFailed(this.zzkj);
                return;
            }
            this.connect();
        }

        @WorkerThread
        public final void zzbm() {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            this.zzc(zzjj);
            this.zzkc.zzak();
            for (ListenerHolder.ListenerKey listenerKey : this.zzke.keySet().toArray(new ListenerHolder.ListenerKey[this.zzke.size()])) {
                this.zza(new zzg(listenerKey, (TaskCompletionSource<Boolean>)new TaskCompletionSource()));
            }
            this.zzi(new ConnectionResult(4));
            if (this.zzka.isConnected()) {
                this.zzka.onUserSignOut(new zzbl(this));
            }
        }

        public final Api.Client zzae() {
            return this.zzka;
        }

        public final Map<ListenerHolder.ListenerKey<?>, zzbv> zzbn() {
            return this.zzke;
        }

        @WorkerThread
        public final void zzbo() {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            this.zzkj = null;
        }

        @WorkerThread
        public final ConnectionResult zzbp() {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            return this.zzkj;
        }

        @WorkerThread
        private final boolean zzb(com.google.android.gms.common.api.internal.zzb zzb2) {
            Feature feature;
            int n;
            if (!(zzb2 instanceof zzf)) {
                this.zzc(zzb2);
                return true;
            }
            zzf zzf2 = (zzf)zzb2;
            Feature[] featureArray = zzf2.getRequiredFeatures();
            if (featureArray == null || featureArray.length == 0) {
                this.zzc(zzb2);
                return true;
            }
            Feature[] featureArray2 = this.zzka.getAvailableFeatures();
            if (featureArray2 == null) {
                featureArray2 = new Feature[]{};
            }
            ArrayMap arrayMap = new ArrayMap(featureArray2.length);
            Feature[] featureArray3 = featureArray2;
            int n2 = featureArray2.length;
            for (n = 0; n < n2; ++n) {
                feature = featureArray3[n];
                arrayMap.put(feature.getName(), feature.getVersion());
            }
            featureArray3 = featureArray;
            n2 = featureArray.length;
            for (n = 0; n < n2; ++n) {
                feature = featureArray3[n];
                if (!arrayMap.containsKey(feature.getName()) || (Long)arrayMap.get(feature.getName()) < feature.getVersion()) {
                    if (zzf2.shouldAutoResolveMissingFeatures()) {
                        Feature feature2 = feature;
                        zza zza2 = this;
                        zzb zzb3 = new zzb(zza2.zzhc, feature2, null);
                        int n3 = zza2.zzki.indexOf(zzb3);
                        if (n3 >= 0) {
                            zzb zzb4 = zza2.zzki.get(n3);
                            zza2.GoogleApiManager.this.handler.removeMessages(15, (Object)zzb4);
                            zza2.GoogleApiManager.this.handler.sendMessageDelayed(Message.obtain((Handler)zza2.GoogleApiManager.this.handler, (int)15, (Object)zzb4), zza2.GoogleApiManager.this.zzjl);
                        } else {
                            zza2.zzki.add(zzb3);
                            zza2.GoogleApiManager.this.handler.sendMessageDelayed(Message.obtain((Handler)zza2.GoogleApiManager.this.handler, (int)15, (Object)zzb3), zza2.GoogleApiManager.this.zzjl);
                            zza2.GoogleApiManager.this.handler.sendMessageDelayed(Message.obtain((Handler)zza2.GoogleApiManager.this.handler, (int)16, (Object)zzb3), zza2.GoogleApiManager.this.zzjm);
                            ConnectionResult connectionResult = new ConnectionResult(2, null);
                            if (!zza2.zzh(connectionResult)) {
                                zza2.GoogleApiManager.this.zzc(connectionResult, zza2.zzkf);
                            }
                        }
                    } else {
                        ((com.google.android.gms.common.api.internal.zzb)zzf2).zza((RuntimeException)new UnsupportedApiCallException(feature));
                    }
                    return false;
                }
                this.zzki.remove(new zzb(this.zzhc, feature, null));
            }
            this.zzc(zzb2);
            return true;
        }

        @WorkerThread
        private final void zzc(com.google.android.gms.common.api.internal.zzb zzb2) {
            zzb2.zza(this.zzkc, this.requiresSignIn());
            try {
                zzb2.zza(this);
                return;
            }
            catch (DeadObjectException deadObjectException) {
                this.onConnectionSuspended(1);
                this.zzka.disconnect();
                return;
            }
        }

        @WorkerThread
        public final void zzc(Status status) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            Iterator iterator = this.zzjz.iterator();
            while (iterator.hasNext()) {
                ((com.google.android.gms.common.api.internal.zzb)iterator.next()).zza(status);
            }
            this.zzjz.clear();
        }

        @WorkerThread
        public final void resume() {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            if (this.zzkh) {
                this.connect();
            }
        }

        @WorkerThread
        private final void zzbq() {
            if (this.zzkh) {
                GoogleApiManager.this.handler.removeMessages(11, this.zzhc);
                GoogleApiManager.this.handler.removeMessages(9, this.zzhc);
                this.zzkh = false;
            }
        }

        @WorkerThread
        public final void zzay() {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            if (this.zzkh) {
                this.zzbq();
                Status status = GoogleApiManager.this.zzjq.isGooglePlayServicesAvailable(GoogleApiManager.this.zzjp) == 18 ? new Status(8, "Connection timed out while waiting for Google Play services update to complete.") : new Status(8, "API failed to connect while resuming due to an unknown error.");
                this.zzc(status);
                this.zzka.disconnect();
            }
        }

        private final void zzbr() {
            GoogleApiManager.this.handler.removeMessages(12, this.zzhc);
            GoogleApiManager.this.handler.sendMessageDelayed(GoogleApiManager.this.handler.obtainMessage(12, this.zzhc), GoogleApiManager.this.zzjn);
        }

        @WorkerThread
        public final boolean zzbs() {
            return this.zzb(true);
        }

        @WorkerThread
        private final boolean zzb(boolean bl) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            if (this.zzka.isConnected() && this.zzke.size() == 0) {
                if (this.zzkc.zzaj()) {
                    if (bl) {
                        this.zzbr();
                    }
                    return false;
                }
                this.zzka.disconnect();
                return true;
            }
            return false;
        }

        @WorkerThread
        public final void connect() {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            if (this.zzka.isConnected() || this.zzka.isConnecting()) {
                return;
            }
            int n = GoogleApiManager.this.zzjr.getClientAvailability(GoogleApiManager.this.zzjp, this.zzka);
            if (n != 0) {
                ConnectionResult connectionResult = new ConnectionResult(n, null);
                this.onConnectionFailed(connectionResult);
                return;
            }
            zzc zzc2 = new zzc(this.zzka, this.zzhc);
            if (this.zzka.requiresSignIn()) {
                this.zzkg.zza(zzc2);
            }
            this.zzka.connect(zzc2);
        }

        @WorkerThread
        public final void zza(zzj zzj2) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            this.zzkd.add(zzj2);
        }

        @WorkerThread
        private final void zzi(ConnectionResult connectionResult) {
            for (zzj zzj2 : this.zzkd) {
                String string2 = null;
                if (Objects.equal((Object)connectionResult, (Object)ConnectionResult.RESULT_SUCCESS)) {
                    string2 = this.zzka.getEndpointPackageName();
                }
                zzj2.zza(this.zzhc, connectionResult, string2);
            }
            this.zzkd.clear();
        }

        final boolean isConnected() {
            return this.zzka.isConnected();
        }

        public final boolean requiresSignIn() {
            return this.zzka.requiresSignIn();
        }

        public final int getInstanceId() {
            return this.zzkf;
        }

        final SignInClient zzbt() {
            if (this.zzkg == null) {
                return null;
            }
            return this.zzkg.zzbt();
        }

        @WorkerThread
        private final void zza(zzb zzb2) {
            if (!this.zzki.contains(zzb2)) {
                return;
            }
            if (!this.zzkh) {
                if (!this.zzka.isConnected()) {
                    this.connect();
                    return;
                }
                this.zzbl();
            }
        }

        @WorkerThread
        private final void zzb(zzb zzb2) {
            if (this.zzki.remove(zzb2)) {
                GoogleApiManager.this.handler.removeMessages(15, (Object)zzb2);
                GoogleApiManager.this.handler.removeMessages(16, (Object)zzb2);
                Feature feature = zzb2.zzdr;
                zza zza2 = this;
                ArrayList<com.google.android.gms.common.api.internal.zzb> arrayList = new ArrayList<com.google.android.gms.common.api.internal.zzb>(zza2.zzjz.size());
                for (com.google.android.gms.common.api.internal.zzb zzb3 : zza2.zzjz) {
                    Object[] objectArray;
                    if (!(zzb3 instanceof zzf) || (objectArray = ((zzf)zzb3).getRequiredFeatures()) == null || !ArrayUtils.contains((Object[])objectArray, (Object)feature)) continue;
                    arrayList.add(zzb3);
                }
                ArrayList<com.google.android.gms.common.api.internal.zzb> arrayList2 = arrayList;
                int n = arrayList2.size();
                for (int i = 0; i < n; ++i) {
                    com.google.android.gms.common.api.internal.zzb zzb3;
                    Object e = arrayList2.get(i);
                    zzb3 = (com.google.android.gms.common.api.internal.zzb)e;
                    zza2.zzjz.remove(zzb3);
                    zzb3.zza((RuntimeException)new UnsupportedApiCallException(feature));
                }
            }
        }

        static /* synthetic */ void zzc(zza zza2) {
            zza2.zzbj();
        }

        static /* synthetic */ void zzd(zza zza2) {
            zza2.zzbk();
        }

        static /* synthetic */ Api.Client zze(zza zza2) {
            return zza2.zzka;
        }
    }
}

