/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.accounts.Account;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.signin.GoogleSignInOptionsCreator;
import com.google.android.gms.auth.api.signin.GoogleSignInOptionsExtension;
import com.google.android.gms.auth.api.signin.internal.GoogleSignInOptionsExtensionParcelable;
import com.google.android.gms.auth.api.signin.internal.HashAccumulator;
import com.google.android.gms.auth.api.signin.zzb;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Class(creator="GoogleSignInOptionsCreator")
public class GoogleSignInOptions
extends AbstractSafeParcelable
implements Api.ApiOptions.Optional,
ReflectedParcelable {
    @VisibleForTesting
    public static final Scope SCOPE_PROFILE = new Scope("profile");
    @VisibleForTesting
    public static final Scope SCOPE_EMAIL = new Scope("email");
    @VisibleForTesting
    public static final Scope SCOPE_OPEN_ID = new Scope("openid");
    @VisibleForTesting
    public static final Scope SCOPE_GAMES_LITE = new Scope("https://www.googleapis.com/auth/games_lite");
    @VisibleForTesting
    public static final Scope SCOPE_GAMES = new Scope("https://www.googleapis.com/auth/games");
    public static final GoogleSignInOptions DEFAULT_SIGN_IN = new Builder().requestId().requestProfile().build();
    public static final GoogleSignInOptions DEFAULT_GAMES_SIGN_IN = new Builder().requestScopes(SCOPE_GAMES_LITE, new Scope[0]).build();
    public static final Parcelable.Creator<GoogleSignInOptions> CREATOR = new GoogleSignInOptionsCreator();
    @SafeParcelable.VersionField(id=1)
    private final int versionCode;
    @SafeParcelable.Field(id=2, getter="getScopes")
    private final ArrayList<Scope> zzr;
    @SafeParcelable.Field(id=3, getter="getAccount")
    private Account zzs;
    @SafeParcelable.Field(id=4, getter="isIdTokenRequested")
    private boolean zzt;
    @SafeParcelable.Field(id=5, getter="isServerAuthCodeRequested")
    private final boolean zzu;
    @SafeParcelable.Field(id=6, getter="isForceCodeForRefreshToken")
    private final boolean zzv;
    @SafeParcelable.Field(id=7, getter="getServerClientId")
    private String zzw;
    @SafeParcelable.Field(id=8, getter="getHostedDomain")
    private String zzx;
    @SafeParcelable.Field(id=9, getter="getExtensions")
    private ArrayList<GoogleSignInOptionsExtensionParcelable> zzy;
    private Map<Integer, GoogleSignInOptionsExtensionParcelable> zzz;
    private static Comparator<Scope> zzaa = new zzb();

    @Nullable
    public static GoogleSignInOptions fromJsonString(@Nullable String string) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(string);
        HashSet<Scope> hashSet = new HashSet<Scope>();
        JSONArray jSONArray = jSONObject.getJSONArray("scopes");
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            hashSet.add(new Scope(jSONArray.getString(i)));
        }
        Account account = null;
        String string2 = jSONObject.optString("accountName", null);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            account = new Account(string2, "com.google");
        }
        return new GoogleSignInOptions(3, new ArrayList<Scope>(hashSet), account, jSONObject.getBoolean("idTokenRequested"), jSONObject.getBoolean("serverAuthRequested"), jSONObject.getBoolean("forceCodeForRefreshToken"), jSONObject.optString("serverClientId", null), jSONObject.optString("hostedDomain", null), new HashMap<Integer, GoogleSignInOptionsExtensionParcelable>());
    }

    @SafeParcelable.Constructor
    GoogleSignInOptions(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) ArrayList<Scope> arrayList, @SafeParcelable.Param(id=3) Account account, @SafeParcelable.Param(id=4) boolean bl, @SafeParcelable.Param(id=5) boolean bl2, @SafeParcelable.Param(id=6) boolean bl3, @SafeParcelable.Param(id=7) String string, @SafeParcelable.Param(id=8) String string2, @SafeParcelable.Param(id=9) ArrayList<GoogleSignInOptionsExtensionParcelable> arrayList2) {
        this(n, arrayList, account, bl, bl2, bl3, string, string2, GoogleSignInOptions.zza(arrayList2));
    }

    private GoogleSignInOptions(int n, ArrayList<Scope> arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string, String string2, Map<Integer, GoogleSignInOptionsExtensionParcelable> map) {
        this.versionCode = n;
        this.zzr = arrayList;
        this.zzs = account;
        this.zzt = bl;
        this.zzu = bl2;
        this.zzv = bl3;
        this.zzw = string;
        this.zzx = string2;
        this.zzy = new ArrayList<GoogleSignInOptionsExtensionParcelable>(map.values());
        this.zzz = map;
    }

    public ArrayList<Scope> getScopes() {
        return new ArrayList<Scope>(this.zzr);
    }

    public Scope[] getScopeArray() {
        return this.zzr.toArray(new Scope[this.zzr.size()]);
    }

    public Account getAccount() {
        return this.zzs;
    }

    public boolean isIdTokenRequested() {
        return this.zzt;
    }

    public boolean isServerAuthCodeRequested() {
        return this.zzu;
    }

    public boolean isForceCodeForRefreshToken() {
        return this.zzv;
    }

    public String getServerClientId() {
        return this.zzw;
    }

    public String getHostedDomain() {
        return this.zzx;
    }

    public ArrayList<GoogleSignInOptionsExtensionParcelable> getExtensions() {
        return this.zzy;
    }

    public boolean hasExtension(@GoogleSignInOptionsExtension.TypeId int n) {
        return this.zzz.containsKey(n);
    }

    public GoogleSignInOptionsExtensionParcelable getExtension(@GoogleSignInOptionsExtension.TypeId int n) {
        return this.zzz.get(n);
    }

    private static Map<Integer, GoogleSignInOptionsExtensionParcelable> zza(@Nullable List<GoogleSignInOptionsExtensionParcelable> list) {
        HashMap<Integer, GoogleSignInOptionsExtensionParcelable> hashMap = new HashMap<Integer, GoogleSignInOptionsExtensionParcelable>();
        if (list == null) {
            return hashMap;
        }
        for (GoogleSignInOptionsExtensionParcelable googleSignInOptionsExtensionParcelable : list) {
            hashMap.put(googleSignInOptionsExtensionParcelable.getType(), googleSignInOptionsExtensionParcelable);
        }
        return hashMap;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GoogleSignInOptions googleSignInOptions = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1, (int)googleSignInOptions.versionCode);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)2, googleSignInOptions.getScopes(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)3, (Parcelable)googleSignInOptions.getAccount(), (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)4, (boolean)googleSignInOptions.isIdTokenRequested());
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)5, (boolean)googleSignInOptions.isServerAuthCodeRequested());
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)6, (boolean)googleSignInOptions.isForceCodeForRefreshToken());
        SafeParcelWriter.writeString((Parcel)parcel2, (int)7, (String)googleSignInOptions.getServerClientId(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)8, (String)googleSignInOptions.getHostedDomain(), (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)9, googleSignInOptions.getExtensions(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            GoogleSignInOptions googleSignInOptions = (GoogleSignInOptions)object;
            if (this.zzy.size() > 0 || googleSignInOptions.zzy.size() > 0) {
                return false;
            }
            if (this.zzr.size() != googleSignInOptions.getScopes().size() || !this.zzr.containsAll(googleSignInOptions.getScopes())) {
                return false;
            }
            return (this.zzs == null ? googleSignInOptions.getAccount() == null : this.zzs.equals((Object)googleSignInOptions.getAccount())) && (TextUtils.isEmpty((CharSequence)this.zzw) ? TextUtils.isEmpty((CharSequence)googleSignInOptions.getServerClientId()) : this.zzw.equals(googleSignInOptions.getServerClientId())) && this.zzv == googleSignInOptions.isForceCodeForRefreshToken() && this.zzt == googleSignInOptions.isIdTokenRequested() && this.zzu == googleSignInOptions.isServerAuthCodeRequested();
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Scope> arrayList2 = this.zzr;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            Scope scope = arrayList2.get(i);
            Scope scope2 = scope;
            arrayList.add(scope2.getScopeUri());
        }
        Collections.sort(arrayList);
        return new HashAccumulator().addObject(arrayList).addObject(this.zzs).addObject(this.zzw).addBoolean(this.zzv).addBoolean(this.zzt).addBoolean(this.zzu).hash();
    }

    public String toJson() {
        return this.zza().toString();
    }

    private final JSONObject zza() {
        JSONObject jSONObject = new JSONObject();
        try {
            JSONArray jSONArray = new JSONArray();
            Collections.sort(this.zzr, zzaa);
            ArrayList<Scope> arrayList = this.zzr;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Scope scope = arrayList.get(i);
                Scope scope2 = scope;
                jSONArray.put((Object)scope2.getScopeUri());
            }
            jSONObject.put("scopes", (Object)jSONArray);
            if (this.zzs != null) {
                jSONObject.put("accountName", (Object)this.zzs.name);
            }
            jSONObject.put("idTokenRequested", this.zzt);
            jSONObject.put("forceCodeForRefreshToken", this.zzv);
            jSONObject.put("serverAuthRequested", this.zzu);
            if (!TextUtils.isEmpty((CharSequence)this.zzw)) {
                jSONObject.put("serverClientId", (Object)this.zzw);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzx)) {
                jSONObject.put("hostedDomain", (Object)this.zzx);
            }
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    /* synthetic */ GoogleSignInOptions(int n, ArrayList arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string, String string2, Map map, zzb zzb2) {
        this(3, (ArrayList<Scope>)arrayList, account, bl, bl2, bl3, string, string2, map);
    }

    public static final class Builder {
        private Set<Scope> mScopes = new HashSet<Scope>();
        private boolean zzu;
        private boolean zzv;
        private boolean zzt;
        private String zzw;
        private Account zzs;
        private String zzx;
        private Map<Integer, GoogleSignInOptionsExtensionParcelable> zzab = new HashMap<Integer, GoogleSignInOptionsExtensionParcelable>();

        public Builder() {
        }

        public Builder(@NonNull GoogleSignInOptions googleSignInOptions) {
            Preconditions.checkNotNull((Object)googleSignInOptions);
            this.mScopes = new HashSet<Scope>(googleSignInOptions.zzr);
            this.zzu = googleSignInOptions.zzu;
            this.zzv = googleSignInOptions.zzv;
            this.zzt = googleSignInOptions.zzt;
            this.zzw = googleSignInOptions.zzw;
            this.zzs = googleSignInOptions.zzs;
            this.zzx = googleSignInOptions.zzx;
            this.zzab = GoogleSignInOptions.zza(googleSignInOptions.zzy);
        }

        public final Builder requestId() {
            this.mScopes.add(SCOPE_OPEN_ID);
            return this;
        }

        public final Builder requestEmail() {
            this.mScopes.add(SCOPE_EMAIL);
            return this;
        }

        public final Builder requestProfile() {
            this.mScopes.add(SCOPE_PROFILE);
            return this;
        }

        public final Builder requestScopes(Scope scope, Scope ... scopeArray) {
            this.mScopes.add(scope);
            this.mScopes.addAll(Arrays.asList(scopeArray));
            return this;
        }

        public final Builder requestIdToken(String string) {
            this.zzt = true;
            this.zzw = this.zza(string);
            return this;
        }

        public final Builder requestPhatIdToken(String string) {
            return this.requestIdToken(string).requestProfile().requestEmail();
        }

        public final Builder requestServerAuthCode(String string) {
            return this.requestServerAuthCode(string, false);
        }

        public final Builder requestServerAuthCode(String string, boolean bl) {
            this.zzu = true;
            this.zzw = this.zza(string);
            this.zzv = bl;
            return this;
        }

        public final Builder setAccountName(String string) {
            this.zzs = new Account(Preconditions.checkNotEmpty((String)string), "com.google");
            return this;
        }

        public final Builder setAccount(Account account) {
            this.zzs = (Account)Preconditions.checkNotNull((Object)account);
            return this;
        }

        public final Builder setHostedDomain(String string) {
            this.zzx = Preconditions.checkNotEmpty((String)string);
            return this;
        }

        public final Builder addExtension(GoogleSignInOptionsExtension googleSignInOptionsExtension) {
            if (this.zzab.containsKey(googleSignInOptionsExtension.getExtensionType())) {
                throw new IllegalStateException("Only one extension per type may be added");
            }
            if (googleSignInOptionsExtension.getImpliedScopes() != null) {
                this.mScopes.addAll(googleSignInOptionsExtension.getImpliedScopes());
            }
            this.zzab.put(googleSignInOptionsExtension.getExtensionType(), new GoogleSignInOptionsExtensionParcelable(googleSignInOptionsExtension));
            return this;
        }

        public final GoogleSignInOptions build() {
            if (this.mScopes.contains(SCOPE_GAMES) && this.mScopes.contains(SCOPE_GAMES_LITE)) {
                this.mScopes.remove(SCOPE_GAMES_LITE);
            }
            if (this.zzt && (this.zzs == null || !this.mScopes.isEmpty())) {
                this.requestId();
            }
            return new GoogleSignInOptions(3, new ArrayList<Scope>(this.mScopes), this.zzs, this.zzt, this.zzu, this.zzv, this.zzw, this.zzx, this.zzab, null);
        }

        private final String zza(String string) {
            Preconditions.checkNotEmpty((String)string);
            Preconditions.checkArgument((this.zzw == null || this.zzw.equals(string) ? 1 : 0) != 0, (Object)"two different server client ids provided");
            return string;
        }
    }
}

