/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.server.response;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.server.response.FastJsonResponse;
import com.google.android.gms.common.server.response.FieldMapPairCreator;
import com.google.android.gms.common.server.response.FieldMappingDictionaryCreator;
import com.google.android.gms.common.server.response.FieldMappingDictionaryEntryCreator;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@SafeParcelable.Class(creator="FieldMappingDictionaryCreator")
public class FieldMappingDictionary
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<FieldMappingDictionary> CREATOR = new FieldMappingDictionaryCreator();
    @SafeParcelable.VersionField(id=1)
    private final int zzal;
    private final HashMap<String, Map<String, FastJsonResponse.Field<?, ?>>> zzxk;
    @SafeParcelable.Field(id=2, getter="getSerializedDictionary")
    private final ArrayList<Entry> zzxl;
    @SafeParcelable.Field(id=3, getter="getRootClassName")
    private final String zzxm;

    @SafeParcelable.Constructor
    FieldMappingDictionary(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) ArrayList<Entry> arrayList, @SafeParcelable.Param(id=3) String string2) {
        this.zzal = n;
        this.zzxl = null;
        ArrayList<Entry> arrayList2 = arrayList;
        HashMap hashMap = new HashMap();
        int n2 = arrayList2.size();
        for (int i = 0; i < n2; ++i) {
            Entry entry = arrayList2.get(i);
            String string3 = entry.className;
            Entry entry2 = entry;
            HashMap hashMap2 = new HashMap();
            int n3 = entry2.zzxn.size();
            for (int j = 0; j < n3; ++j) {
                FieldMapPair fieldMapPair = entry2.zzxn.get(j);
                hashMap2.put(fieldMapPair.zzxo, fieldMapPair.zzxp);
            }
            hashMap.put(string3, hashMap2);
        }
        this.zzxk = hashMap;
        this.zzxm = (String)Preconditions.checkNotNull((Object)string2);
        this.linkFields();
    }

    public void linkFields() {
        for (String string2 : this.zzxk.keySet()) {
            Map<String, FastJsonResponse.Field<?, ?>> map = this.zzxk.get(string2);
            for (String string3 : map.keySet()) {
                map.get(string3).setFieldMappingDictionary(this);
            }
        }
    }

    public void copyInternalFieldMappings() {
        for (String string2 : this.zzxk.keySet()) {
            Map<String, FastJsonResponse.Field<?, ?>> map = this.zzxk.get(string2);
            HashMap hashMap = new HashMap();
            for (String string3 : map.keySet()) {
                FastJsonResponse.Field<?, ?> field = map.get(string3);
                hashMap.put(string3, field.copyForDictionary());
            }
            this.zzxk.put(string2, hashMap);
        }
    }

    public FieldMappingDictionary(Class<? extends FastJsonResponse> clazz) {
        this.zzal = 1;
        this.zzxl = null;
        this.zzxk = new HashMap();
        this.zzxm = clazz.getCanonicalName();
    }

    public void put(Class<? extends FastJsonResponse> clazz, Map<String, FastJsonResponse.Field<?, ?>> map) {
        this.zzxk.put(clazz.getCanonicalName(), map);
    }

    @VisibleForTesting
    public Map<String, FastJsonResponse.Field<?, ?>> getFieldMapping(Class<? extends FastJsonResponse> clazz) {
        return this.zzxk.get(clazz.getCanonicalName());
    }

    public Map<String, FastJsonResponse.Field<?, ?>> getFieldMapping(String string2) {
        return this.zzxk.get(string2);
    }

    public boolean hasFieldMappingForClass(Class<? extends FastJsonResponse> clazz) {
        return this.zzxk.containsKey(clazz.getCanonicalName());
    }

    public String getRootClassName() {
        return this.zzxm;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : this.zzxk.keySet()) {
            stringBuilder.append(string2).append(":\n");
            Map<String, FastJsonResponse.Field<?, ?>> map = this.zzxk.get(string2);
            for (String string3 : map.keySet()) {
                stringBuilder.append("  ").append(string3).append(": ");
                stringBuilder.append(map.get(string3));
            }
        }
        return stringBuilder.toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        FieldMappingDictionary fieldMappingDictionary = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1, (int)fieldMappingDictionary.zzal);
        FieldMappingDictionary fieldMappingDictionary2 = fieldMappingDictionary;
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        for (String string2 : fieldMappingDictionary2.zzxk.keySet()) {
            Entry entry = new Entry(string2, fieldMappingDictionary2.zzxk.get(string2));
            arrayList.add(entry);
        }
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)2, arrayList, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)fieldMappingDictionary.getRootClassName(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @SafeParcelable.Class(creator="FieldMapPairCreator")
    public static class FieldMapPair
    extends AbstractSafeParcelable {
        public static final Parcelable.Creator<FieldMapPair> CREATOR = new FieldMapPairCreator();
        @SafeParcelable.VersionField(id=1)
        private final int versionCode;
        @SafeParcelable.Field(id=2)
        final String zzxo;
        @SafeParcelable.Field(id=3)
        final FastJsonResponse.Field<?, ?> zzxp;

        @SafeParcelable.Constructor
        FieldMapPair(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) String string2, @SafeParcelable.Param(id=3) FastJsonResponse.Field<?, ?> field) {
            this.versionCode = n;
            this.zzxo = string2;
            this.zzxp = field;
        }

        FieldMapPair(String string2, FastJsonResponse.Field<?, ?> field) {
            this.versionCode = 1;
            this.zzxo = string2;
            this.zzxp = field;
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            FieldMapPair fieldMapPair = this;
            int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
            SafeParcelWriter.writeInt((Parcel)parcel2, (int)1, (int)fieldMapPair.versionCode);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)fieldMapPair.zzxo, (boolean)false);
            SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)3, fieldMapPair.zzxp, (int)n, (boolean)false);
            SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
        }
    }

    @SafeParcelable.Class(creator="FieldMappingDictionaryEntryCreator")
    public static class Entry
    extends AbstractSafeParcelable {
        public static final Parcelable.Creator<Entry> CREATOR = new FieldMappingDictionaryEntryCreator();
        @SafeParcelable.VersionField(id=1)
        private final int versionCode;
        @SafeParcelable.Field(id=2)
        final String className;
        @SafeParcelable.Field(id=3)
        final ArrayList<FieldMapPair> zzxn;

        @SafeParcelable.Constructor
        Entry(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) String string2, @SafeParcelable.Param(id=3) ArrayList<FieldMapPair> arrayList) {
            this.versionCode = n;
            this.className = string2;
            this.zzxn = arrayList;
        }

        Entry(String string2, Map<String, FastJsonResponse.Field<?, ?>> map) {
            ArrayList<FieldMapPair> arrayList;
            this.versionCode = 1;
            this.className = string2;
            Map<String, FastJsonResponse.Field<?, ?>> map2 = map;
            if (map2 == null) {
                arrayList = null;
            } else {
                ArrayList<FieldMapPair> arrayList2 = new ArrayList<FieldMapPair>();
                for (String string3 : map2.keySet()) {
                    FieldMapPair fieldMapPair = new FieldMapPair(string3, map2.get(string3));
                    arrayList2.add(fieldMapPair);
                }
                arrayList = arrayList2;
            }
            this.zzxn = arrayList;
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            Entry entry = this;
            int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
            SafeParcelWriter.writeInt((Parcel)parcel2, (int)1, (int)entry.versionCode);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)entry.className, (boolean)false);
            SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)3, entry.zzxn, (boolean)false);
            SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
        }
    }
}

