/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.common.data.AbstractDataBuffer;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.EntityBuffer;
import com.google.android.gms.common.data.FilteredDataBuffer;
import com.google.android.gms.common.data.TextFilterable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.ArrayList;
import java.util.Locale;

public final class TextFilteredDataBuffer<T>
extends FilteredDataBuffer<T>
implements TextFilterable {
    private AbstractDataBuffer<T> zzoc;
    private final String zzoo;
    private final ArrayList<Integer> zzob = new ArrayList();
    private String zzop;
    private TextFilterable.StringFilter zzoq;
    private Locale zzor;

    public TextFilteredDataBuffer(AbstractDataBuffer<T> abstractDataBuffer, String string2) {
        super(abstractDataBuffer);
        this.zzoc = abstractDataBuffer;
        this.zzoo = string2;
    }

    @Override
    public final int getCount() {
        if (TextUtils.isEmpty((CharSequence)this.zzop)) {
            return this.mDataBuffer.getCount();
        }
        return this.zzob.size();
    }

    @Override
    public final int computeRealPosition(int n) {
        if (TextUtils.isEmpty((CharSequence)this.zzop)) {
            return n;
        }
        if (n < 0 || n >= this.zzob.size()) {
            throw new IllegalArgumentException(new StringBuilder(53).append("Position ").append(n).append(" is out of bounds for this buffer").toString());
        }
        return this.zzob.get(n);
    }

    @Override
    @VisibleForTesting
    public final void setFilterTerm(Context context, String string2) {
        this.setFilterTerm(context, CONTAINS, string2);
    }

    @Override
    public final void setFilterTerm(Context context, TextFilterable.StringFilter stringFilter, String string2) {
        Preconditions.checkNotNull((Object)stringFilter);
        this.zzop = string2;
        this.zzoq = stringFilter;
        if (!TextUtils.isEmpty((CharSequence)this.zzop)) {
            this.zzor = context.getResources().getConfiguration().locale;
            this.zzop = this.zzh(this.zzop);
            TextFilteredDataBuffer textFilteredDataBuffer = this;
            textFilteredDataBuffer.zzob.clear();
            DataHolder dataHolder = textFilteredDataBuffer.zzoc.mDataHolder;
            String string3 = textFilteredDataBuffer.zzoo;
            boolean bl = textFilteredDataBuffer.zzoc instanceof EntityBuffer;
            int n = textFilteredDataBuffer.zzoc.getCount();
            for (int i = 0; i < n; ++i) {
                int n2;
                int n3 = bl ? ((EntityBuffer)textFilteredDataBuffer.zzoc).zzi(i) : i;
                String string4 = dataHolder.getString(string3, n3, n2 = dataHolder.getWindowIndex(n3));
                if (TextUtils.isEmpty((CharSequence)string4) || !textFilteredDataBuffer.zzoq.matches(textFilteredDataBuffer.zzh(string4), textFilteredDataBuffer.zzop)) continue;
                textFilteredDataBuffer.zzob.add(i);
            }
            return;
        }
        this.zzob.clear();
    }

    private final String zzh(String string2) {
        string2 = string2.toLowerCase(this.zzor);
        StringBuilder stringBuilder = new StringBuilder();
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isIdentifierIgnorable(string2.charAt(i))) continue;
            stringBuilder.append(string2.charAt(i));
        }
        return stringBuilder.toString();
    }
}

