/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.internal.LifecycleActivity;
import com.google.android.gms.common.api.internal.LifecycleCallback;
import com.google.android.gms.common.api.internal.LifecycleFragment;
import com.google.android.gms.common.api.internal.zzk;
import com.google.android.gms.common.api.internal.zzl;
import com.google.android.gms.common.internal.Preconditions;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class zzi
extends zzk {
    private final SparseArray<zza> zzed = new SparseArray();

    public static zzi zza(LifecycleActivity lifecycleActivity) {
        LifecycleFragment lifecycleFragment = zzi.getFragment((LifecycleActivity)lifecycleActivity);
        zzi zzi2 = (zzi)lifecycleFragment.getCallbackOrNull("AutoManageHelper", zzi.class);
        if (zzi2 != null) {
            return zzi2;
        }
        return new zzi(lifecycleFragment);
    }

    private zzi(LifecycleFragment lifecycleFragment) {
        super(lifecycleFragment);
        this.mLifecycleFragment.addCallback("AutoManageHelper", (LifecycleCallback)this);
    }

    public final void zza(int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        Preconditions.checkNotNull((Object)googleApiClient, (Object)"GoogleApiClient instance cannot be null");
        Preconditions.checkState((this.zzed.indexOfKey(n) < 0 ? 1 : 0) != 0, (Object)new StringBuilder(54).append("Already managing a GoogleApiClient with id ").append(n).toString());
        zzl zzl2 = (zzl)this.zzer.get();
        boolean bl = this.mStarted;
        String string2 = String.valueOf(zzl2);
        Log.d((String)"AutoManageHelper", (String)new StringBuilder(49 + String.valueOf(string2).length()).append("starting AutoManage for client ").append(n).append(" ").append(bl).append(" ").append(string2).toString());
        zza zza2 = new zza(n, googleApiClient, onConnectionFailedListener);
        this.zzed.put(n, (Object)zza2);
        if (this.mStarted && zzl2 == null) {
            string2 = String.valueOf(googleApiClient);
            Log.d((String)"AutoManageHelper", (String)new StringBuilder(11 + String.valueOf(string2).length()).append("connecting ").append(string2).toString());
            googleApiClient.connect();
        }
    }

    public final void zzc(int n) {
        zza zza2 = (zza)this.zzed.get(n);
        this.zzed.remove(n);
        if (zza2 != null) {
            zza zza3 = zza2;
            zza3.zzef.unregisterConnectionFailedListener(zza3);
            zza3.zzef.disconnect();
        }
    }

    @Override
    public final void onStart() {
        super.onStart();
        int n = this.mStarted;
        Object object = String.valueOf(this.zzed);
        Log.d((String)"AutoManageHelper", (String)new StringBuilder(14 + String.valueOf(object).length()).append("onStart ").append(n != 0).append(" ").append((String)object).toString());
        if (this.zzer.get() == null) {
            for (n = 0; n < this.zzed.size(); ++n) {
                object = this.zzd(n);
                if (object == null) continue;
                ((zza)object).zzef.connect();
            }
        }
    }

    @Override
    public void onStop() {
        super.onStop();
        for (int i = 0; i < this.zzed.size(); ++i) {
            zza zza2 = this.zzd(i);
            if (zza2 == null) continue;
            zza2.zzef.disconnect();
        }
    }

    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        for (int i = 0; i < this.zzed.size(); ++i) {
            zza zza2 = this.zzd(i);
            if (zza2 == null) continue;
            String[] stringArray2 = stringArray;
            PrintWriter printWriter2 = printWriter;
            FileDescriptor fileDescriptor2 = fileDescriptor;
            String string3 = string2;
            zza zza3 = zza2;
            printWriter2.append(string3).append("GoogleApiClient #").print(zza3.zzee);
            printWriter2.println(":");
            zza3.zzef.dump(String.valueOf(string3).concat("  "), fileDescriptor2, printWriter2, stringArray2);
        }
    }

    @Override
    protected final void zza(ConnectionResult connectionResult, int n) {
        Log.w((String)"AutoManageHelper", (String)"Unresolved error while connecting client. Stopping auto-manage.");
        if (n < 0) {
            Log.wtf((String)"AutoManageHelper", (String)"AutoManageLifecycleHelper received onErrorResolutionFailed callback but no failing client ID is set", (Throwable)new Exception());
            return;
        }
        zza zza2 = (zza)this.zzed.get(n);
        if (zza2 != null) {
            this.zzc(n);
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = zza2.zzeg;
            if (onConnectionFailedListener != null) {
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
    }

    @Override
    protected final void zzr() {
        for (int i = 0; i < this.zzed.size(); ++i) {
            zza zza2 = this.zzd(i);
            if (zza2 == null) continue;
            zza2.zzef.connect();
        }
    }

    @Nullable
    private final zza zzd(int n) {
        if (this.zzed.size() <= n) {
            return null;
        }
        return (zza)this.zzed.get(this.zzed.keyAt(n));
    }

    private final class zza
    implements GoogleApiClient.OnConnectionFailedListener {
        public final int zzee;
        public final GoogleApiClient zzef;
        public final GoogleApiClient.OnConnectionFailedListener zzeg;

        public zza(int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            this.zzee = n;
            this.zzef = googleApiClient;
            this.zzeg = onConnectionFailedListener;
            googleApiClient.registerConnectionFailedListener(this);
        }

        @Override
        public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            String string2 = String.valueOf(connectionResult);
            Log.d((String)"AutoManageHelper", (String)new StringBuilder(27 + String.valueOf(string2).length()).append("beginFailureResolution for ").append(string2).toString());
            zzi.this.zzb(connectionResult, this.zzee);
        }
    }
}

