/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.internal.zzh;
import com.google.android.gms.common.internal.Preconditions;
import java.util.ArrayList;

public class AvailabilityException
extends Exception {
    private final ArrayMap<zzh<?>, ConnectionResult> zzcc;

    public AvailabilityException(ArrayMap<zzh<?>, ConnectionResult> arrayMap) {
        this.zzcc = arrayMap;
    }

    public ConnectionResult getConnectionResult(GoogleApi<? extends Api.ApiOptions> googleApi) {
        zzh<? extends Api.ApiOptions> zzh2 = googleApi.zzm();
        Preconditions.checkArgument((this.zzcc.get(zzh2) != null ? 1 : 0) != 0, (Object)"The given API was not part of the availability request.");
        return (ConnectionResult)this.zzcc.get(zzh2);
    }

    public final ArrayMap<zzh<?>, ConnectionResult> zzl() {
        return this.zzcc;
    }

    @Override
    public String getMessage() {
        boolean bl = true;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (zzh zzh2 : this.zzcc.keySet()) {
            ConnectionResult connectionResult = (ConnectionResult)this.zzcc.get((Object)zzh2);
            if (connectionResult.isSuccess()) {
                bl = false;
            }
            String string2 = zzh2.zzq();
            String string3 = String.valueOf(connectionResult);
            arrayList.add(new StringBuilder(2 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(": ").append(string3).toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("None of the queried APIs are available. ");
        } else {
            stringBuilder.append("Some of the queried APIs are unavailable. ");
        }
        stringBuilder.append(TextUtils.join((CharSequence)"; ", arrayList));
        return stringBuilder.toString();
    }
}

