/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.support.annotation.Nullable;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzan;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzp;
import com.google.android.gms.common.internal.zzr;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class Api<O extends ApiOptions> {
    private final zza<?, O> zzfsa;
    private final zzh<?, O> zzfsb;
    private final zzf<?> zzfsc;
    private final zzi<?> zzfsd;
    private final String mName;

    @Hide
    public <C extends zze> Api(String string2, zza<C, O> zza2, zzf<C> zzf2) {
        zzbq.checkNotNull(zza2, (Object)"Cannot construct an Api with a null ClientBuilder");
        zzbq.checkNotNull(zzf2, (Object)"Cannot construct an Api with a null ClientKey");
        this.mName = string2;
        this.zzfsa = zza2;
        this.zzfsb = null;
        this.zzfsc = zzf2;
        this.zzfsd = null;
    }

    @Hide
    public final zzd<?, O> zzahk() {
        return this.zzfsa;
    }

    @Hide
    public final zza<?, O> zzahl() {
        zzbq.zza((this.zzfsa != null ? 1 : 0) != 0, (Object)"This API was constructed with a SimpleClientBuilder. Use getSimpleClientBuilder");
        return this.zzfsa;
    }

    @Hide
    public final zzc<?> zzahm() {
        if (this.zzfsc != null) {
            return this.zzfsc;
        }
        throw new IllegalStateException("This API was constructed with null client keys. This should not be possible.");
    }

    @Hide
    public final String getName() {
        return this.mName;
    }

    @Hide
    public static interface zzg<T extends IInterface>
    extends zzb {
    }

    @Hide
    public static interface zze
    extends zzb {
        public void zza(zzj var1);

        public void disconnect();

        public boolean isConnected();

        public boolean isConnecting();

        public void zza(zzan var1, Set<Scope> var2);

        public boolean zzacc();

        public void zza(zzp var1);

        public boolean zzahn();

        public boolean zzacn();

        public Intent getSignInIntent();

        public void dump(String var1, FileDescriptor var2, PrintWriter var3, String[] var4);

        @Nullable
        public IBinder zzaho();

        @Hide
        public String zzahp();

        @Hide
        public int zzahq();
    }

    @Hide
    public static interface zzb {
    }

    @Hide
    public static final class zzi<C extends zzg>
    extends zzc<C> {
    }

    @Hide
    public static final class zzf<C extends zze>
    extends zzc<C> {
    }

    @Hide
    public static class zzc<C extends zzb> {
    }

    public static interface ApiOptions {

        public static final class NoOptions
        implements NotRequiredOptions {
            private NoOptions() {
            }
        }

        public static interface HasGoogleSignInAccountOptions
        extends HasOptions {
            public GoogleSignInAccount getGoogleSignInAccount();
        }

        public static interface HasAccountOptions
        extends HasOptions,
        NotRequiredOptions {
            public Account getAccount();
        }

        public static interface Optional
        extends HasOptions,
        NotRequiredOptions {
        }

        public static interface HasOptions
        extends ApiOptions {
        }

        public static interface NotRequiredOptions
        extends ApiOptions {
        }
    }

    @Hide
    public static abstract class zzh<T extends zzg, O>
    extends zzd<T, O> {
    }

    @Hide
    public static abstract class zza<T extends zze, O>
    extends zzd<T, O> {
        @Hide
        public abstract T zza(Context var1, Looper var2, zzr var3, O var4, GoogleApiClient.ConnectionCallbacks var5, GoogleApiClient.OnConnectionFailedListener var6);
    }

    @Hide
    public static abstract class zzd<T extends zzb, O> {
        public int getPriority() {
            return Integer.MAX_VALUE;
        }

        public List<Scope> zzr(O o) {
            return Collections.emptyList();
        }
    }
}

