/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.Looper;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.OptionalPendingResult;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BasePendingResult;
import com.google.android.gms.common.api.internal.zzco;
import com.google.android.gms.common.api.internal.zzdb;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;

public final class PendingResults {
    public static PendingResult<Status> immediatePendingResult(Status status) {
        zzbq.zza((Object)status, (Object)"Result must not be null");
        zzdb zzdb2 = new zzdb(Looper.getMainLooper());
        zzdb2.zza(status);
        return zzdb2;
    }

    @Hide
    public static PendingResult<Status> zza(Status status, GoogleApiClient googleApiClient) {
        zzbq.zza((Object)status, (Object)"Result must not be null");
        zzdb zzdb2 = new zzdb(googleApiClient);
        zzdb2.zza(status);
        return zzdb2;
    }

    @Hide
    public static <R extends Result> PendingResult<R> zza(R r, GoogleApiClient googleApiClient) {
        zzbq.zza(r, (Object)"Result must not be null");
        zzbq.zzb((!r.getStatus().isSuccess() ? 1 : 0) != 0, (Object)"Status code must not be SUCCESS");
        zzb<R> zzb2 = new zzb<R>(googleApiClient, r);
        zzb2.zza(r);
        return zzb2;
    }

    public static <R extends Result> OptionalPendingResult<R> immediatePendingResult(R r) {
        zzbq.zza(r, (Object)"Result must not be null");
        zzc<R> zzc2 = new zzc<R>(null);
        zzc2.zza(r);
        return new zzco(zzc2);
    }

    @Hide
    public static <R extends Result> OptionalPendingResult<R> zzb(R r, GoogleApiClient googleApiClient) {
        zzbq.zza(r, (Object)"Result must not be null");
        zzc<R> zzc2 = new zzc<R>(googleApiClient);
        zzc2.zza(r);
        return new zzco(zzc2);
    }

    public static PendingResult<Status> canceledPendingResult() {
        zzdb zzdb2 = new zzdb(Looper.getMainLooper());
        ((PendingResult)zzdb2).cancel();
        return zzdb2;
    }

    public static <R extends Result> PendingResult<R> canceledPendingResult(R r) {
        zzbq.zza(r, (Object)"Result must not be null");
        zzbq.zzb((r.getStatus().getStatusCode() == 16 ? 1 : 0) != 0, (Object)"Status code must be CommonStatusCodes.CANCELED");
        zza<R> zza2 = new zza<R>(r);
        ((PendingResult)zza2).cancel();
        return zza2;
    }

    private PendingResults() {
    }

    static final class zza<R extends Result>
    extends BasePendingResult<R> {
        private final R zza;

        public zza(R r) {
            super(Looper.getMainLooper());
            this.zza = r;
        }

        @Override
        protected final R zza(Status status) {
            if (status.getStatusCode() != this.zza.getStatus().getStatusCode()) {
                throw new UnsupportedOperationException("Creating failed results is not supported");
            }
            return this.zza;
        }
    }

    static final class zzb<R extends Result>
    extends BasePendingResult<R> {
        private final R zza;

        public zzb(GoogleApiClient googleApiClient, R r) {
            super(googleApiClient);
            this.zza = r;
        }

        @Override
        protected final R zza(Status status) {
            return this.zza;
        }
    }

    static final class zzc<R extends Result>
    extends BasePendingResult<R> {
        public zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        @Override
        protected final R zza(Status status) {
            throw new UnsupportedOperationException("Creating failed results is not supported");
        }
    }
}

