/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.accounts.Account;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.signin.GoogleSignInOptionsExtension;
import com.google.android.gms.auth.api.signin.internal.zzo;
import com.google.android.gms.auth.api.signin.internal.zzq;
import com.google.android.gms.auth.api.signin.zzd;
import com.google.android.gms.auth.api.signin.zze;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleSignInOptions
extends zzbgl
implements Api.ApiOptions.Optional,
ReflectedParcelable {
    @Hide
    public static final Scope zza = new Scope("profile");
    @Hide
    public static final Scope zzb = new Scope("email");
    @Hide
    public static final Scope zzc = new Scope("openid");
    @Hide
    public static final Scope zzd = new Scope("https://www.googleapis.com/auth/games_lite");
    @Hide
    public static final Scope zze = new Scope("https://www.googleapis.com/auth/games");
    public static final GoogleSignInOptions DEFAULT_SIGN_IN = new Builder().requestId().requestProfile().build();
    public static final GoogleSignInOptions DEFAULT_GAMES_SIGN_IN = new Builder().requestScopes(zzd, new Scope[0]).build();
    public static final Parcelable.Creator<GoogleSignInOptions> CREATOR = new zze();
    private int zzf;
    private final ArrayList<Scope> zzg;
    private Account zzh;
    private boolean zzi;
    private final boolean zzj;
    private final boolean zzk;
    private String zzl;
    private String zzm;
    private ArrayList<zzo> zzn;
    private Map<Integer, zzo> zzo;
    private static Comparator<Scope> zzp = new zzd();

    @Hide
    @Nullable
    public static GoogleSignInOptions zza(@Nullable String string2) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(string2);
        HashSet<Scope> hashSet = new HashSet<Scope>();
        JSONArray jSONArray = jSONObject.getJSONArray("scopes");
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            hashSet.add(new Scope(jSONArray.getString(i)));
        }
        Account account = null;
        String string3 = jSONObject.optString("accountName", null);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            account = new Account(string3, "com.google");
        }
        return new GoogleSignInOptions(3, new ArrayList<Scope>(hashSet), account, jSONObject.getBoolean("idTokenRequested"), jSONObject.getBoolean("serverAuthRequested"), jSONObject.getBoolean("forceCodeForRefreshToken"), jSONObject.optString("serverClientId", null), jSONObject.optString("hostedDomain", null), new HashMap<Integer, zzo>());
    }

    GoogleSignInOptions(int n, ArrayList<Scope> arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3, ArrayList<zzo> arrayList2) {
        this(n, arrayList, account, bl, bl2, bl3, string2, string3, GoogleSignInOptions.zzb(arrayList2));
    }

    private GoogleSignInOptions(int n, ArrayList<Scope> arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3, Map<Integer, zzo> map) {
        this.zzf = n;
        this.zzg = arrayList;
        this.zzh = account;
        this.zzi = bl;
        this.zzj = bl2;
        this.zzk = bl3;
        this.zzl = string2;
        this.zzm = string3;
        this.zzn = new ArrayList<zzo>(map.values());
        this.zzo = map;
    }

    @Hide
    public final ArrayList<Scope> zza() {
        return new ArrayList<Scope>(this.zzg);
    }

    public Scope[] getScopeArray() {
        return this.zzg.toArray(new Scope[this.zzg.size()]);
    }

    @Hide
    public final Account zzb() {
        return this.zzh;
    }

    @Hide
    public final boolean zzc() {
        return this.zzi;
    }

    @Hide
    public final boolean zzd() {
        return this.zzj;
    }

    @Hide
    public final String zze() {
        return this.zzl;
    }

    private static Map<Integer, zzo> zzb(@Nullable List<zzo> list) {
        HashMap<Integer, zzo> hashMap = new HashMap<Integer, zzo>();
        if (list == null) {
            return hashMap;
        }
        for (zzo zzo2 : list) {
            hashMap.put(zzo2.zza(), zzo2);
        }
        return hashMap;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GoogleSignInOptions googleSignInOptions = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (int)googleSignInOptions.zzf);
        zzbgo.zzc((Parcel)parcel2, (int)2, googleSignInOptions.zza(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (Parcelable)googleSignInOptions.zzh, (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (boolean)googleSignInOptions.zzi);
        zzbgo.zza((Parcel)parcel2, (int)5, (boolean)googleSignInOptions.zzj);
        zzbgo.zza((Parcel)parcel2, (int)6, (boolean)googleSignInOptions.zzk);
        zzbgo.zza((Parcel)parcel2, (int)7, (String)googleSignInOptions.zzl, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)8, (String)googleSignInOptions.zzm, (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)9, googleSignInOptions.zzn, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            GoogleSignInOptions googleSignInOptions = (GoogleSignInOptions)object;
            if (this.zzn.size() > 0 || googleSignInOptions.zzn.size() > 0) {
                return false;
            }
            if (this.zzg.size() != googleSignInOptions.zza().size() || !this.zzg.containsAll(googleSignInOptions.zza())) {
                return false;
            }
            return (this.zzh == null ? googleSignInOptions.zzh == null : this.zzh.equals((Object)googleSignInOptions.zzh)) && (TextUtils.isEmpty((CharSequence)this.zzl) ? TextUtils.isEmpty((CharSequence)googleSignInOptions.zzl) : this.zzl.equals(googleSignInOptions.zzl)) && this.zzk == googleSignInOptions.zzk && this.zzi == googleSignInOptions.zzi && this.zzj == googleSignInOptions.zzj;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Scope> arrayList2 = this.zzg;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            Scope scope = arrayList2.get(i);
            Scope scope2 = scope;
            arrayList.add(scope2.zza());
        }
        Collections.sort(arrayList);
        return new zzq().zza(arrayList).zza(this.zzh).zza(this.zzl).zza(this.zzk).zza(this.zzi).zza(this.zzj).zza();
    }

    @Hide
    public final String zzf() {
        return this.zzg().toString();
    }

    private final JSONObject zzg() {
        JSONObject jSONObject = new JSONObject();
        try {
            JSONArray jSONArray = new JSONArray();
            Collections.sort(this.zzg, zzp);
            ArrayList<Scope> arrayList = this.zzg;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Scope scope = arrayList.get(i);
                Scope scope2 = scope;
                jSONArray.put((Object)scope2.zza());
            }
            jSONObject.put("scopes", (Object)jSONArray);
            if (this.zzh != null) {
                jSONObject.put("accountName", (Object)this.zzh.name);
            }
            jSONObject.put("idTokenRequested", this.zzi);
            jSONObject.put("forceCodeForRefreshToken", this.zzk);
            jSONObject.put("serverAuthRequested", this.zzj);
            if (!TextUtils.isEmpty((CharSequence)this.zzl)) {
                jSONObject.put("serverClientId", (Object)this.zzl);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzm)) {
                jSONObject.put("hostedDomain", (Object)this.zzm);
            }
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    /* synthetic */ GoogleSignInOptions(int n, ArrayList arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3, Map map, zzd zzd2) {
        this(3, (ArrayList<Scope>)arrayList, account, bl, bl2, bl3, string2, string3, map);
    }

    public static final class Builder {
        private Set<Scope> zza = new HashSet<Scope>();
        private boolean zzb;
        private boolean zzc;
        private boolean zzd;
        private String zze;
        private Account zzf;
        private String zzg;
        private Map<Integer, zzo> zzh = new HashMap<Integer, zzo>();

        public Builder() {
        }

        public Builder(@NonNull GoogleSignInOptions googleSignInOptions) {
            zzbq.zza((Object)googleSignInOptions);
            this.zza = new HashSet<Scope>(googleSignInOptions.zzg);
            this.zzb = googleSignInOptions.zzj;
            this.zzc = googleSignInOptions.zzk;
            this.zzd = googleSignInOptions.zzi;
            this.zze = googleSignInOptions.zzl;
            this.zzf = googleSignInOptions.zzh;
            this.zzg = googleSignInOptions.zzm;
            this.zzh = GoogleSignInOptions.zzb(googleSignInOptions.zzn);
        }

        public final Builder requestId() {
            this.zza.add(zzc);
            return this;
        }

        public final Builder requestEmail() {
            this.zza.add(zzb);
            return this;
        }

        public final Builder requestProfile() {
            this.zza.add(zza);
            return this;
        }

        public final Builder requestScopes(Scope scope, Scope ... scopeArray) {
            this.zza.add(scope);
            this.zza.addAll(Arrays.asList(scopeArray));
            return this;
        }

        public final Builder requestIdToken(String string2) {
            this.zzd = true;
            this.zze = this.zza(string2);
            return this;
        }

        public final Builder requestServerAuthCode(String string2) {
            return this.requestServerAuthCode(string2, false);
        }

        public final Builder requestServerAuthCode(String string2, boolean bl) {
            this.zzb = true;
            this.zze = this.zza(string2);
            this.zzc = bl;
            return this;
        }

        public final Builder setAccountName(String string2) {
            this.zzf = new Account(zzbq.zza((String)string2), "com.google");
            return this;
        }

        public final Builder setHostedDomain(String string2) {
            this.zzg = zzbq.zza((String)string2);
            return this;
        }

        public final Builder addExtension(GoogleSignInOptionsExtension googleSignInOptionsExtension) {
            if (this.zzh.containsKey(googleSignInOptionsExtension.getExtensionType())) {
                throw new IllegalStateException("Only one extension per type may be added");
            }
            if (googleSignInOptionsExtension.getImpliedScopes() != null) {
                this.zza.addAll(googleSignInOptionsExtension.getImpliedScopes());
            }
            this.zzh.put(googleSignInOptionsExtension.getExtensionType(), new zzo(googleSignInOptionsExtension));
            return this;
        }

        public final GoogleSignInOptions build() {
            if (this.zza.contains(zze) && this.zza.contains(zzd)) {
                this.zza.remove(zzd);
            }
            if (this.zzd && (this.zzf == null || !this.zza.isEmpty())) {
                this.requestId();
            }
            return new GoogleSignInOptions(3, new ArrayList<Scope>(this.zza), this.zzf, this.zzd, this.zzb, this.zzc, this.zze, this.zzg, this.zzh, null);
        }

        private final String zza(String string2) {
            zzbq.zza((String)string2);
            zzbq.zzb((this.zze == null || this.zze.equals(string2) ? 1 : 0) != 0, (Object)"two different server client ids provided");
            return string2;
        }
    }
}

