/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.images.zze;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import java.util.Arrays;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class WebImage
extends zzbfm {
    public static final Parcelable.Creator<WebImage> CREATOR = new zze();
    private int zzeck;
    private final Uri zzfap;
    private final int zzalv;
    private final int zzalw;

    WebImage(int n, Uri uri, int n2, int n3) {
        this.zzeck = n;
        this.zzfap = uri;
        this.zzalv = n2;
        this.zzalw = n3;
    }

    public WebImage(Uri uri, int n, int n2) throws IllegalArgumentException {
        this(1, uri, n, n2);
        if (uri == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("width and height must not be negative");
        }
    }

    public WebImage(Uri uri) throws IllegalArgumentException {
        this(uri, 0, 0);
    }

    public WebImage(JSONObject jSONObject) throws IllegalArgumentException {
        this(WebImage.zzy(jSONObject), jSONObject.optInt("width", 0), jSONObject.optInt("height", 0));
    }

    private static Uri zzy(JSONObject jSONObject) {
        Uri uri = null;
        if (jSONObject.has("url")) {
            try {
                uri = Uri.parse((String)jSONObject.getString("url"));
            }
            catch (JSONException jSONException) {}
        }
        return uri;
    }

    public final Uri getUrl() {
        return this.zzfap;
    }

    public final int getWidth() {
        return this.zzalv;
    }

    public final int getHeight() {
        return this.zzalw;
    }

    public final String toString() {
        return String.format(Locale.US, "Image %dx%d %s", this.zzalv, this.zzalw, this.zzfap.toString());
    }

    public final JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("url", (Object)this.zzfap.toString());
            jSONObject.put("width", this.zzalv);
            jSONObject.put("height", this.zzalw);
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof WebImage)) {
            return false;
        }
        WebImage webImage = (WebImage)((Object)object);
        return zzbg.equal((Object)this.zzfap, (Object)webImage.zzfap) && this.zzalv == webImage.zzalv && this.zzalw == webImage.zzalw;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzfap, this.zzalv, this.zzalw});
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        WebImage webImage = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zzc((Parcel)parcel2, (int)1, (int)webImage.zzeck);
        zzbfp.zza((Parcel)parcel2, (int)2, (Parcelable)webImage.getUrl(), (int)n, (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)3, (int)webImage.getWidth());
        zzbfp.zzc((Parcel)parcel2, (int)4, (int)webImage.getHeight());
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }
}

