/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultCallbacks;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.api.internal.zzcs;
import com.google.android.gms.common.api.internal.zzdh;
import com.google.android.gms.common.api.internal.zzdi;
import com.google.android.gms.common.internal.zzbq;
import java.lang.ref.WeakReference;

public final class zzdg<R extends Result>
extends TransformedResult<R>
implements ResultCallback<R> {
    private ResultTransform<? super R, ? extends Result> zzfux = null;
    private zzdg<? extends Result> zzfuy = null;
    private volatile ResultCallbacks<? super R> zzfuz = null;
    private PendingResult<R> zzfva = null;
    private final Object zzfou = new Object();
    private Status zzfvb = null;
    private final WeakReference<GoogleApiClient> zzfow;
    private final zzdi zzfvc;
    private boolean zzfvd = false;

    public zzdg(WeakReference<GoogleApiClient> weakReference) {
        zzbq.checkNotNull(weakReference, (Object)"GoogleApiClient reference must not be null");
        this.zzfow = weakReference;
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzfow.get();
        this.zzfvc = new zzdi(this, googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public final <S extends Result> TransformedResult<S> then(@NonNull ResultTransform<? super R, ? extends S> resultTransform) {
        Object object = this.zzfou;
        synchronized (object) {
            zzbq.zza((this.zzfux == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            zzbq.zza((this.zzfuz == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zzfux = resultTransform;
            zzdg<R> zzdg2 = new zzdg<R>(this.zzfow);
            this.zzfuy = zzdg2;
            this.zzajr();
            return zzdg2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void andFinally(@NonNull ResultCallbacks<? super R> resultCallbacks) {
        Object object = this.zzfou;
        synchronized (object) {
            zzbq.zza((this.zzfuz == null ? 1 : 0) != 0, (Object)"Cannot call andFinally() twice.");
            zzbq.zza((this.zzfux == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zzfuz = resultCallbacks;
            this.zzajr();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onResult(R r) {
        Object object = this.zzfou;
        synchronized (object) {
            if (r.getStatus().isSuccess()) {
                if (this.zzfux != null) {
                    zzcs.zzaip().submit(new zzdh(this, (Result)r));
                } else if (this.zzajt()) {
                    this.zzfuz.onSuccess(r);
                }
            } else {
                this.zzd(r.getStatus());
                zzdg.zzd(r);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(PendingResult<?> pendingResult) {
        Object object = this.zzfou;
        synchronized (object) {
            this.zzfva = pendingResult;
            this.zzajr();
            return;
        }
    }

    private final void zzajr() {
        if (this.zzfux == null && this.zzfuz == null) {
            return;
        }
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzfow.get();
        if (!this.zzfvd && this.zzfux != null && googleApiClient != null) {
            googleApiClient.zza(this);
            this.zzfvd = true;
        }
        if (this.zzfvb != null) {
            this.zzx(this.zzfvb);
            return;
        }
        if (this.zzfva != null) {
            this.zzfva.setResultCallback(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzd(Status status) {
        Object object = this.zzfou;
        synchronized (object) {
            this.zzfvb = status;
            this.zzx(this.zzfvb);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzx(Status status) {
        Object object = this.zzfou;
        synchronized (object) {
            if (this.zzfux != null) {
                Status status2 = this.zzfux.onFailure(status);
                zzbq.checkNotNull((Object)status2, (Object)"onFailure must not return null");
                super.zzd(status2);
            } else if (this.zzajt()) {
                this.zzfuz.onFailure(status);
            }
            return;
        }
    }

    final void zzajs() {
        this.zzfuz = null;
    }

    private final boolean zzajt() {
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzfow.get();
        return this.zzfuz != null && googleApiClient != null;
    }

    private static void zzd(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
                return;
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"TransformedResultImpl", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    static /* synthetic */ ResultTransform zzc(zzdg zzdg2) {
        return zzdg2.zzfux;
    }

    static /* synthetic */ zzdi zzd(zzdg zzdg2) {
        return zzdg2.zzfvc;
    }

    static /* synthetic */ void zza(zzdg zzdg2, Result result) {
        zzdg.zzd(result);
    }

    static /* synthetic */ WeakReference zze(zzdg zzdg2) {
        return zzdg2.zzfow;
    }

    static /* synthetic */ Object zzf(zzdg zzdg2) {
        return zzdg2.zzfou;
    }

    static /* synthetic */ zzdg zzg(zzdg zzdg2) {
        return zzdg2.zzfuy;
    }

    static /* synthetic */ void zza(zzdg zzdg2, Status status) {
        zzdg2.zzd(status);
    }
}

