/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BasePendingResult;
import com.google.android.gms.common.api.internal.zzaa;
import com.google.android.gms.common.api.internal.zzbb;
import com.google.android.gms.common.api.internal.zzbc;
import com.google.android.gms.common.api.internal.zzbd;
import com.google.android.gms.common.api.internal.zzbe;
import com.google.android.gms.common.api.internal.zzbf;
import com.google.android.gms.common.api.internal.zzbg;
import com.google.android.gms.common.api.internal.zzbi;
import com.google.android.gms.common.api.internal.zzbx;
import com.google.android.gms.common.api.internal.zzcc;
import com.google.android.gms.common.api.internal.zzcd;
import com.google.android.gms.common.api.internal.zzce;
import com.google.android.gms.common.api.internal.zzci;
import com.google.android.gms.common.api.internal.zzcm;
import com.google.android.gms.common.api.internal.zzcu;
import com.google.android.gms.common.api.internal.zzda;
import com.google.android.gms.common.api.internal.zzdg;
import com.google.android.gms.common.api.internal.zzdj;
import com.google.android.gms.common.api.internal.zzdm;
import com.google.android.gms.common.api.internal.zzi;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.internal.zzt;
import com.google.android.gms.common.api.internal.zzv;
import com.google.android.gms.common.internal.zzae;
import com.google.android.gms.common.internal.zzaf;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.zzf;
import com.google.android.gms.internal.zzbft;
import com.google.android.gms.internal.zzcxd;
import com.google.android.gms.internal.zzcxe;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;

public final class zzba
extends GoogleApiClient
implements zzcd {
    private final Lock zzfps;
    private boolean zzfnc;
    private final zzae zzfru;
    private zzcc zzfrv = null;
    private final int zzfmw;
    private final Context mContext;
    private final Looper zzall;
    final Queue<zzm<?, ?>> zzfqg = new LinkedList();
    private volatile boolean zzfrw;
    private long zzfrx = 120000L;
    private long zzfry = 5000L;
    private final zzbf zzfrz;
    private final GoogleApiAvailability zzfmy;
    private zzbx zzfsa;
    final Map<Api.zzc<?>, Api.zze> zzfsb;
    Set<Scope> zzfsc = new HashSet<Scope>();
    private zzr zzfpx;
    private Map<Api<?>, Boolean> zzfqa;
    private Api.zza<? extends zzcxd, zzcxe> zzfmz;
    private final zzcm zzfsd = new zzcm();
    private final ArrayList<zzt> zzfse;
    private Integer zzfsf = null;
    Set<zzdg> zzfsg = null;
    final zzdj zzfsh;
    private final zzaf zzfsi = new zzbb(this);

    public zzba(Context context, Lock lock, Looper looper, zzr zzr2, GoogleApiAvailability googleApiAvailability, Api.zza<? extends zzcxd, zzcxe> zza2, Map<Api<?>, Boolean> map, List<GoogleApiClient.ConnectionCallbacks> list, List<GoogleApiClient.OnConnectionFailedListener> list2, Map<Api.zzc<?>, Api.zze> map2, int n, int n2, ArrayList<zzt> arrayList, boolean bl) {
        this.mContext = context;
        this.zzfps = lock;
        this.zzfnc = false;
        this.zzfru = new zzae(looper, this.zzfsi);
        this.zzall = looper;
        this.zzfrz = new zzbf(this, looper);
        this.zzfmy = googleApiAvailability;
        this.zzfmw = n;
        if (this.zzfmw >= 0) {
            this.zzfsf = n2;
        }
        this.zzfqa = map;
        this.zzfsb = map2;
        this.zzfse = arrayList;
        this.zzfsh = new zzdj(this.zzfsb);
        for (GoogleApiClient.ConnectionCallbacks object : list) {
            this.zzfru.registerConnectionCallbacks(object);
        }
        for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : list2) {
            this.zzfru.registerConnectionFailedListener(onConnectionFailedListener);
        }
        this.zzfpx = zzr2;
        this.zzfmz = zza2;
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzm<R, A>> T zzd(@NonNull T t) {
        zzbq.checkArgument((t.zzagf() != null ? 1 : 0) != 0, (Object)"This task can not be enqueued (it's probably a Batch or malformed)");
        String string2 = t.zzagl() != null ? t.zzagl().getName() : "the API";
        zzbq.checkArgument((boolean)this.zzfsb.containsKey(t.zzagf()), (Object)new StringBuilder(65 + String.valueOf(string2).length()).append("GoogleApiClient is not configured to use ").append(string2).append(" required for this call.").toString());
        this.zzfps.lock();
        try {
            if (this.zzfrv == null) {
                this.zzfqg.add(t);
                string2 = t;
                return (T)string2;
            }
            string2 = this.zzfrv.zzd(t);
            return (T)string2;
        }
        finally {
            this.zzfps.unlock();
        }
    }

    @Override
    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zze(@NonNull T t) {
        zzbq.checkArgument((t.zzagf() != null ? 1 : 0) != 0, (Object)"This task can not be executed (it's probably a Batch or malformed)");
        Object object = t.zzagl() != null ? t.zzagl().getName() : "the API";
        zzbq.checkArgument((boolean)this.zzfsb.containsKey(t.zzagf()), (Object)new StringBuilder(65 + String.valueOf(object).length()).append("GoogleApiClient is not configured to use ").append((String)object).append(" required for this call.").toString());
        this.zzfps.lock();
        try {
            if (this.zzfrv == null) {
                throw new IllegalStateException("GoogleApiClient is not connected yet.");
            }
            if (this.zzfrw) {
                this.zzfqg.add(t);
                while (!this.zzfqg.isEmpty()) {
                    object = this.zzfqg.remove();
                    this.zzfsh.zzb((BasePendingResult<? extends Result>)object);
                    ((zzm)object).zzu(Status.zzfnk);
                }
                object = t;
                return (T)object;
            }
            object = this.zzfrv.zze(t);
            return (T)object;
        }
        finally {
            this.zzfps.unlock();
        }
    }

    @Override
    public final <L> zzci<L> zzt(@NonNull L l) {
        this.zzfps.lock();
        try {
            Looper looper = this.zzall;
            L l2 = l;
            zzci<L> zzci2 = this.zzfsd.zza(l2, looper, "NO_TYPE");
            return zzci2;
        }
        finally {
            this.zzfps.unlock();
        }
    }

    @Override
    @NonNull
    public final <C extends Api.zze> C zza(@NonNull Api.zzc<C> zzc2) {
        Api.zze zze2 = this.zzfsb.get(zzc2);
        zzbq.checkNotNull((Object)zze2, (Object)"Appropriate Api was not requested.");
        return (C)zze2;
    }

    @Override
    public final boolean zza(@NonNull Api<?> api) {
        return this.zzfsb.containsKey(api.zzagf());
    }

    @Override
    public final boolean hasConnectedApi(@NonNull Api<?> api) {
        if (!((GoogleApiClient)this).isConnected()) {
            return false;
        }
        Api.zze zze2 = this.zzfsb.get(api.zzagf());
        return zze2 != null && zze2.isConnected();
    }

    @Override
    @NonNull
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        block6: {
            ConnectionResult connectionResult;
            block7: {
                block8: {
                    this.zzfps.lock();
                    if (!((GoogleApiClient)this).isConnected() && !this.zzfrw) {
                        throw new IllegalStateException("Cannot invoke getConnectionResult unless GoogleApiClient is connected");
                    }
                    if (!this.zzfsb.containsKey(api.zzagf())) break block6;
                    connectionResult = this.zzfrv.getConnectionResult(api);
                    if (connectionResult != null) break block7;
                    if (!this.zzfrw) break block8;
                    ConnectionResult connectionResult2 = ConnectionResult.zzfkr;
                    this.zzfps.unlock();
                    return connectionResult2;
                }
                Log.w((String)"GoogleApiClientImpl", (String)this.zzaim());
                Log.wtf((String)"GoogleApiClientImpl", (String)String.valueOf(api.getName()).concat(" requested in getConnectionResult is not connected but is not present in the failed  connections map"), (Throwable)new Exception());
                ConnectionResult connectionResult3 = new ConnectionResult(8, null);
                return connectionResult3;
            }
            ConnectionResult connectionResult4 = connectionResult;
            this.zzfps.unlock();
            return connectionResult4;
        }
        try {
            throw new IllegalArgumentException(String.valueOf(api.getName()).concat(" was never registered with GoogleApiClient"));
        }
        finally {
            this.zzfps.unlock();
        }
    }

    @Override
    public final void connect() {
        this.zzfps.lock();
        try {
            if (this.zzfmw >= 0) {
                zzbq.zza((this.zzfsf != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zzfsf == null) {
                this.zzfsf = zzba.zza(this.zzfsb.values(), false);
            } else if (this.zzfsf == 2) {
                throw new IllegalStateException("Cannot call connect() when SignInMode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            ((GoogleApiClient)this).connect(this.zzfsf);
            return;
        }
        finally {
            this.zzfps.unlock();
        }
    }

    @Override
    public final void connect(int n) {
        this.zzfps.lock();
        try {
            zzbq.checkArgument((n == 3 || n == 1 || n == 2 ? 1 : 0) != 0, (Object)new StringBuilder(33).append("Illegal sign-in mode: ").append(n).toString());
            this.zzbv(n);
            this.zzaii();
            return;
        }
        finally {
            this.zzfps.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect() {
        zzbq.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        this.zzfps.lock();
        try {
            if (this.zzfmw >= 0) {
                zzbq.zza((this.zzfsf != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zzfsf == null) {
                this.zzfsf = zzba.zza(this.zzfsb.values(), false);
            } else if (this.zzfsf == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zzbv(this.zzfsf);
            this.zzfru.zzalj();
            ConnectionResult connectionResult = this.zzfrv.blockingConnect();
            return connectionResult;
        }
        finally {
            this.zzfps.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        zzbq.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        zzbq.checkNotNull((Object)((Object)timeUnit), (Object)"TimeUnit must not be null");
        this.zzfps.lock();
        try {
            if (this.zzfsf == null) {
                this.zzfsf = zzba.zza(this.zzfsb.values(), false);
            } else if (this.zzfsf == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zzbv(this.zzfsf);
            this.zzfru.zzalj();
            ConnectionResult connectionResult = this.zzfrv.blockingConnect(l, timeUnit);
            return connectionResult;
        }
        finally {
            this.zzfps.unlock();
        }
    }

    @Override
    public final void disconnect() {
        this.zzfps.lock();
        try {
            this.zzfsh.release();
            if (this.zzfrv != null) {
                this.zzfrv.disconnect();
            }
            this.zzfsd.release();
            for (zzm zzm2 : this.zzfqg) {
                ((BasePendingResult)zzm2).zza((zzdm)null);
                ((PendingResult)zzm2).cancel();
            }
            this.zzfqg.clear();
            if (this.zzfrv == null) {
                return;
            }
            this.zzaik();
            this.zzfru.zzali();
            return;
        }
        finally {
            this.zzfps.unlock();
        }
    }

    @Override
    public final void reconnect() {
        ((GoogleApiClient)this).disconnect();
        ((GoogleApiClient)this).connect();
    }

    @Override
    public final PendingResult<Status> clearDefaultAccountAndReconnect() {
        zzbq.zza((boolean)((GoogleApiClient)this).isConnected(), (Object)"GoogleApiClient is not connected yet.");
        zzbq.zza((this.zzfsf != 2 ? 1 : 0) != 0, (Object)"Cannot use clearDefaultAccountAndReconnect with GOOGLE_SIGN_IN_API");
        zzda zzda2 = new zzda(this);
        if (this.zzfsb.containsKey(zzbft.zzebf)) {
            this.zza(this, zzda2, false);
        } else {
            AtomicReference<GoogleApiClient> atomicReference = new AtomicReference<GoogleApiClient>();
            zzbc zzbc2 = new zzbc(this, atomicReference, zzda2);
            zzbd zzbd2 = new zzbd(this, zzda2);
            GoogleApiClient googleApiClient = new GoogleApiClient.Builder(this.mContext).addApi(zzbft.API).addConnectionCallbacks(zzbc2).addOnConnectionFailedListener(zzbd2).setHandler(this.zzfrz).build();
            atomicReference.set(googleApiClient);
            googleApiClient.connect();
        }
        return zzda2;
    }

    private final void zza(GoogleApiClient googleApiClient, zzda zzda2, boolean bl) {
        zzbft.zzgbv.zzd(googleApiClient).setResultCallback(new zzbe(this, zzda2, bl, googleApiClient));
    }

    @Override
    public final void stopAutoManage(@NonNull FragmentActivity fragmentActivity) {
        zzce zzce2 = new zzce((Activity)fragmentActivity);
        zzba zzba2 = this;
        if (zzba2.zzfmw >= 0) {
            zzi.zza(zzce2).zzbr(zzba2.zzfmw);
            return;
        }
        throw new IllegalStateException("Called stopAutoManage but automatic lifecycle management is not enabled.");
    }

    @Override
    public final boolean isConnected() {
        return this.zzfrv != null && this.zzfrv.isConnected();
    }

    @Override
    public final boolean isConnecting() {
        return this.zzfrv != null && this.zzfrv.isConnecting();
    }

    private final void zzbv(int n) {
        if (this.zzfsf == null) {
            this.zzfsf = n;
        } else if (this.zzfsf != n) {
            String string2 = zzba.zzbw(n);
            String string3 = zzba.zzbw(this.zzfsf);
            throw new IllegalStateException(new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Cannot use sign-in mode: ").append(string2).append(". Mode was already set to ").append(string3).toString());
        }
        if (this.zzfrv != null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Api.zze zze2 : this.zzfsb.values()) {
            if (zze2.zzaay()) {
                bl = true;
            }
            if (!zze2.zzabj()) continue;
            bl2 = true;
        }
        switch (this.zzfsf) {
            case 3: {
                break;
            }
            case 1: {
                if (!bl) {
                    throw new IllegalStateException("SIGN_IN_MODE_REQUIRED cannot be used on a GoogleApiClient that does not contain any authenticated APIs. Use connect() instead.");
                }
                if (!bl2) break;
                throw new IllegalStateException("Cannot use SIGN_IN_MODE_REQUIRED with GOOGLE_SIGN_IN_API. Use connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            case 2: {
                if (!bl) break;
                if (this.zzfnc) {
                    this.zzfrv = new zzaa(this.mContext, this.zzfps, this.zzall, this.zzfmy, this.zzfsb, this.zzfpx, this.zzfqa, this.zzfmz, this.zzfse, this, true);
                    return;
                }
                this.zzfrv = zzv.zza(this.mContext, this, this.zzfps, this.zzall, this.zzfmy, this.zzfsb, this.zzfpx, this.zzfqa, this.zzfmz, this.zzfse);
                return;
            }
        }
        if (this.zzfnc && !bl2) {
            this.zzfrv = new zzaa(this.mContext, this.zzfps, this.zzall, this.zzfmy, this.zzfsb, this.zzfpx, this.zzfqa, this.zzfmz, this.zzfse, this, false);
            return;
        }
        this.zzfrv = new zzbi(this.mContext, this, this.zzfps, this.zzall, this.zzfmy, this.zzfsb, this.zzfpx, this.zzfqa, this.zzfmz, this.zzfse, this);
    }

    private final void zzaii() {
        this.zzfru.zzalj();
        this.zzfrv.connect();
    }

    private final void resume() {
        this.zzfps.lock();
        try {
            if (this.zzfrw) {
                this.zzaii();
            }
            return;
        }
        finally {
            this.zzfps.unlock();
        }
    }

    private final void zzaij() {
        this.zzfps.lock();
        try {
            if (this.zzaik()) {
                this.zzaii();
            }
            return;
        }
        finally {
            this.zzfps.unlock();
        }
    }

    final boolean zzaik() {
        if (!this.zzfrw) {
            return false;
        }
        this.zzfrw = false;
        this.zzfrz.removeMessages(2);
        this.zzfrz.removeMessages(1);
        if (this.zzfsa != null) {
            this.zzfsa.unregister();
            this.zzfsa = null;
        }
        return true;
    }

    @Override
    public final void registerConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zzfru.registerConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public final boolean isConnectionCallbacksRegistered(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        return this.zzfru.isConnectionCallbacksRegistered(connectionCallbacks);
    }

    @Override
    public final void unregisterConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zzfru.unregisterConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public final void registerConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zzfru.registerConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    public final boolean isConnectionFailedListenerRegistered(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return this.zzfru.isConnectionFailedListenerRegistered(onConnectionFailedListener);
    }

    @Override
    public final void unregisterConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zzfru.unregisterConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    public final void zzj(Bundle bundle) {
        while (!this.zzfqg.isEmpty()) {
            ((GoogleApiClient)this).zze(this.zzfqg.remove());
        }
        this.zzfru.zzk(bundle);
    }

    @Override
    public final void zzc(ConnectionResult connectionResult) {
        if (!zzf.zze((Context)this.mContext, (int)connectionResult.getErrorCode())) {
            this.zzaik();
        }
        if (!this.zzfrw) {
            this.zzfru.zzk(connectionResult);
            this.zzfru.zzali();
        }
    }

    @Override
    public final void zzf(int n, boolean bl) {
        if (n == 1 && !bl) {
            zzba zzba2 = this;
            if (!zzba2.zzfrw) {
                zzba2.zzfrw = true;
                if (zzba2.zzfsa == null) {
                    zzba2.zzfsa = GoogleApiAvailability.zza(zzba2.mContext.getApplicationContext(), new zzbg(zzba2));
                }
                zzba2.zzfrz.sendMessageDelayed(zzba2.zzfrz.obtainMessage(1), zzba2.zzfrx);
                zzba2.zzfrz.sendMessageDelayed(zzba2.zzfrz.obtainMessage(2), zzba2.zzfry);
            }
        }
        this.zzfsh.zzaju();
        this.zzfru.zzcg(n);
        this.zzfru.zzali();
        if (n == 2) {
            this.zzaii();
        }
    }

    @Override
    public final Context getContext() {
        return this.mContext;
    }

    @Override
    public final Looper getLooper() {
        return this.zzall;
    }

    @Override
    public final boolean zza(zzcu zzcu2) {
        return this.zzfrv != null && this.zzfrv.zza(zzcu2);
    }

    @Override
    public final void zzags() {
        if (this.zzfrv != null) {
            this.zzfrv.zzags();
        }
    }

    @Override
    public final void zza(zzdg zzdg2) {
        this.zzfps.lock();
        try {
            if (this.zzfsg == null) {
                this.zzfsg = new HashSet<zzdg>();
            }
            this.zzfsg.add(zzdg2);
            return;
        }
        finally {
            this.zzfps.unlock();
        }
    }

    @Override
    public final void zzb(zzdg zzdg2) {
        this.zzfps.lock();
        try {
            if (this.zzfsg == null) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Attempted to remove pending transform when no transforms are registered.", (Throwable)new Exception());
            } else if (!this.zzfsg.remove(zzdg2)) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Failed to remove pending transform - this may lead to memory leaks!", (Throwable)new Exception());
            } else if (!this.zzail()) {
                this.zzfrv.zzahk();
            }
            return;
        }
        finally {
            this.zzfps.unlock();
        }
    }

    final boolean zzail() {
        this.zzfps.lock();
        try {
            if (this.zzfsg == null) {
                return false;
            }
            boolean bl = !this.zzfsg.isEmpty();
            return bl;
        }
        finally {
            this.zzfps.unlock();
        }
    }

    final String zzaim() {
        StringWriter stringWriter = new StringWriter();
        ((GoogleApiClient)this).dump("", null, new PrintWriter(stringWriter), null);
        return stringWriter.toString();
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("mContext=").println(this.mContext);
        printWriter.append(string2).append("mResuming=").print(this.zzfrw);
        printWriter.append(" mWorkQueue.size()=").print(this.zzfqg.size());
        PrintWriter printWriter2 = printWriter;
        zzdj zzdj2 = this.zzfsh;
        printWriter2.append(" mUnconsumedApiCalls.size()=").println(zzdj2.zzfvi.size());
        if (this.zzfrv != null) {
            this.zzfrv.dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    public static int zza(Iterable<Api.zze> iterable, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (Api.zze zze2 : iterable) {
            if (zze2.zzaay()) {
                bl2 = true;
            }
            if (!zze2.zzabj()) continue;
            bl3 = true;
        }
        if (bl2) {
            if (bl3 && bl) {
                return 2;
            }
            return 1;
        }
        return 3;
    }

    private static String zzbw(int n) {
        switch (n) {
            case 3: {
                return "SIGN_IN_MODE_NONE";
            }
            case 1: {
                return "SIGN_IN_MODE_REQUIRED";
            }
            case 2: {
                return "SIGN_IN_MODE_OPTIONAL";
            }
        }
        return "UNKNOWN";
    }

    static /* synthetic */ void zza(zzba zzba2) {
        zzba2.resume();
    }

    static /* synthetic */ void zzb(zzba zzba2) {
        zzba2.zzaij();
    }

    static /* synthetic */ void zza(zzba zzba2, GoogleApiClient googleApiClient, zzda zzda2, boolean bl) {
        zzba2.zza(googleApiClient, zzda2, true);
    }

    static /* synthetic */ Context zzc(zzba zzba2) {
        return zzba2.mContext;
    }
}

