/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.accounts.Account;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.internal.zzz;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzan;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.common.internal.zzd;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzm;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.internal.zzcwb;
import com.google.android.gms.internal.zzcwc;
import com.google.android.gms.internal.zzcwh;
import com.google.android.gms.internal.zzcwj;
import com.google.android.gms.internal.zzcwk;
import com.google.android.gms.internal.zzcwm;
import com.google.android.gms.internal.zzcwo;

public final class zzcwl
extends zzab<zzcwj>
implements zzcwb {
    private final boolean zzjzg;
    private final zzr zzfnd;
    private final Bundle zzjzh;
    private Integer zzfwp;

    private zzcwl(Context context, Looper looper, boolean bl, zzr zzr2, Bundle bundle, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 44, zzr2, connectionCallbacks, onConnectionFailedListener);
        this.zzjzg = true;
        this.zzfnd = zzr2;
        this.zzjzh = bundle;
        this.zzfwp = zzr2.zzakq();
    }

    public zzcwl(Context context, Looper looper, boolean bl, zzr zzr2, zzcwc zzcwc2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this(context, looper, true, zzr2, zzcwl.zza(zzr2), connectionCallbacks, onConnectionFailedListener);
    }

    @Override
    public final boolean zzaam() {
        return this.zzjzg;
    }

    @Override
    public final void zza(zzan zzan2, boolean bl) {
        try {
            ((zzcwj)this.zzakb()).zza(zzan2, this.zzfwp, bl);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when saveDefaultAccount is called");
            return;
        }
    }

    @Override
    public final void zzbcp() {
        try {
            ((zzcwj)this.zzakb()).zzeh(this.zzfwp);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when clearAccountFromSessionStore is called");
            return;
        }
    }

    @Override
    public final void zza(zzcwh zzcwh2) {
        zzbq.checkNotNull((Object)zzcwh2, (Object)"Expecting a valid ISignInCallbacks");
        try {
            zzcwl zzcwl2 = this;
            Account account = zzcwl2.zzfnd.zzakh();
            GoogleSignInAccount googleSignInAccount = null;
            if ("<<default account>>".equals(account.name)) {
                googleSignInAccount = zzz.zzbr(zzcwl2.getContext()).zzabg();
            }
            zzbr zzbr2 = new zzbr(account, zzcwl2.zzfwp, googleSignInAccount);
            ((zzcwj)this.zzakb()).zza(new zzcwm(zzbr2), zzcwh2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when signIn is called");
            try {
                zzcwh2.zzb(new zzcwo(8));
                return;
            }
            catch (RemoteException remoteException2) {
                Log.wtf((String)"SignInClientImpl", (String)"ISignInCallbacks#onSignInComplete should be executed from the same process, unexpected RemoteException.", (Throwable)remoteException);
                return;
            }
        }
    }

    protected final String zzhf() {
        return "com.google.android.gms.signin.service.START";
    }

    protected final String zzhg() {
        return "com.google.android.gms.signin.internal.ISignInService";
    }

    protected final Bundle zzaae() {
        String string2 = this.zzfnd.zzakm();
        if (!this.getContext().getPackageName().equals(string2)) {
            this.zzjzh.putString("com.google.android.gms.signin.internal.realClientPackageName", this.zzfnd.zzakm());
        }
        return this.zzjzh;
    }

    @Override
    public final void connect() {
        this.zza((zzj)new zzm((zzd)this));
    }

    public static Bundle zza(zzr zzr2) {
        zzcwc zzcwc2 = zzr2.zzakp();
        Integer n = zzr2.zzakq();
        Bundle bundle = new Bundle();
        bundle.putParcelable("com.google.android.gms.signin.internal.clientRequestedAccount", (Parcelable)zzr2.getAccount());
        if (n != null) {
            bundle.putInt("com.google.android.gms.common.internal.ClientSettings.sessionId", n.intValue());
        }
        if (zzcwc2 != null) {
            bundle.putBoolean("com.google.android.gms.signin.internal.offlineAccessRequested", zzcwc2.zzbcq());
            bundle.putBoolean("com.google.android.gms.signin.internal.idTokenRequested", zzcwc2.isIdTokenRequested());
            bundle.putString("com.google.android.gms.signin.internal.serverClientId", zzcwc2.getServerClientId());
            bundle.putBoolean("com.google.android.gms.signin.internal.usePromptModeForAuthCode", true);
            bundle.putBoolean("com.google.android.gms.signin.internal.forceCodeForRefreshToken", zzcwc2.zzbcr());
            bundle.putString("com.google.android.gms.signin.internal.hostedDomain", zzcwc2.zzbcs());
            bundle.putBoolean("com.google.android.gms.signin.internal.waitForAccessTokenRefresh", zzcwc2.zzbct());
            if (zzcwc2.zzbcu() != null) {
                bundle.putLong("com.google.android.gms.signin.internal.authApiSignInModuleVersion", zzcwc2.zzbcu().longValue());
            }
            if (zzcwc2.zzbcv() != null) {
                bundle.putLong("com.google.android.gms.signin.internal.realClientLibraryVersion", zzcwc2.zzbcv().longValue());
            }
        }
        return bundle;
    }

    protected final /* synthetic */ IInterface zzd(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.signin.internal.ISignInService");
        if (iInterface instanceof zzcwj) {
            return (zzcwj)iInterface;
        }
        return new zzcwk(iBinder2);
    }
}

