/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultCallbacks;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.api.internal.zzcv;
import com.google.android.gms.common.api.internal.zzdj;
import com.google.android.gms.common.api.internal.zzdk;
import com.google.android.gms.common.internal.zzbq;
import java.lang.ref.WeakReference;

public final class zzdi<R extends Result>
extends TransformedResult<R>
implements ResultCallback<R> {
    private ResultTransform<? super R, ? extends Result> zzfsd = null;
    private zzdi<? extends Result> zzfse = null;
    private volatile ResultCallbacks<? super R> zzfsf = null;
    private PendingResult<R> zzfsg = null;
    private final Object zzflz = new Object();
    private Status zzfsh = null;
    private final WeakReference<GoogleApiClient> zzfmb;
    private final zzdk zzfsi;
    private boolean zzfsj = false;

    public zzdi(WeakReference<GoogleApiClient> weakReference) {
        zzbq.checkNotNull(weakReference, (Object)"GoogleApiClient reference must not be null");
        this.zzfmb = weakReference;
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzfmb.get();
        this.zzfsi = new zzdk(this, googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public final <S extends Result> TransformedResult<S> then(@NonNull ResultTransform<? super R, ? extends S> resultTransform) {
        Object object = this.zzflz;
        synchronized (object) {
            zzbq.zza((this.zzfsd == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            zzbq.zza((this.zzfsf == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zzfsd = resultTransform;
            zzdi<R> zzdi2 = new zzdi<R>(this.zzfmb);
            this.zzfse = zzdi2;
            this.zzajf();
            return zzdi2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void andFinally(@NonNull ResultCallbacks<? super R> resultCallbacks) {
        Object object = this.zzflz;
        synchronized (object) {
            zzbq.zza((this.zzfsf == null ? 1 : 0) != 0, (Object)"Cannot call andFinally() twice.");
            zzbq.zza((this.zzfsd == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zzfsf = resultCallbacks;
            this.zzajf();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onResult(R r) {
        Object object = this.zzflz;
        synchronized (object) {
            if (r.getStatus().isSuccess()) {
                if (this.zzfsd != null) {
                    zzcv.zzaid().submit(new zzdj(this, (Result)r));
                } else if (this.zzajh()) {
                    this.zzfsf.onSuccess(r);
                }
            } else {
                this.zzd(r.getStatus());
                zzdi.zzd(r);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(PendingResult<?> pendingResult) {
        Object object = this.zzflz;
        synchronized (object) {
            this.zzfsg = pendingResult;
            this.zzajf();
            return;
        }
    }

    private final void zzajf() {
        if (this.zzfsd == null && this.zzfsf == null) {
            return;
        }
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzfmb.get();
        if (!this.zzfsj && this.zzfsd != null && googleApiClient != null) {
            googleApiClient.zza(this);
            this.zzfsj = true;
        }
        if (this.zzfsh != null) {
            this.zzx(this.zzfsh);
            return;
        }
        if (this.zzfsg != null) {
            this.zzfsg.setResultCallback(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzd(Status status) {
        Object object = this.zzflz;
        synchronized (object) {
            this.zzfsh = status;
            this.zzx(this.zzfsh);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzx(Status status) {
        Object object = this.zzflz;
        synchronized (object) {
            if (this.zzfsd != null) {
                Status status2 = this.zzfsd.onFailure(status);
                zzbq.checkNotNull((Object)status2, (Object)"onFailure must not return null");
                super.zzd(status2);
            } else if (this.zzajh()) {
                this.zzfsf.onFailure(status);
            }
            return;
        }
    }

    final void zzajg() {
        this.zzfsf = null;
    }

    private final boolean zzajh() {
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzfmb.get();
        return this.zzfsf != null && googleApiClient != null;
    }

    private static void zzd(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
                return;
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"TransformedResultImpl", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    static /* synthetic */ ResultTransform zzc(zzdi zzdi2) {
        return zzdi2.zzfsd;
    }

    static /* synthetic */ zzdk zzd(zzdi zzdi2) {
        return zzdi2.zzfsi;
    }

    static /* synthetic */ void zza(zzdi zzdi2, Result result) {
        zzdi.zzd(result);
    }

    static /* synthetic */ WeakReference zze(zzdi zzdi2) {
        return zzdi2.zzfmb;
    }

    static /* synthetic */ Object zzf(zzdi zzdi2) {
        return zzdi2.zzflz;
    }

    static /* synthetic */ zzdi zzg(zzdi zzdi2) {
        return zzdi2.zzfse;
    }

    static /* synthetic */ void zza(zzdi zzdi2, Status status) {
        zzdi2.zzd(status);
    }
}

