/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.internal.zzak;
import com.google.android.gms.common.api.internal.zzbp;
import com.google.android.gms.common.api.internal.zzbr;
import com.google.android.gms.common.api.internal.zzbz;
import com.google.android.gms.common.api.internal.zzcl;
import com.google.android.gms.common.api.internal.zzcn;
import com.google.android.gms.common.api.internal.zzcp;
import com.google.android.gms.common.api.internal.zzct;
import com.google.android.gms.common.api.internal.zzcy;
import com.google.android.gms.common.api.internal.zzdb;
import com.google.android.gms.common.api.internal.zzdf;
import com.google.android.gms.common.api.internal.zzdp;
import com.google.android.gms.common.api.internal.zzg;
import com.google.android.gms.common.api.internal.zzh;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.zzc;
import com.google.android.gms.common.api.zzd;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.internal.zzs;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.Collections;

public class GoogleApi<O extends Api.ApiOptions> {
    private final Context mContext;
    private final Api<O> zzffv;
    private final O zzfjk;
    private final zzh<O> zzfjl;
    private final Looper zzakm;
    private final int mId;
    private final GoogleApiClient zzfjm;
    private final zzdb zzfjn;
    protected final zzbp zzfjo;

    protected GoogleApi(@NonNull Context context, Api<O> api, Looper looper) {
        zzbq.checkNotNull((Object)context, (Object)"Null context is not permitted.");
        zzbq.checkNotNull(api, (Object)"Api must not be null.");
        zzbq.checkNotNull((Object)looper, (Object)"Looper must not be null.");
        this.mContext = context.getApplicationContext();
        this.zzffv = api;
        this.zzfjk = null;
        this.zzakm = looper;
        this.zzfjl = zzh.zzb(api);
        this.zzfjm = new zzbz(this);
        this.zzfjo = zzbp.zzch(this.mContext);
        this.mId = this.zzfjo.zzaig();
        this.zzfjn = new zzg();
    }

    @Deprecated
    public GoogleApi(@NonNull Context context, Api<O> api, O o, Looper looper, zzdb zzdb2) {
        this(context, api, null, new zzd().zza(looper).zza(zzdb2).zzagd());
    }

    @MainThread
    public GoogleApi(@NonNull Activity activity, Api<O> api, O o, zza zza2) {
        zzbq.checkNotNull((Object)activity, (Object)"Null activity is not permitted.");
        zzbq.checkNotNull(api, (Object)"Api must not be null.");
        zzbq.checkNotNull((Object)zza2, (Object)"Settings must not be null; use Settings.DEFAULT_SETTINGS instead.");
        this.mContext = activity.getApplicationContext();
        this.zzffv = api;
        this.zzfjk = o;
        this.zzakm = zza2.zzfjr;
        this.zzfjl = zzh.zza(this.zzffv, this.zzfjk);
        this.zzfjm = new zzbz(this);
        this.zzfjo = zzbp.zzch(this.mContext);
        this.mId = this.zzfjo.zzaig();
        this.zzfjn = zza2.zzfjq;
        zzak.zza(activity, this.zzfjo, this.zzfjl);
        this.zzfjo.zza(this);
    }

    public GoogleApi(@NonNull Context context, Api<O> api, O o, zza zza2) {
        zzbq.checkNotNull((Object)context, (Object)"Null context is not permitted.");
        zzbq.checkNotNull(api, (Object)"Api must not be null.");
        zzbq.checkNotNull((Object)zza2, (Object)"Settings must not be null; use Settings.DEFAULT_SETTINGS instead.");
        this.mContext = context.getApplicationContext();
        this.zzffv = api;
        this.zzfjk = o;
        this.zzakm = zza2.zzfjr;
        this.zzfjl = zzh.zza(this.zzffv, this.zzfjk);
        this.zzfjm = new zzbz(this);
        this.zzfjo = zzbp.zzch(this.mContext);
        this.mId = this.zzfjo.zzaig();
        this.zzfjn = zza2.zzfjq;
        this.zzfjo.zza(this);
    }

    @Deprecated
    public GoogleApi(@NonNull Activity activity, Api<O> api, O o, zzdb zzdb2) {
        this(activity, api, o, new zzd().zza(zzdb2).zza(activity.getMainLooper()).zzagd());
    }

    @Deprecated
    public GoogleApi(@NonNull Context context, Api<O> api, O o, zzdb zzdb2) {
        this(context, api, o, new zzd().zza(zzdb2).zzagd());
    }

    private final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zza(int n, @NonNull T t) {
        t.zzagw();
        this.zzfjo.zza(this, n, t);
        return t;
    }

    private final <TResult, A extends Api.zzb> Task<TResult> zza(int n, @NonNull zzdf<A, TResult> zzdf2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzfjo.zza(this, n, zzdf2, taskCompletionSource, this.zzfjn);
        return taskCompletionSource.getTask();
    }

    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zza(@NonNull T t) {
        return this.zza(0, t);
    }

    public final <TResult, A extends Api.zzb> Task<TResult> zza(zzdf<A, TResult> zzdf2) {
        return this.zza(false, (zzdp)((Object)zzdf2));
    }

    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zzb(@NonNull T t) {
        return this.zza(1, t);
    }

    public final <TResult, A extends Api.zzb> Task<TResult> zzb(zzdf<A, TResult> zzdf2) {
        return this.zza(true, (zzdp)((Object)zzdf2));
    }

    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zzc(@NonNull T t) {
        return this.zza(2, t);
    }

    public final <A extends Api.zzb, T extends zzct<A, ?>, U extends zzdp<A, ?>> Task<Void> zza(@NonNull T t, U u) {
        zzbq.checkNotNull(t);
        zzbq.checkNotNull(u);
        zzbq.checkNotNull(t.zzajc(), (Object)"Listener has already been released.");
        zzbq.checkNotNull(u.zzajc(), (Object)"Listener has already been released.");
        zzbq.checkArgument((boolean)t.zzajc().equals(u.zzajc()), (Object)"Listener registration and unregistration methods must be constructed with the same ListenerHolder.");
        return this.zzfjo.zza(this, t, u);
    }

    public final Task<Boolean> zza(@NonNull zzcn<?> zzcn2) {
        zzbq.checkNotNull(zzcn2, (Object)"Listener key cannot be null.");
        return this.zzfjo.zza(this, zzcn2);
    }

    public final <L> zzcl<L> zza(@NonNull L l, String string2) {
        return zzcp.zzb(l, this.zzakm, string2);
    }

    @WorkerThread
    public Api.zze zza(Looper looper, zzbr<O> zzbr2) {
        zzr zzr2 = this.zzagc().zzga(this.mContext.getPackageName()).zzgb(this.mContext.getClass().getName()).zzakr();
        return this.zzffv.zzafs().zza(this.mContext, looper, zzr2, this.zzfjk, zzbr2, zzbr2);
    }

    public final Api<O> zzafy() {
        return this.zzffv;
    }

    public final O zzafz() {
        return this.zzfjk;
    }

    public final zzh<O> zzaga() {
        return this.zzfjl;
    }

    public final int getInstanceId() {
        return this.mId;
    }

    public final GoogleApiClient zzagb() {
        return this.zzfjm;
    }

    public final Looper getLooper() {
        return this.zzakm;
    }

    public final Context getApplicationContext() {
        return this.mContext;
    }

    private final zzs zzagc() {
        GoogleSignInAccount googleSignInAccount;
        GoogleApi googleApi = this;
        googleApi = this;
        return new zzs().zze((Account)(googleApi.zzfjk instanceof Api.ApiOptions.HasGoogleSignInAccountOptions ? ((Api.ApiOptions.HasGoogleSignInAccountOptions)googleApi.zzfjk).getGoogleSignInAccount().getAccount() : (googleApi.zzfjk instanceof Api.ApiOptions.HasAccountOptions ? ((Api.ApiOptions.HasAccountOptions)googleApi.zzfjk).getAccount() : null))).zze(googleApi.zzfjk instanceof Api.ApiOptions.HasGoogleSignInAccountOptions && (googleSignInAccount = ((Api.ApiOptions.HasGoogleSignInAccountOptions)googleApi.zzfjk).getGoogleSignInAccount()) != null ? googleSignInAccount.getGrantedScopes() : Collections.emptySet());
    }

    public zzcy zza(Context context, Handler handler) {
        return new zzcy(context, handler, this.zzagc().zzakr());
    }

    public static final class zza {
        public static final zza zzfjp = new zzd().zzagd();
        public final zzdb zzfjq;
        public final Looper zzfjr;

        private zza(zzdb zzdb2, Account account, Looper looper) {
            this.zzfjq = zzdb2;
            this.zzfjr = looper;
        }

        /* synthetic */ zza(zzdb zzdb2, Account account, Looper looper, zzc zzc2) {
            this(zzdb2, null, looper);
        }
    }
}

