/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.accounts.Account;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.signin.GoogleSignInOptionsExtension;
import com.google.android.gms.auth.api.signin.internal.zzn;
import com.google.android.gms.auth.api.signin.internal.zzp;
import com.google.android.gms.auth.api.signin.zzd;
import com.google.android.gms.auth.api.signin.zze;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleSignInOptions
extends zzbej
implements Api.ApiOptions.Optional,
ReflectedParcelable {
    public static final Scope zzeei = new Scope("profile");
    public static final Scope zzeej = new Scope("email");
    public static final Scope zzeek = new Scope("openid");
    private static Scope SCOPE_GAMES = new Scope("https://www.googleapis.com/auth/games");
    public static final GoogleSignInOptions DEFAULT_SIGN_IN = new Builder().requestId().requestProfile().build();
    public static final GoogleSignInOptions DEFAULT_GAMES_SIGN_IN = new Builder().requestScopes(SCOPE_GAMES, new Scope[0]).build();
    public static final Parcelable.Creator<GoogleSignInOptions> CREATOR = new zze();
    private int versionCode;
    private final ArrayList<Scope> zzeel;
    private Account zzdzb;
    private boolean zzecm;
    private final boolean zzeem;
    private final boolean zzeen;
    private String zzecn;
    private String zzeeo;
    private ArrayList<zzn> zzeep;
    private Map<Integer, zzn> zzeeq;
    private static Comparator<Scope> zzeer = new zzd();

    @Nullable
    public static GoogleSignInOptions zzeo(@Nullable String string2) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(string2);
        HashSet<Scope> hashSet = new HashSet<Scope>();
        JSONArray jSONArray = jSONObject.getJSONArray("scopes");
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            hashSet.add(new Scope(jSONArray.getString(i)));
        }
        Account account = null;
        String string3 = jSONObject.optString("accountName", null);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            account = new Account(string3, "com.google");
        }
        return new GoogleSignInOptions(3, new ArrayList<Scope>(hashSet), account, jSONObject.getBoolean("idTokenRequested"), jSONObject.getBoolean("serverAuthRequested"), jSONObject.getBoolean("forceCodeForRefreshToken"), jSONObject.optString("serverClientId", null), jSONObject.optString("hostedDomain", null), new HashMap<Integer, zzn>());
    }

    GoogleSignInOptions(int n, ArrayList<Scope> arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3, ArrayList<zzn> arrayList2) {
        this(n, arrayList, account, bl, bl2, bl3, string2, string3, GoogleSignInOptions.zzw(arrayList2));
    }

    private GoogleSignInOptions(int n, ArrayList<Scope> arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3, Map<Integer, zzn> map) {
        this.versionCode = n;
        this.zzeel = arrayList;
        this.zzdzb = account;
        this.zzecm = bl;
        this.zzeem = bl2;
        this.zzeen = bl3;
        this.zzecn = string2;
        this.zzeeo = string3;
        this.zzeep = new ArrayList<zzn>(map.values());
        this.zzeeq = map;
    }

    public final ArrayList<Scope> zzaar() {
        return new ArrayList<Scope>(this.zzeel);
    }

    public Scope[] getScopeArray() {
        return this.zzeel.toArray(new Scope[this.zzeel.size()]);
    }

    public final Account getAccount() {
        return this.zzdzb;
    }

    public final boolean isIdTokenRequested() {
        return this.zzecm;
    }

    public final boolean zzaas() {
        return this.zzeem;
    }

    public final String getServerClientId() {
        return this.zzecn;
    }

    private static Map<Integer, zzn> zzw(@Nullable List<zzn> list) {
        HashMap<Integer, zzn> hashMap = new HashMap<Integer, zzn>();
        if (list == null) {
            return hashMap;
        }
        for (zzn zzn2 : list) {
            hashMap.put(zzn2.getType(), zzn2);
        }
        return hashMap;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GoogleSignInOptions googleSignInOptions = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zzc((Parcel)parcel2, (int)1, (int)googleSignInOptions.versionCode);
        zzbem.zzc((Parcel)parcel2, (int)2, googleSignInOptions.zzaar(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)3, (Parcelable)googleSignInOptions.zzdzb, (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)4, (boolean)googleSignInOptions.zzecm);
        zzbem.zza((Parcel)parcel2, (int)5, (boolean)googleSignInOptions.zzeem);
        zzbem.zza((Parcel)parcel2, (int)6, (boolean)googleSignInOptions.zzeen);
        zzbem.zza((Parcel)parcel2, (int)7, (String)googleSignInOptions.zzecn, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)8, (String)googleSignInOptions.zzeeo, (boolean)false);
        zzbem.zzc((Parcel)parcel2, (int)9, googleSignInOptions.zzeep, (boolean)false);
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            GoogleSignInOptions googleSignInOptions = (GoogleSignInOptions)object;
            if (this.zzeep.size() > 0 || googleSignInOptions.zzeep.size() > 0) {
                return false;
            }
            if (this.zzeel.size() != googleSignInOptions.zzaar().size() || !this.zzeel.containsAll(googleSignInOptions.zzaar())) {
                return false;
            }
            return (this.zzdzb == null ? googleSignInOptions.zzdzb == null : this.zzdzb.equals((Object)googleSignInOptions.zzdzb)) && (TextUtils.isEmpty((CharSequence)this.zzecn) ? TextUtils.isEmpty((CharSequence)googleSignInOptions.zzecn) : this.zzecn.equals(googleSignInOptions.zzecn)) && this.zzeen == googleSignInOptions.zzeen && this.zzecm == googleSignInOptions.zzecm && this.zzeem == googleSignInOptions.zzeem;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Scope> arrayList2 = this.zzeel;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            Scope scope = arrayList2.get(i);
            Scope scope2 = scope;
            arrayList.add(scope2.zzagj());
        }
        Collections.sort(arrayList);
        return new zzp().zzr(arrayList).zzr(this.zzdzb).zzr(this.zzecn).zzaq(this.zzeen).zzaq(this.zzecm).zzaq(this.zzeem).zzaba();
    }

    public final String zzaat() {
        return this.toJsonObject().toString();
    }

    private final JSONObject toJsonObject() {
        JSONObject jSONObject = new JSONObject();
        try {
            JSONArray jSONArray = new JSONArray();
            Collections.sort(this.zzeel, zzeer);
            ArrayList<Scope> arrayList = this.zzeel;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Scope scope = arrayList.get(i);
                Scope scope2 = scope;
                jSONArray.put((Object)scope2.zzagj());
            }
            jSONObject.put("scopes", (Object)jSONArray);
            if (this.zzdzb != null) {
                jSONObject.put("accountName", (Object)this.zzdzb.name);
            }
            jSONObject.put("idTokenRequested", this.zzecm);
            jSONObject.put("forceCodeForRefreshToken", this.zzeen);
            jSONObject.put("serverAuthRequested", this.zzeem);
            if (!TextUtils.isEmpty((CharSequence)this.zzecn)) {
                jSONObject.put("serverClientId", (Object)this.zzecn);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzeeo)) {
                jSONObject.put("hostedDomain", (Object)this.zzeeo);
            }
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    /* synthetic */ GoogleSignInOptions(int n, ArrayList arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3, Map map, zzd zzd2) {
        this(3, (ArrayList<Scope>)arrayList, account, bl, bl2, bl3, string2, string3, map);
    }

    public static final class Builder {
        private Set<Scope> zzees = new HashSet<Scope>();
        private boolean zzeem;
        private boolean zzeen;
        private boolean zzecm;
        private String zzecn;
        private Account zzdzb;
        private String zzeeo;
        private Map<Integer, zzn> zzeet = new HashMap<Integer, zzn>();

        public Builder() {
        }

        public Builder(@NonNull GoogleSignInOptions googleSignInOptions) {
            zzbq.checkNotNull((Object)googleSignInOptions);
            this.zzees = new HashSet<Scope>(googleSignInOptions.zzeel);
            this.zzeem = googleSignInOptions.zzeem;
            this.zzeen = googleSignInOptions.zzeen;
            this.zzecm = googleSignInOptions.zzecm;
            this.zzecn = googleSignInOptions.zzecn;
            this.zzdzb = googleSignInOptions.zzdzb;
            this.zzeeo = googleSignInOptions.zzeeo;
            this.zzeet = GoogleSignInOptions.zzw(googleSignInOptions.zzeep);
        }

        public final Builder requestId() {
            this.zzees.add(zzeek);
            return this;
        }

        public final Builder requestEmail() {
            this.zzees.add(zzeej);
            return this;
        }

        public final Builder requestProfile() {
            this.zzees.add(zzeei);
            return this;
        }

        public final Builder requestScopes(Scope scope, Scope ... scopeArray) {
            this.zzees.add(scope);
            this.zzees.addAll(Arrays.asList(scopeArray));
            return this;
        }

        public final Builder requestIdToken(String string2) {
            this.zzecm = true;
            this.zzecn = this.zzep(string2);
            return this;
        }

        public final Builder requestServerAuthCode(String string2) {
            return this.requestServerAuthCode(string2, false);
        }

        public final Builder requestServerAuthCode(String string2, boolean bl) {
            this.zzeem = true;
            this.zzecn = this.zzep(string2);
            this.zzeen = bl;
            return this;
        }

        public final Builder setAccountName(String string2) {
            this.zzdzb = new Account(zzbq.zzgh((String)string2), "com.google");
            return this;
        }

        public final Builder setHostedDomain(String string2) {
            this.zzeeo = zzbq.zzgh((String)string2);
            return this;
        }

        public final Builder addExtension(GoogleSignInOptionsExtension googleSignInOptionsExtension) {
            if (this.zzeet.containsKey(googleSignInOptionsExtension.getExtensionType())) {
                throw new IllegalStateException("Only one extension per type may be added");
            }
            if (googleSignInOptionsExtension.getImpliedScopes() != null) {
                this.zzees.addAll(googleSignInOptionsExtension.getImpliedScopes());
            }
            this.zzeet.put(googleSignInOptionsExtension.getExtensionType(), new zzn(googleSignInOptionsExtension));
            return this;
        }

        public final GoogleSignInOptions build() {
            if (this.zzecm && (this.zzdzb == null || !this.zzees.isEmpty())) {
                this.requestId();
            }
            return new GoogleSignInOptions(3, new ArrayList<Scope>(this.zzees), this.zzdzb, this.zzecm, this.zzeem, this.zzeen, this.zzecn, this.zzeeo, this.zzeet, null);
        }

        private final String zzep(String string2) {
            zzbq.zzgh((String)string2);
            zzbq.checkArgument((this.zzecn == null || this.zzecn.equals(string2) ? 1 : 0) != 0, (Object)"two different server client ids provided");
            return string2;
        }
    }
}

