/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.support.v4.util.LruCache;
import android.util.Log;
import android.widget.ImageView;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.internal.zzbcj;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class ImageManager {
    private static final Object zzfra = new Object();
    private static HashSet<Uri> zzfrb = new HashSet();
    private static ImageManager zzfrc;
    private final Context mContext;
    private final Handler mHandler;
    private final ExecutorService zzfrd;
    private final zza zzfre;
    private final zzbcj zzfrf;
    private final Map<com.google.android.gms.common.images.zza, ImageReceiver> zzfrg;
    private final Map<Uri, ImageReceiver> zzfrh;
    private final Map<Uri, Long> zzfri;

    public static ImageManager create(Context context) {
        Context context2 = context;
        if (zzfrc == null) {
            zzfrc = new ImageManager(context2, false);
        }
        return zzfrc;
    }

    private ImageManager(Context context, boolean bl) {
        this.mContext = context.getApplicationContext();
        this.mHandler = new Handler(Looper.getMainLooper());
        this.zzfrd = Executors.newFixedThreadPool(4);
        this.zzfre = null;
        this.zzfrf = new zzbcj();
        this.zzfrg = new HashMap<com.google.android.gms.common.images.zza, ImageReceiver>();
        this.zzfrh = new HashMap<Uri, ImageReceiver>();
        this.zzfri = new HashMap<Uri, Long>();
    }

    public final void loadImage(ImageView imageView, Uri uri) {
        com.google.android.gms.common.images.zzc zzc2 = new com.google.android.gms.common.images.zzc(imageView, uri);
        this.zza(zzc2);
    }

    public final void loadImage(ImageView imageView, int n) {
        com.google.android.gms.common.images.zzc zzc2 = new com.google.android.gms.common.images.zzc(imageView, n);
        this.zza(zzc2);
    }

    public final void loadImage(ImageView imageView, Uri uri, int n) {
        com.google.android.gms.common.images.zzc zzc2 = new com.google.android.gms.common.images.zzc(imageView, uri);
        new com.google.android.gms.common.images.zzc(imageView, uri).zzfrq = n;
        this.zza(zzc2);
    }

    public final void loadImage(OnImageLoadedListener onImageLoadedListener, Uri uri) {
        com.google.android.gms.common.images.zzd zzd2 = new com.google.android.gms.common.images.zzd(onImageLoadedListener, uri);
        this.zza(zzd2);
    }

    public final void loadImage(OnImageLoadedListener onImageLoadedListener, Uri uri, int n) {
        com.google.android.gms.common.images.zzd zzd2 = new com.google.android.gms.common.images.zzd(onImageLoadedListener, uri);
        new com.google.android.gms.common.images.zzd(onImageLoadedListener, uri).zzfrq = n;
        this.zza(zzd2);
    }

    private final void zza(com.google.android.gms.common.images.zza zza2) {
        com.google.android.gms.common.internal.zzc.zzfy((String)"ImageManager.loadImage() must be called in the main thread");
        new zzc(this, zza2).run();
    }

    private final Bitmap zza(com.google.android.gms.common.images.zzb zzb2) {
        if (this.zzfre == null) {
            return null;
        }
        return (Bitmap)this.zzfre.get(zzb2);
    }

    static final class zza
    extends LruCache<com.google.android.gms.common.images.zzb, Bitmap> {
        protected final /* synthetic */ int sizeOf(Object object, Object object2) {
            Bitmap bitmap = (Bitmap)object2;
            return bitmap.getHeight() * bitmap.getRowBytes();
        }

        protected final /* synthetic */ void entryRemoved(boolean bl, Object object, Object object2, Object object3) {
            Bitmap bitmap = (Bitmap)object3;
            Bitmap bitmap2 = (Bitmap)object2;
            com.google.android.gms.common.images.zzb zzb2 = (com.google.android.gms.common.images.zzb)object;
            super.entryRemoved(bl, (Object)zzb2, (Object)bitmap2, (Object)bitmap);
        }
    }

    final class zzd
    implements Runnable {
        private final Uri mUri;
        private final Bitmap mBitmap;
        private final CountDownLatch zzaoe;
        private boolean zzfrn;
        private /* synthetic */ ImageManager zzfrk;

        public zzd(ImageManager imageManager, Uri uri, Bitmap bitmap, boolean bl, CountDownLatch countDownLatch) {
            this.zzfrk = imageManager;
            this.mUri = uri;
            this.mBitmap = bitmap;
            this.zzfrn = bl;
            this.zzaoe = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            ImageReceiver imageReceiver;
            boolean bl;
            com.google.android.gms.common.internal.zzc.zzfy((String)"OnBitmapLoadedRunnable must be executed in the main thread");
            boolean bl2 = bl = this.mBitmap != null;
            if (this.zzfrk.zzfre != null) {
                if (this.zzfrn) {
                    this.zzfrk.zzfre.evictAll();
                    System.gc();
                    this.zzfrn = false;
                    this.zzfrk.mHandler.post((Runnable)this);
                    return;
                }
                if (bl) {
                    this.zzfrk.zzfre.put(new com.google.android.gms.common.images.zzb(this.mUri), this.mBitmap);
                }
            }
            if ((imageReceiver = (ImageReceiver)((Object)this.zzfrk.zzfrh.remove(this.mUri))) != null) {
                boolean bl3 = bl;
                ImageReceiver imageReceiver2 = imageReceiver;
                zzd zzd2 = this;
                ArrayList arrayList = imageReceiver2.zzfrj;
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    com.google.android.gms.common.images.zza zza2 = (com.google.android.gms.common.images.zza)arrayList.get(i);
                    if (bl3) {
                        zza2.zza(zzd2.zzfrk.mContext, zzd2.mBitmap, false);
                    } else {
                        zzd2.zzfrk.zzfri.put(zzd2.mUri, SystemClock.elapsedRealtime());
                        zza2.zza(zzd2.zzfrk.mContext, zzd2.zzfrk.zzfrf, false);
                    }
                    if (zza2 instanceof com.google.android.gms.common.images.zzd) continue;
                    zzd2.zzfrk.zzfrg.remove(zza2);
                }
            }
            this.zzaoe.countDown();
            Object object = zzfra;
            synchronized (object) {
                zzfrb.remove(this.mUri);
                return;
            }
        }
    }

    final class zzb
    implements Runnable {
        private final Uri mUri;
        private final ParcelFileDescriptor zzfrl;
        private /* synthetic */ ImageManager zzfrk;

        public zzb(ImageManager imageManager, Uri uri, ParcelFileDescriptor parcelFileDescriptor) {
            this.zzfrk = imageManager;
            this.mUri = uri;
            this.zzfrl = parcelFileDescriptor;
        }

        @Override
        public final void run() {
            String string2 = "LoadBitmapFromDiskRunnable can't be executed in the main thread";
            if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
                String string3 = String.valueOf(Thread.currentThread());
                String string4 = String.valueOf(Looper.getMainLooper().getThread());
                Log.e((String)"Asserts", (String)new StringBuilder(56 + String.valueOf(string3).length() + String.valueOf(string4).length()).append("checkNotMainThread: current thread ").append(string3).append(" IS the main thread ").append(string4).append("!").toString());
                throw new IllegalStateException(string2);
            }
            boolean bl = false;
            Bitmap bitmap = null;
            if (this.zzfrl != null) {
                try {
                    bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)this.zzfrl.getFileDescriptor());
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    String string5 = String.valueOf(this.mUri);
                    Log.e((String)"ImageManager", (String)new StringBuilder(34 + String.valueOf(string5).length()).append("OOM while loading bitmap for uri: ").append(string5).toString(), (Throwable)outOfMemoryError);
                    bl = true;
                }
                try {
                    this.zzfrl.close();
                }
                catch (IOException iOException) {
                    Log.e((String)"ImageManager", (String)"closed failed", (Throwable)iOException);
                }
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            this.zzfrk.mHandler.post((Runnable)new zzd(this.zzfrk, this.mUri, bitmap, bl, countDownLatch));
            try {
                countDownLatch.await();
                return;
            }
            catch (InterruptedException interruptedException) {
                String string6 = String.valueOf(this.mUri);
                Log.w((String)"ImageManager", (String)new StringBuilder(32 + String.valueOf(string6).length()).append("Latch interrupted while posting ").append(string6).toString());
                return;
            }
        }
    }

    @KeepName
    final class ImageReceiver
    extends ResultReceiver {
        private final Uri mUri;
        private final ArrayList<com.google.android.gms.common.images.zza> zzfrj;
        private /* synthetic */ ImageManager zzfrk;

        ImageReceiver(ImageManager imageManager, Uri uri) {
            this.zzfrk = imageManager;
            super(new Handler(Looper.getMainLooper()));
            this.mUri = uri;
            this.zzfrj = new ArrayList();
        }

        public final void zzb(com.google.android.gms.common.images.zza zza2) {
            com.google.android.gms.common.internal.zzc.zzfy((String)"ImageReceiver.addImageRequest() must be called in the main thread");
            this.zzfrj.add(zza2);
        }

        public final void zzc(com.google.android.gms.common.images.zza zza2) {
            com.google.android.gms.common.internal.zzc.zzfy((String)"ImageReceiver.removeImageRequest() must be called in the main thread");
            this.zzfrj.remove(zza2);
        }

        public final void zzaja() {
            Intent intent = new Intent("com.google.android.gms.common.images.LOAD_IMAGE");
            intent.putExtra("com.google.android.gms.extras.uri", (Parcelable)this.mUri);
            intent.putExtra("com.google.android.gms.extras.resultReceiver", (Parcelable)this);
            intent.putExtra("com.google.android.gms.extras.priority", 3);
            this.zzfrk.mContext.sendBroadcast(intent);
        }

        public final void onReceiveResult(int n, Bundle bundle) {
            ParcelFileDescriptor parcelFileDescriptor = (ParcelFileDescriptor)bundle.getParcelable("com.google.android.gms.extra.fileDescriptor");
            this.zzfrk.zzfrd.execute(new zzb(this.zzfrk, this.mUri, parcelFileDescriptor));
        }
    }

    final class zzc
    implements Runnable {
        private final com.google.android.gms.common.images.zza zzfrm;
        private /* synthetic */ ImageManager zzfrk;

        public zzc(ImageManager imageManager, com.google.android.gms.common.images.zza zza2) {
            this.zzfrk = imageManager;
            this.zzfrm = zza2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            com.google.android.gms.common.internal.zzc.zzfy((String)"LoadImageRunnable must be executed on the main thread");
            ImageReceiver imageReceiver = (ImageReceiver)((Object)this.zzfrk.zzfrg.get(this.zzfrm));
            if (imageReceiver != null) {
                this.zzfrk.zzfrg.remove(this.zzfrm);
                imageReceiver.zzc(this.zzfrm);
            }
            com.google.android.gms.common.images.zzb zzb2 = this.zzfrm.zzfro;
            if (zzb2.uri == null) {
                this.zzfrm.zza(this.zzfrk.mContext, this.zzfrk.zzfrf, true);
                return;
            }
            Bitmap bitmap = this.zzfrk.zza(zzb2);
            if (bitmap != null) {
                this.zzfrm.zza(this.zzfrk.mContext, bitmap, true);
                return;
            }
            Long l = (Long)this.zzfrk.zzfri.get(zzb2.uri);
            if (l != null) {
                if (SystemClock.elapsedRealtime() - l < 3600000L) {
                    this.zzfrm.zza(this.zzfrk.mContext, this.zzfrk.zzfrf, true);
                    return;
                }
                this.zzfrk.zzfri.remove(zzb2.uri);
            }
            this.zzfrm.zza(this.zzfrk.mContext, this.zzfrk.zzfrf);
            imageReceiver = (ImageReceiver)((Object)this.zzfrk.zzfrh.get(zzb2.uri));
            if (imageReceiver == null) {
                imageReceiver = new ImageReceiver(this.zzfrk, zzb2.uri);
                this.zzfrk.zzfrh.put(zzb2.uri, imageReceiver);
            }
            imageReceiver.zzb(this.zzfrm);
            if (!(this.zzfrm instanceof com.google.android.gms.common.images.zzd)) {
                this.zzfrk.zzfrg.put(this.zzfrm, imageReceiver);
            }
            Object object = zzfra;
            synchronized (object) {
                if (!zzfrb.contains(zzb2.uri)) {
                    zzfrb.add(zzb2.uri);
                    imageReceiver.zzaja();
                }
                return;
            }
        }
    }

    public static interface OnImageLoadedListener {
        public void onImageLoaded(Uri var1, Drawable var2, boolean var3);
    }
}

