/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzaa;
import com.google.android.gms.common.api.internal.zzab;
import com.google.android.gms.common.api.internal.zzbd;
import com.google.android.gms.common.api.internal.zzbl;
import com.google.android.gms.common.api.internal.zzcd;
import com.google.android.gms.common.api.internal.zzcv;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.internal.zzw;
import com.google.android.gms.common.api.internal.zzz;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzcps;
import com.google.android.gms.internal.zzcpt;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;

final class zzy
implements zzcd {
    private final Context mContext;
    private final zzbd zzfjt;
    private final Looper zzakf;
    private final zzbl zzfju;
    private final zzbl zzfjv;
    private final Map<Api.zzc<?>, zzbl> zzfjw;
    private final Set<zzcv> zzfjx = Collections.newSetFromMap(new WeakHashMap());
    private final Api.zze zzfjy;
    private Bundle zzfjz;
    private ConnectionResult zzfka = null;
    private ConnectionResult zzfkb = null;
    private boolean zzfkc = false;
    private final Lock zzfkd;
    private int zzfke = 0;

    public static zzy zza(Context context, zzbd zzbd2, Lock lock, Looper looper, zze zze2, Map<Api.zzc<?>, Api.zze> map, zzq zzq2, Map<Api<?>, Boolean> map2, Api.zza<? extends zzcps, zzcpt> zza2, ArrayList<zzw> arrayList) {
        Object object;
        Api.zze zze3 = null;
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        for (Map.Entry<Api.zzc<?>, Api.zze> arrayMap4 : map.entrySet()) {
            object = arrayMap4.getValue();
            if (object.zzaal()) {
                zze3 = object;
            }
            if (object.zzaac()) {
                arrayMap2.put(arrayMap4.getKey(), object);
                continue;
            }
            arrayMap3.put(arrayMap4.getKey(), object);
        }
        zzbp.zza((!arrayMap2.isEmpty() ? 1 : 0) != 0, (Object)"CompositeGoogleApiClient should not be used without any APIs that require sign-in.");
        ArrayMap arrayMap5 = new ArrayMap();
        ArrayMap arrayMap = new ArrayMap();
        for (Api api : map2.keySet()) {
            Api.zzc<?> zzc2 = api.zzafe();
            if (arrayMap2.containsKey(zzc2)) {
                arrayMap5.put(api, map2.get(api));
                continue;
            }
            if (arrayMap3.containsKey(zzc2)) {
                arrayMap.put(api, map2.get(api));
                continue;
            }
            throw new IllegalStateException("Each API in the isOptionalMap must have a corresponding client in the clients map.");
        }
        object = new ArrayList<zzw>();
        ArrayList<zzw> arrayList2 = new ArrayList<zzw>();
        ArrayList<zzw> arrayList3 = arrayList;
        int n = arrayList3.size();
        for (int i = 0; i < n; ++i) {
            zzw zzw2 = arrayList3.get(i);
            zzw zzw3 = zzw2;
            if (arrayMap5.containsKey(zzw3.zzfdf)) {
                ((ArrayList)object).add(zzw3);
                continue;
            }
            if (arrayMap.containsKey(zzw3.zzfdf)) {
                arrayList2.add(zzw3);
                continue;
            }
            throw new IllegalStateException("Each ClientCallbacks must have a corresponding API in the isOptionalMap");
        }
        return new zzy(context, zzbd2, lock, looper, zze2, (Map<Api.zzc<?>, Api.zze>)arrayMap2, (Map<Api.zzc<?>, Api.zze>)arrayMap3, zzq2, zza2, zze3, (ArrayList<zzw>)object, arrayList2, (Map<Api<?>, Boolean>)arrayMap5, (Map<Api<?>, Boolean>)arrayMap);
    }

    private zzy(Context context, zzbd zzbd2, Lock lock, Looper looper, zze zze2, Map<Api.zzc<?>, Api.zze> map, Map<Api.zzc<?>, Api.zze> map2, zzq zzq2, Api.zza<? extends zzcps, zzcpt> zza2, Api.zze zze3, ArrayList<zzw> arrayList, ArrayList<zzw> arrayList2, Map<Api<?>, Boolean> map3, Map<Api<?>, Boolean> map4) {
        this.mContext = context;
        this.zzfjt = zzbd2;
        this.zzfkd = lock;
        this.zzakf = looper;
        this.zzfjy = zze3;
        this.zzfju = new zzbl(context, this.zzfjt, lock, looper, zze2, map2, null, map4, null, arrayList2, new zzaa(this, null));
        this.zzfjv = new zzbl(context, this.zzfjt, lock, looper, zze2, map, zzq2, map3, zza2, arrayList, new zzab(this, null));
        ArrayMap arrayMap = new ArrayMap();
        for (Api.zzc<?> zzc2 : map2.keySet()) {
            arrayMap.put(zzc2, (Object)this.zzfju);
        }
        for (Api.zzc<?> zzc2 : map.keySet()) {
            arrayMap.put(zzc2, (Object)this.zzfjv);
        }
        this.zzfjw = Collections.unmodifiableMap(arrayMap);
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzm<R, A>> T zzd(@NonNull T t) {
        if (this.zzf(t)) {
            if (this.zzagl()) {
                t.zzt(new Status(4, null, this.zzagm()));
                return t;
            }
            return this.zzfjv.zzd(t);
        }
        return this.zzfju.zzd(t);
    }

    @Override
    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zze(@NonNull T t) {
        if (this.zzf(t)) {
            if (this.zzagl()) {
                t.zzt(new Status(4, null, this.zzagm()));
                return t;
            }
            return this.zzfjv.zze(t);
        }
        return this.zzfju.zze(t);
    }

    @Override
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        if (this.zzfjw.get(api.zzafe()).equals(this.zzfjv)) {
            if (this.zzagl()) {
                return new ConnectionResult(4, this.zzagm());
            }
            return this.zzfjv.getConnectionResult(api);
        }
        return this.zzfju.getConnectionResult(api);
    }

    @Override
    public final void connect() {
        this.zzfke = 2;
        this.zzfkc = false;
        zzy zzy2 = this;
        this.zzfkb = null;
        zzy2.zzfka = null;
        zzy2.zzfju.connect();
        zzy2.zzfjv.connect();
    }

    @Override
    public final ConnectionResult blockingConnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void disconnect() {
        this.zzfkb = null;
        this.zzfka = null;
        this.zzfke = 0;
        this.zzfju.disconnect();
        this.zzfjv.disconnect();
        this.zzagk();
    }

    @Override
    public final boolean isConnected() {
        this.zzfkd.lock();
        try {
            boolean bl = this.zzfju.isConnected() && (this.zzfjv.isConnected() || this.zzagl() || this.zzfke == 1);
            return bl;
        }
        finally {
            this.zzfkd.unlock();
        }
    }

    @Override
    public final boolean isConnecting() {
        this.zzfkd.lock();
        try {
            boolean bl = this.zzfke == 2;
            return bl;
        }
        finally {
            this.zzfkd.unlock();
        }
    }

    @Override
    public final boolean zza(zzcv zzcv2) {
        this.zzfkd.lock();
        try {
            if ((this.isConnecting() || this.isConnected()) && !this.zzfjv.isConnected()) {
                this.zzfjx.add(zzcv2);
                if (this.zzfke == 0) {
                    this.zzfke = 1;
                }
                this.zzfkb = null;
                this.zzfjv.connect();
                return true;
            }
        }
        finally {
            this.zzfkd.unlock();
        }
        return false;
    }

    @Override
    public final void zzagi() {
        this.zzfju.zzagi();
        this.zzfjv.zzagi();
    }

    @Override
    public final void zzafp() {
        this.zzfkd.lock();
        try {
            boolean bl = this.isConnecting();
            this.zzfjv.disconnect();
            this.zzfkb = new ConnectionResult(4);
            if (bl) {
                new Handler(this.zzakf).post((Runnable)new zzz(this));
            } else {
                this.zzagk();
            }
            return;
        }
        finally {
            this.zzfkd.unlock();
        }
    }

    private final void zzagj() {
        if (zzy.zzb(this.zzfka)) {
            if (zzy.zzb(this.zzfkb) || this.zzagl()) {
                zzy zzy2 = this;
                switch (zzy2.zzfke) {
                    case 2: {
                        zzy2.zzfjt.zzj(zzy2.zzfjz);
                    }
                    case 1: {
                        zzy2.zzagk();
                        break;
                    }
                    default: {
                        Log.wtf((String)"CompositeGAC", (String)"Attempted to call success callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)((Object)new AssertionError()));
                    }
                }
                zzy2.zzfke = 0;
                return;
            }
            if (this.zzfkb != null) {
                if (this.zzfke == 1) {
                    this.zzagk();
                    return;
                }
                this.zza(this.zzfkb);
                this.zzfju.disconnect();
                return;
            }
        } else {
            if (this.zzfka != null && zzy.zzb(this.zzfkb)) {
                this.zzfjv.disconnect();
                this.zza(this.zzfka);
                return;
            }
            if (this.zzfka != null && this.zzfkb != null) {
                ConnectionResult connectionResult = this.zzfka;
                if (this.zzfjv.zzfne < this.zzfju.zzfne) {
                    connectionResult = this.zzfkb;
                }
                this.zza(connectionResult);
            }
        }
    }

    private final void zza(ConnectionResult connectionResult) {
        switch (this.zzfke) {
            case 2: {
                this.zzfjt.zzc(connectionResult);
            }
            case 1: {
                this.zzagk();
                break;
            }
            default: {
                Log.wtf((String)"CompositeGAC", (String)"Attempted to call failure callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)new Exception());
            }
        }
        this.zzfke = 0;
    }

    private final void zzagk() {
        Iterator<zzcv> iterator = this.zzfjx.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzaak();
        }
        this.zzfjx.clear();
    }

    private final void zze(int n, boolean bl) {
        this.zzfjt.zzf(n, bl);
        this.zzfkb = null;
        this.zzfka = null;
    }

    private final boolean zzagl() {
        return this.zzfkb != null && this.zzfkb.getErrorCode() == 4;
    }

    private final boolean zzf(zzm<? extends Result, ? extends Api.zzb> zzm2) {
        Api.zzc<? extends Api.zzb> zzc2 = zzm2.zzafe();
        zzbp.zzb((boolean)this.zzfjw.containsKey(zzc2), (Object)"GoogleApiClient is not configured to use the API required for this call.");
        return this.zzfjw.get(zzc2).equals(this.zzfjv);
    }

    @Nullable
    private final PendingIntent zzagm() {
        if (this.zzfjy == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)System.identityHashCode(this.zzfjt), (Intent)this.zzfjy.zzaam(), (int)0x8000000);
    }

    private final void zzi(Bundle bundle) {
        if (this.zzfjz == null) {
            this.zzfjz = bundle;
            return;
        }
        if (bundle != null) {
            this.zzfjz.putAll(bundle);
        }
    }

    private static boolean zzb(ConnectionResult connectionResult) {
        return connectionResult != null && connectionResult.isSuccess();
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("authClient").println(":");
        this.zzfjv.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
        printWriter.append(string2).append("anonClient").println(":");
        this.zzfju.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
    }

    static /* synthetic */ Lock zza(zzy zzy2) {
        return zzy2.zzfkd;
    }

    static /* synthetic */ void zzb(zzy zzy2) {
        zzy2.zzagj();
    }

    static /* synthetic */ void zza(zzy zzy2, Bundle bundle) {
        zzy2.zzi(bundle);
    }

    static /* synthetic */ ConnectionResult zza(zzy zzy2, ConnectionResult connectionResult) {
        zzy2.zzfka = connectionResult;
        return zzy2.zzfka;
    }

    static /* synthetic */ boolean zzc(zzy zzy2) {
        return zzy2.zzfkc;
    }

    static /* synthetic */ ConnectionResult zzd(zzy zzy2) {
        return zzy2.zzfkb;
    }

    static /* synthetic */ boolean zza(zzy zzy2, boolean bl) {
        zzy2.zzfkc = bl;
        return zzy2.zzfkc;
    }

    static /* synthetic */ void zza(zzy zzy2, int n, boolean bl) {
        zzy2.zze(n, bl);
    }

    static /* synthetic */ zzbl zze(zzy zzy2) {
        return zzy2.zzfjv;
    }

    static /* synthetic */ ConnectionResult zzb(zzy zzy2, ConnectionResult connectionResult) {
        zzy2.zzfkb = connectionResult;
        return zzy2.zzfkb;
    }

    static /* synthetic */ zzbl zzf(zzy zzy2) {
        return zzy2.zzfju;
    }
}

