/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzad;
import com.google.android.gms.common.api.internal.zzbe;
import com.google.android.gms.common.api.internal.zzbf;
import com.google.android.gms.common.api.internal.zzbg;
import com.google.android.gms.common.api.internal.zzbh;
import com.google.android.gms.common.api.internal.zzbi;
import com.google.android.gms.common.api.internal.zzbj;
import com.google.android.gms.common.api.internal.zzbl;
import com.google.android.gms.common.api.internal.zzby;
import com.google.android.gms.common.api.internal.zzcd;
import com.google.android.gms.common.api.internal.zzce;
import com.google.android.gms.common.api.internal.zzcf;
import com.google.android.gms.common.api.internal.zzcj;
import com.google.android.gms.common.api.internal.zzcn;
import com.google.android.gms.common.api.internal.zzcv;
import com.google.android.gms.common.api.internal.zzda;
import com.google.android.gms.common.api.internal.zzdg;
import com.google.android.gms.common.api.internal.zzdj;
import com.google.android.gms.common.api.internal.zzdm;
import com.google.android.gms.common.api.internal.zzi;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.internal.zzs;
import com.google.android.gms.common.api.internal.zzw;
import com.google.android.gms.common.api.internal.zzy;
import com.google.android.gms.common.internal.zzae;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzbcr;
import com.google.android.gms.internal.zzcps;
import com.google.android.gms.internal.zzcpt;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;

public final class zzbd
extends GoogleApiClient
implements zzce {
    private final Lock zzfkd;
    private boolean zzfho;
    private final com.google.android.gms.common.internal.zzad zzfmf;
    private zzcd zzfmg = null;
    private final int zzfhi;
    private final Context mContext;
    private final Looper zzakf;
    final Queue<zzm<?, ?>> zzfkr = new LinkedList();
    private volatile boolean zzfmh;
    private long zzfmi = 120000L;
    private long zzfmj = 5000L;
    private final zzbi zzfmk;
    private final GoogleApiAvailability zzfhk;
    private zzby zzfml;
    final Map<Api.zzc<?>, Api.zze> zzfmm;
    Set<Scope> zzfmn = new HashSet<Scope>();
    private zzq zzfki;
    private Map<Api<?>, Boolean> zzfkl;
    private Api.zza<? extends zzcps, zzcpt> zzfhl;
    private final zzcn zzfmo = new zzcn();
    private final ArrayList<zzw> zzfmp;
    private Integer zzfmq = null;
    Set<zzdg> zzfmr = null;
    final zzdj zzfms;
    private final zzae zzfmt = new zzbe(this);

    public zzbd(Context context, Lock lock, Looper looper, zzq zzq2, GoogleApiAvailability googleApiAvailability, Api.zza<? extends zzcps, zzcpt> zza2, Map<Api<?>, Boolean> map, List<GoogleApiClient.ConnectionCallbacks> list, List<GoogleApiClient.OnConnectionFailedListener> list2, Map<Api.zzc<?>, Api.zze> map2, int n, int n2, ArrayList<zzw> arrayList, boolean bl) {
        this.mContext = context;
        this.zzfkd = lock;
        this.zzfho = false;
        this.zzfmf = new com.google.android.gms.common.internal.zzad(looper, this.zzfmt);
        this.zzakf = looper;
        this.zzfmk = new zzbi(this, looper);
        this.zzfhk = googleApiAvailability;
        this.zzfhi = n;
        if (this.zzfhi >= 0) {
            this.zzfmq = n2;
        }
        this.zzfkl = map;
        this.zzfmm = map2;
        this.zzfmp = arrayList;
        this.zzfms = new zzdj(this.zzfmm);
        for (GoogleApiClient.ConnectionCallbacks object : list) {
            this.zzfmf.registerConnectionCallbacks(object);
        }
        for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : list2) {
            this.zzfmf.registerConnectionFailedListener(onConnectionFailedListener);
        }
        this.zzfki = zzq2;
        this.zzfhl = zza2;
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzm<R, A>> T zzd(@NonNull T t) {
        zzbp.zzb((t.zzafe() != null ? 1 : 0) != 0, (Object)"This task can not be enqueued (it's probably a Batch or malformed)");
        String string2 = t.zzafj() != null ? t.zzafj().getName() : "the API";
        zzbp.zzb((boolean)this.zzfmm.containsKey(t.zzafe()), (Object)new StringBuilder(65 + String.valueOf(string2).length()).append("GoogleApiClient is not configured to use ").append(string2).append(" required for this call.").toString());
        this.zzfkd.lock();
        try {
            if (this.zzfmg == null) {
                this.zzfkr.add(t);
                string2 = t;
                return (T)string2;
            }
            string2 = this.zzfmg.zzd(t);
            return (T)string2;
        }
        finally {
            this.zzfkd.unlock();
        }
    }

    @Override
    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zze(@NonNull T t) {
        zzbp.zzb((t.zzafe() != null ? 1 : 0) != 0, (Object)"This task can not be executed (it's probably a Batch or malformed)");
        Object object = t.zzafj() != null ? t.zzafj().getName() : "the API";
        zzbp.zzb((boolean)this.zzfmm.containsKey(t.zzafe()), (Object)new StringBuilder(65 + String.valueOf(object).length()).append("GoogleApiClient is not configured to use ").append((String)object).append(" required for this call.").toString());
        this.zzfkd.lock();
        try {
            if (this.zzfmg == null) {
                throw new IllegalStateException("GoogleApiClient is not connected yet.");
            }
            if (this.zzfmh) {
                this.zzfkr.add(t);
                while (!this.zzfkr.isEmpty()) {
                    object = this.zzfkr.remove();
                    this.zzfms.zzb((zzs<? extends Result>)object);
                    ((zzm)object).zzt(Status.zzfhw);
                }
                object = t;
                return (T)object;
            }
            object = this.zzfmg.zze(t);
            return (T)object;
        }
        finally {
            this.zzfkd.unlock();
        }
    }

    @Override
    public final <L> zzcj<L> zzp(@NonNull L l) {
        this.zzfkd.lock();
        try {
            Looper looper = this.zzakf;
            L l2 = l;
            zzcj<L> zzcj2 = this.zzfmo.zza(l2, looper, "NO_TYPE");
            return zzcj2;
        }
        finally {
            this.zzfkd.unlock();
        }
    }

    @Override
    @NonNull
    public final <C extends Api.zze> C zza(@NonNull Api.zzc<C> zzc2) {
        Api.zze zze2 = this.zzfmm.get(zzc2);
        zzbp.zzb((Object)zze2, (Object)"Appropriate Api was not requested.");
        return (C)zze2;
    }

    @Override
    public final boolean zza(@NonNull Api<?> api) {
        return this.zzfmm.containsKey(api.zzafe());
    }

    @Override
    public final boolean hasConnectedApi(@NonNull Api<?> api) {
        if (!((GoogleApiClient)this).isConnected()) {
            return false;
        }
        Api.zze zze2 = this.zzfmm.get(api.zzafe());
        return zze2 != null && zze2.isConnected();
    }

    @Override
    @NonNull
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        block6: {
            ConnectionResult connectionResult;
            block7: {
                block8: {
                    this.zzfkd.lock();
                    if (!((GoogleApiClient)this).isConnected() && !this.zzfmh) {
                        throw new IllegalStateException("Cannot invoke getConnectionResult unless GoogleApiClient is connected");
                    }
                    if (!this.zzfmm.containsKey(api.zzafe())) break block6;
                    connectionResult = this.zzfmg.getConnectionResult(api);
                    if (connectionResult != null) break block7;
                    if (!this.zzfmh) break block8;
                    ConnectionResult connectionResult2 = ConnectionResult.zzffe;
                    this.zzfkd.unlock();
                    return connectionResult2;
                }
                Log.w((String)"GoogleApiClientImpl", (String)this.zzahk());
                Log.wtf((String)"GoogleApiClientImpl", (String)String.valueOf(api.getName()).concat(" requested in getConnectionResult is not connected but is not present in the failed  connections map"), (Throwable)new Exception());
                ConnectionResult connectionResult3 = new ConnectionResult(8, null);
                return connectionResult3;
            }
            ConnectionResult connectionResult4 = connectionResult;
            this.zzfkd.unlock();
            return connectionResult4;
        }
        try {
            throw new IllegalArgumentException(String.valueOf(api.getName()).concat(" was never registered with GoogleApiClient"));
        }
        finally {
            this.zzfkd.unlock();
        }
    }

    @Override
    public final void connect() {
        this.zzfkd.lock();
        try {
            if (this.zzfhi >= 0) {
                zzbp.zza((this.zzfmq != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zzfmq == null) {
                this.zzfmq = zzbd.zza(this.zzfmm.values(), false);
            } else if (this.zzfmq == 2) {
                throw new IllegalStateException("Cannot call connect() when SignInMode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            ((GoogleApiClient)this).connect(this.zzfmq);
            return;
        }
        finally {
            this.zzfkd.unlock();
        }
    }

    @Override
    public final void connect(int n) {
        this.zzfkd.lock();
        try {
            zzbp.zzb((n == 3 || n == 1 || n == 2 ? 1 : 0) != 0, (Object)new StringBuilder(33).append("Illegal sign-in mode: ").append(n).toString());
            this.zzbt(n);
            this.zzahg();
            return;
        }
        finally {
            this.zzfkd.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect() {
        zzbp.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        this.zzfkd.lock();
        try {
            if (this.zzfhi >= 0) {
                zzbp.zza((this.zzfmq != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zzfmq == null) {
                this.zzfmq = zzbd.zza(this.zzfmm.values(), false);
            } else if (this.zzfmq == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zzbt(this.zzfmq);
            this.zzfmf.zzakg();
            ConnectionResult connectionResult = this.zzfmg.blockingConnect();
            return connectionResult;
        }
        finally {
            this.zzfkd.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        zzbp.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        zzbp.zzb((Object)((Object)timeUnit), (Object)"TimeUnit must not be null");
        this.zzfkd.lock();
        try {
            if (this.zzfmq == null) {
                this.zzfmq = zzbd.zza(this.zzfmm.values(), false);
            } else if (this.zzfmq == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zzbt(this.zzfmq);
            this.zzfmf.zzakg();
            ConnectionResult connectionResult = this.zzfmg.blockingConnect(l, timeUnit);
            return connectionResult;
        }
        finally {
            this.zzfkd.unlock();
        }
    }

    @Override
    public final void disconnect() {
        this.zzfkd.lock();
        try {
            this.zzfms.release();
            if (this.zzfmg != null) {
                this.zzfmg.disconnect();
            }
            this.zzfmo.release();
            for (zzm zzm2 : this.zzfkr) {
                ((zzs)zzm2).zza((zzdm)null);
                ((PendingResult)zzm2).cancel();
            }
            this.zzfkr.clear();
            if (this.zzfmg == null) {
                return;
            }
            this.zzahi();
            this.zzfmf.zzakf();
            return;
        }
        finally {
            this.zzfkd.unlock();
        }
    }

    @Override
    public final void reconnect() {
        ((GoogleApiClient)this).disconnect();
        ((GoogleApiClient)this).connect();
    }

    @Override
    public final PendingResult<Status> clearDefaultAccountAndReconnect() {
        zzbp.zza((boolean)((GoogleApiClient)this).isConnected(), (Object)"GoogleApiClient is not connected yet.");
        zzbp.zza((this.zzfmq != 2 ? 1 : 0) != 0, (Object)"Cannot use clearDefaultAccountAndReconnect with GOOGLE_SIGN_IN_API");
        zzda zzda2 = new zzda(this);
        if (this.zzfmm.containsKey(zzbcr.zzdwo)) {
            this.zza(this, zzda2, false);
        } else {
            AtomicReference<GoogleApiClient> atomicReference = new AtomicReference<GoogleApiClient>();
            zzbf zzbf2 = new zzbf(this, atomicReference, zzda2);
            zzbg zzbg2 = new zzbg(this, zzda2);
            GoogleApiClient googleApiClient = new GoogleApiClient.Builder(this.mContext).addApi(zzbcr.API).addConnectionCallbacks(zzbf2).addOnConnectionFailedListener(zzbg2).setHandler(this.zzfmk).build();
            atomicReference.set(googleApiClient);
            googleApiClient.connect();
        }
        return zzda2;
    }

    private final void zza(GoogleApiClient googleApiClient, zzda zzda2, boolean bl) {
        zzbcr.zzfwg.zzd(googleApiClient).setResultCallback(new zzbh(this, zzda2, bl, googleApiClient));
    }

    @Override
    public final void stopAutoManage(@NonNull FragmentActivity fragmentActivity) {
        zzcf zzcf2 = new zzcf((Activity)fragmentActivity);
        zzbd zzbd2 = this;
        if (zzbd2.zzfhi >= 0) {
            zzi.zza(zzcf2).zzbp(zzbd2.zzfhi);
            return;
        }
        throw new IllegalStateException("Called stopAutoManage but automatic lifecycle management is not enabled.");
    }

    @Override
    public final boolean isConnected() {
        return this.zzfmg != null && this.zzfmg.isConnected();
    }

    @Override
    public final boolean isConnecting() {
        return this.zzfmg != null && this.zzfmg.isConnecting();
    }

    private final void zzbt(int n) {
        if (this.zzfmq == null) {
            this.zzfmq = n;
        } else if (this.zzfmq != n) {
            String string2 = zzbd.zzbu(n);
            String string3 = zzbd.zzbu(this.zzfmq);
            throw new IllegalStateException(new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Cannot use sign-in mode: ").append(string2).append(". Mode was already set to ").append(string3).toString());
        }
        if (this.zzfmg != null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Api.zze zze2 : this.zzfmm.values()) {
            if (zze2.zzaac()) {
                bl = true;
            }
            if (!zze2.zzaal()) continue;
            bl2 = true;
        }
        switch (this.zzfmq) {
            case 3: {
                break;
            }
            case 1: {
                if (!bl) {
                    throw new IllegalStateException("SIGN_IN_MODE_REQUIRED cannot be used on a GoogleApiClient that does not contain any authenticated APIs. Use connect() instead.");
                }
                if (!bl2) break;
                throw new IllegalStateException("Cannot use SIGN_IN_MODE_REQUIRED with GOOGLE_SIGN_IN_API. Use connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            case 2: {
                if (!bl) break;
                if (this.zzfho) {
                    this.zzfmg = new zzad(this.mContext, this.zzfkd, this.zzakf, this.zzfhk, this.zzfmm, this.zzfki, this.zzfkl, this.zzfhl, this.zzfmp, this, true);
                    return;
                }
                this.zzfmg = zzy.zza(this.mContext, this, this.zzfkd, this.zzakf, this.zzfhk, this.zzfmm, this.zzfki, this.zzfkl, this.zzfhl, this.zzfmp);
                return;
            }
        }
        if (this.zzfho && !bl2) {
            this.zzfmg = new zzad(this.mContext, this.zzfkd, this.zzakf, this.zzfhk, this.zzfmm, this.zzfki, this.zzfkl, this.zzfhl, this.zzfmp, this, false);
            return;
        }
        this.zzfmg = new zzbl(this.mContext, this, this.zzfkd, this.zzakf, this.zzfhk, this.zzfmm, this.zzfki, this.zzfkl, this.zzfhl, this.zzfmp, this);
    }

    private final void zzahg() {
        this.zzfmf.zzakg();
        this.zzfmg.connect();
    }

    private final void resume() {
        this.zzfkd.lock();
        try {
            if (this.zzfmh) {
                this.zzahg();
            }
            return;
        }
        finally {
            this.zzfkd.unlock();
        }
    }

    private final void zzahh() {
        this.zzfkd.lock();
        try {
            if (this.zzahi()) {
                this.zzahg();
            }
            return;
        }
        finally {
            this.zzfkd.unlock();
        }
    }

    final boolean zzahi() {
        if (!this.zzfmh) {
            return false;
        }
        this.zzfmh = false;
        this.zzfmk.removeMessages(2);
        this.zzfmk.removeMessages(1);
        if (this.zzfml != null) {
            this.zzfml.unregister();
            this.zzfml = null;
        }
        return true;
    }

    @Override
    public final void registerConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zzfmf.registerConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public final boolean isConnectionCallbacksRegistered(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        return this.zzfmf.isConnectionCallbacksRegistered(connectionCallbacks);
    }

    @Override
    public final void unregisterConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zzfmf.unregisterConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public final void registerConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zzfmf.registerConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    public final boolean isConnectionFailedListenerRegistered(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return this.zzfmf.isConnectionFailedListenerRegistered(onConnectionFailedListener);
    }

    @Override
    public final void unregisterConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zzfmf.unregisterConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    public final void zzj(Bundle bundle) {
        while (!this.zzfkr.isEmpty()) {
            ((GoogleApiClient)this).zze(this.zzfkr.remove());
        }
        this.zzfmf.zzk(bundle);
    }

    @Override
    public final void zzc(ConnectionResult connectionResult) {
        if (!zze.zze((Context)this.mContext, (int)connectionResult.getErrorCode())) {
            this.zzahi();
        }
        if (!this.zzfmh) {
            this.zzfmf.zzk(connectionResult);
            this.zzfmf.zzakf();
        }
    }

    @Override
    public final void zzf(int n, boolean bl) {
        if (n == 1 && !bl) {
            zzbd zzbd2 = this;
            if (!zzbd2.zzfmh) {
                zzbd2.zzfmh = true;
                if (zzbd2.zzfml == null) {
                    zzbd2.zzfml = GoogleApiAvailability.zza(zzbd2.mContext.getApplicationContext(), new zzbj(zzbd2));
                }
                zzbd2.zzfmk.sendMessageDelayed(zzbd2.zzfmk.obtainMessage(1), zzbd2.zzfmi);
                zzbd2.zzfmk.sendMessageDelayed(zzbd2.zzfmk.obtainMessage(2), zzbd2.zzfmj);
            }
        }
        this.zzfms.zzair();
        this.zzfmf.zzce(n);
        this.zzfmf.zzakf();
        if (n == 2) {
            this.zzahg();
        }
    }

    @Override
    public final Context getContext() {
        return this.mContext;
    }

    @Override
    public final Looper getLooper() {
        return this.zzakf;
    }

    @Override
    public final boolean zza(zzcv zzcv2) {
        return this.zzfmg != null && this.zzfmg.zza(zzcv2);
    }

    @Override
    public final void zzafp() {
        if (this.zzfmg != null) {
            this.zzfmg.zzafp();
        }
    }

    @Override
    public final void zza(zzdg zzdg2) {
        this.zzfkd.lock();
        try {
            if (this.zzfmr == null) {
                this.zzfmr = new HashSet<zzdg>();
            }
            this.zzfmr.add(zzdg2);
            return;
        }
        finally {
            this.zzfkd.unlock();
        }
    }

    @Override
    public final void zzb(zzdg zzdg2) {
        this.zzfkd.lock();
        try {
            if (this.zzfmr == null) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Attempted to remove pending transform when no transforms are registered.", (Throwable)new Exception());
            } else if (!this.zzfmr.remove(zzdg2)) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Failed to remove pending transform - this may lead to memory leaks!", (Throwable)new Exception());
            } else if (!this.zzahj()) {
                this.zzfmg.zzagi();
            }
            return;
        }
        finally {
            this.zzfkd.unlock();
        }
    }

    final boolean zzahj() {
        this.zzfkd.lock();
        try {
            if (this.zzfmr == null) {
                return false;
            }
            boolean bl = !this.zzfmr.isEmpty();
            return bl;
        }
        finally {
            this.zzfkd.unlock();
        }
    }

    final String zzahk() {
        StringWriter stringWriter = new StringWriter();
        ((GoogleApiClient)this).dump("", null, new PrintWriter(stringWriter), null);
        return stringWriter.toString();
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("mContext=").println(this.mContext);
        printWriter.append(string2).append("mResuming=").print(this.zzfmh);
        printWriter.append(" mWorkQueue.size()=").print(this.zzfkr.size());
        PrintWriter printWriter2 = printWriter;
        zzdj zzdj2 = this.zzfms;
        printWriter2.append(" mUnconsumedApiCalls.size()=").println(zzdj2.zzfpr.size());
        if (this.zzfmg != null) {
            this.zzfmg.dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    public static int zza(Iterable<Api.zze> iterable, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (Api.zze zze2 : iterable) {
            if (zze2.zzaac()) {
                bl2 = true;
            }
            if (!zze2.zzaal()) continue;
            bl3 = true;
        }
        if (bl2) {
            if (bl3 && bl) {
                return 2;
            }
            return 1;
        }
        return 3;
    }

    private static String zzbu(int n) {
        switch (n) {
            case 3: {
                return "SIGN_IN_MODE_NONE";
            }
            case 1: {
                return "SIGN_IN_MODE_REQUIRED";
            }
            case 2: {
                return "SIGN_IN_MODE_OPTIONAL";
            }
        }
        return "UNKNOWN";
    }

    static /* synthetic */ void zza(zzbd zzbd2) {
        zzbd2.resume();
    }

    static /* synthetic */ void zzb(zzbd zzbd2) {
        zzbd2.zzahh();
    }

    static /* synthetic */ void zza(zzbd zzbd2, GoogleApiClient googleApiClient, zzda zzda2, boolean bl) {
        zzbd2.zza(googleApiClient, zzda2, true);
    }

    static /* synthetic */ Context zzc(zzbd zzbd2) {
        return zzbd2.mContext;
    }
}

