/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.util.ArrayMap;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzbd;
import com.google.android.gms.common.api.internal.zzcf;
import com.google.android.gms.common.api.internal.zzcj;
import com.google.android.gms.common.api.internal.zzcv;
import com.google.android.gms.common.api.internal.zzdg;
import com.google.android.gms.common.api.internal.zzi;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.internal.zzw;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.internal.zzs;
import com.google.android.gms.internal.zzcpp;
import com.google.android.gms.internal.zzcps;
import com.google.android.gms.internal.zzcpt;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public abstract class GoogleApiClient {
    private static final Set<GoogleApiClient> zzfgz = Collections.newSetFromMap(new WeakHashMap());
    public static final int SIGN_IN_MODE_REQUIRED = 1;
    public static final int SIGN_IN_MODE_OPTIONAL = 2;

    public GoogleApiClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpAll(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        Set<GoogleApiClient> set = zzfgz;
        synchronized (set) {
            int n = 0;
            String string3 = String.valueOf(string2).concat("  ");
            for (GoogleApiClient googleApiClient : zzfgz) {
                printWriter.append(string2).append("GoogleApiClient#").println(n++);
                googleApiClient.dump(string3, fileDescriptor, printWriter, stringArray);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<GoogleApiClient> zzafo() {
        Set<GoogleApiClient> set = zzfgz;
        synchronized (set) {
            return zzfgz;
        }
    }

    public <A extends Api.zzb, R extends Result, T extends zzm<R, A>> T zzd(@NonNull T t) {
        throw new UnsupportedOperationException();
    }

    public <A extends Api.zzb, T extends zzm<? extends Result, A>> T zze(@NonNull T t) {
        throw new UnsupportedOperationException();
    }

    public <L> zzcj<L> zzp(@NonNull L l) {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public <C extends Api.zze> C zza(@NonNull Api.zzc<C> zzc2) {
        throw new UnsupportedOperationException();
    }

    public boolean zza(@NonNull Api<?> api) {
        throw new UnsupportedOperationException();
    }

    public abstract boolean hasConnectedApi(@NonNull Api<?> var1);

    @NonNull
    public abstract ConnectionResult getConnectionResult(@NonNull Api<?> var1);

    public Context getContext() {
        throw new UnsupportedOperationException();
    }

    public Looper getLooper() {
        throw new UnsupportedOperationException();
    }

    public boolean zza(zzcv zzcv2) {
        throw new UnsupportedOperationException();
    }

    public void zzafp() {
        throw new UnsupportedOperationException();
    }

    public abstract void connect();

    public void connect(int n) {
        throw new UnsupportedOperationException();
    }

    public abstract ConnectionResult blockingConnect();

    public abstract ConnectionResult blockingConnect(long var1, @NonNull TimeUnit var3);

    public abstract void disconnect();

    public abstract void reconnect();

    public abstract PendingResult<Status> clearDefaultAccountAndReconnect();

    public abstract void stopAutoManage(@NonNull FragmentActivity var1);

    public abstract boolean isConnected();

    public abstract boolean isConnecting();

    public abstract void registerConnectionCallbacks(@NonNull ConnectionCallbacks var1);

    public abstract boolean isConnectionCallbacksRegistered(@NonNull ConnectionCallbacks var1);

    public abstract void unregisterConnectionCallbacks(@NonNull ConnectionCallbacks var1);

    public abstract void registerConnectionFailedListener(@NonNull OnConnectionFailedListener var1);

    public abstract boolean isConnectionFailedListenerRegistered(@NonNull OnConnectionFailedListener var1);

    public abstract void unregisterConnectionFailedListener(@NonNull OnConnectionFailedListener var1);

    public abstract void dump(String var1, FileDescriptor var2, PrintWriter var3, String[] var4);

    public void zza(zzdg zzdg2) {
        throw new UnsupportedOperationException();
    }

    public void zzb(zzdg zzdg2) {
        throw new UnsupportedOperationException();
    }

    public static final class Builder {
        private Account zzduy;
        private final Set<Scope> zzfha = new HashSet<Scope>();
        private final Set<Scope> zzfhb = new HashSet<Scope>();
        private int zzfhc;
        private View zzfhd;
        private String zzdxb;
        private String zzfhe;
        private final Map<Api<?>, zzs> zzfhf = new ArrayMap();
        private final Context mContext;
        private final Map<Api<?>, Api.ApiOptions> zzfhg = new ArrayMap();
        private zzcf zzfhh;
        private int zzfhi = -1;
        private OnConnectionFailedListener zzfhj;
        private Looper zzakf;
        private GoogleApiAvailability zzfhk = GoogleApiAvailability.getInstance();
        private Api.zza<? extends zzcps, zzcpt> zzfhl = zzcpp.zzdwp;
        private final ArrayList<ConnectionCallbacks> zzfhm = new ArrayList();
        private final ArrayList<OnConnectionFailedListener> zzfhn = new ArrayList();
        private boolean zzfho = false;

        public Builder(@NonNull Context context) {
            this.mContext = context;
            this.zzakf = context.getMainLooper();
            this.zzdxb = context.getPackageName();
            this.zzfhe = context.getClass().getName();
        }

        public Builder(@NonNull Context context, @NonNull ConnectionCallbacks connectionCallbacks, @NonNull OnConnectionFailedListener onConnectionFailedListener) {
            this(context);
            zzbp.zzb((Object)connectionCallbacks, (Object)"Must provide a connected listener");
            this.zzfhm.add(connectionCallbacks);
            zzbp.zzb((Object)onConnectionFailedListener, (Object)"Must provide a connection failed listener");
            this.zzfhn.add(onConnectionFailedListener);
        }

        public final Builder setHandler(@NonNull Handler handler) {
            zzbp.zzb((Object)handler, (Object)"Handler must not be null");
            this.zzakf = handler.getLooper();
            return this;
        }

        public final Builder addConnectionCallbacks(@NonNull ConnectionCallbacks connectionCallbacks) {
            zzbp.zzb((Object)connectionCallbacks, (Object)"Listener must not be null");
            this.zzfhm.add(connectionCallbacks);
            return this;
        }

        public final Builder addOnConnectionFailedListener(@NonNull OnConnectionFailedListener onConnectionFailedListener) {
            zzbp.zzb((Object)onConnectionFailedListener, (Object)"Listener must not be null");
            this.zzfhn.add(onConnectionFailedListener);
            return this;
        }

        public final Builder setViewForPopups(@NonNull View view) {
            zzbp.zzb((Object)view, (Object)"View must not be null");
            this.zzfhd = view;
            return this;
        }

        public final Builder addScope(@NonNull Scope scope) {
            zzbp.zzb((Object)scope, (Object)"Scope must not be null");
            this.zzfha.add(scope);
            return this;
        }

        public final Builder addApi(@NonNull Api<? extends Api.ApiOptions.NotRequiredOptions> api) {
            zzbp.zzb(api, (Object)"Api must not be null");
            this.zzfhg.put(api, null);
            List<Scope> list = api.zzafc().zzn(null);
            this.zzfhb.addAll(list);
            this.zzfha.addAll(list);
            return this;
        }

        public final Builder addApiIfAvailable(@NonNull Api<? extends Api.ApiOptions.NotRequiredOptions> api, Scope ... scopeArray) {
            zzbp.zzb(api, (Object)"Api must not be null");
            this.zzfhg.put(api, null);
            this.zza(api, null, scopeArray);
            return this;
        }

        public final <O extends Api.ApiOptions.HasOptions> Builder addApi(@NonNull Api<O> api, @NonNull O o) {
            zzbp.zzb(api, (Object)"Api must not be null");
            zzbp.zzb(o, (Object)"Null options are not permitted for this Api");
            this.zzfhg.put(api, o);
            List<Scope> list = api.zzafc().zzn(o);
            this.zzfhb.addAll(list);
            this.zzfha.addAll(list);
            return this;
        }

        public final <O extends Api.ApiOptions.HasOptions> Builder addApiIfAvailable(@NonNull Api<O> api, @NonNull O o, Scope ... scopeArray) {
            zzbp.zzb(api, (Object)"Api must not be null");
            zzbp.zzb(o, (Object)"Null options are not permitted for this Api");
            this.zzfhg.put(api, o);
            this.zza(api, o, scopeArray);
            return this;
        }

        public final Builder setAccountName(String string2) {
            this.zzduy = string2 == null ? null : new Account(string2, "com.google");
            return this;
        }

        public final Builder useDefaultAccount() {
            return this.setAccountName("<<default account>>");
        }

        public final Builder setGravityForPopups(int n) {
            this.zzfhc = n;
            return this;
        }

        public final Builder enableAutoManage(@NonNull FragmentActivity fragmentActivity, int n, @Nullable OnConnectionFailedListener onConnectionFailedListener) {
            OnConnectionFailedListener onConnectionFailedListener2 = onConnectionFailedListener;
            zzcf zzcf2 = new zzcf((Activity)fragmentActivity);
            Builder builder = this;
            zzbp.zzb((n >= 0 ? 1 : 0) != 0, (Object)"clientId must be non-negative");
            builder.zzfhi = n;
            builder.zzfhj = onConnectionFailedListener2;
            builder.zzfhh = zzcf2;
            return builder;
        }

        public final Builder enableAutoManage(@NonNull FragmentActivity fragmentActivity, @Nullable OnConnectionFailedListener onConnectionFailedListener) {
            return this.enableAutoManage(fragmentActivity, 0, onConnectionFailedListener);
        }

        public final zzq zzafr() {
            zzcpt zzcpt2 = zzcpt.zzjno;
            if (this.zzfhg.containsKey(zzcpp.API)) {
                zzcpt2 = (zzcpt)this.zzfhg.get(zzcpp.API);
            }
            return new zzq(this.zzduy, this.zzfha, this.zzfhf, this.zzfhc, this.zzfhd, this.zzdxb, this.zzfhe, zzcpt2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final GoogleApiClient build() {
            zzbp.zzb((!this.zzfhg.isEmpty() ? 1 : 0) != 0, (Object)"must call addApi() to add at least one API");
            Builder builder = this;
            Object object = builder.zzafr();
            Api<?> api = null;
            boolean bl = false;
            Map<Api<?>, zzs> map = ((zzq)object).zzaju();
            ArrayMap arrayMap = new ArrayMap();
            ArrayMap arrayMap2 = new ArrayMap();
            ArrayList<zzw> arrayList = new ArrayList<zzw>();
            for (Api<?> api2 : builder.zzfhg.keySet()) {
                Api.ApiOptions apiOptions = builder.zzfhg.get(api2);
                boolean bl2 = map.get(api2) != null;
                arrayMap.put(api2, bl2);
                zzw zzw2 = new zzw(api2, bl2);
                arrayList.add(zzw2);
                Object object2 = api2.zzafd();
                Api.zza<?, ?> zza2 = object2;
                zzw zzw3 = zzw2;
                zzw zzw4 = zzw2;
                zzq zzq2 = object;
                Looper looper = builder.zzakf;
                Context context = builder.mContext;
                Api.ApiOptions apiOptions2 = apiOptions;
                Object obj = ((Api.zza)object2).zza(context, looper, zzq2, apiOptions2, zzw4, zzw3);
                arrayMap2.put(api2.zzafe(), obj);
                if (zza2.getPriority() == 1) {
                    boolean bl3 = bl = apiOptions != null;
                }
                if (!obj.zzaal()) continue;
                if (api != null) {
                    object2 = api2.getName();
                    String string2 = api.getName();
                    throw new IllegalStateException(new StringBuilder(21 + String.valueOf(object2).length() + String.valueOf(string2).length()).append((String)object2).append(" cannot be used with ").append(string2).toString());
                }
                api = api2;
            }
            if (api != null) {
                if (bl) {
                    String string3 = api.getName();
                    throw new IllegalStateException(new StringBuilder(82 + String.valueOf(string3).length()).append("With using ").append(string3).append(", GamesOptions can only be specified within GoogleSignInOptions.Builder").toString());
                }
                zzbp.zza((builder.zzduy == null ? 1 : 0) != 0, (String)"Must not set an account in GoogleApiClient.Builder when using %s. Set account in GoogleSignInOptions.Builder instead", (Object[])new Object[]{api.getName()});
                zzbp.zza((boolean)builder.zzfha.equals(builder.zzfhb), (String)"Must not set scopes in GoogleApiClient.Builder when using %s. Set account in GoogleSignInOptions.Builder instead.", (Object[])new Object[]{api.getName()});
            }
            int n = zzbd.zza(arrayMap2.values(), true);
            zzbd zzbd2 = new zzbd(builder.mContext, new ReentrantLock(), builder.zzakf, (zzq)object, builder.zzfhk, builder.zzfhl, (Map<Api<?>, Boolean>)arrayMap, (List<ConnectionCallbacks>)builder.zzfhm, (List<OnConnectionFailedListener>)builder.zzfhn, (Map<Api.zzc<?>, Api.zze>)arrayMap2, builder.zzfhi, n, arrayList, false);
            Set set = zzfgz;
            synchronized (set) {
                zzfgz.add(zzbd2);
            }
            if (this.zzfhi >= 0) {
                object = zzbd2;
                builder = this;
                zzi.zza(builder.zzfhh).zza(builder.zzfhi, (GoogleApiClient)object, builder.zzfhj);
            }
            return zzbd2;
        }

        private final <O extends Api.ApiOptions> void zza(Api<O> api, O o, Scope ... scopeArray) {
            HashSet<Scope> hashSet = new HashSet<Scope>(api.zzafc().zzn(o));
            Scope[] scopeArray2 = scopeArray;
            int n = scopeArray.length;
            for (int i = 0; i < n; ++i) {
                Scope scope = scopeArray2[i];
                hashSet.add(scope);
            }
            this.zzfhf.put(api, new zzs(hashSet));
        }
    }

    public static interface OnConnectionFailedListener {
        public void onConnectionFailed(@NonNull ConnectionResult var1);
    }

    public static interface ConnectionCallbacks {
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;
        public static final int CAUSE_NETWORK_LOST = 2;

        public void onConnected(@Nullable Bundle var1);

        public void onConnectionSuspended(int var1);
    }
}

