/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Looper;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultCallbacks;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.zzbeg;
import com.google.android.gms.internal.zzbet;
import com.google.android.gms.internal.zzbeu;
import java.lang.ref.WeakReference;

public final class zzbes<R extends Result>
extends TransformedResult<R>
implements ResultCallback<R> {
    private ResultTransform<? super R, ? extends Result> zzaFa = null;
    private zzbes<? extends Result> zzaFb = null;
    private volatile ResultCallbacks<? super R> zzaFc = null;
    private PendingResult<R> zzaFd = null;
    private final Object zzaBW = new Object();
    private Status zzaFe = null;
    private final WeakReference<GoogleApiClient> zzaBY;
    private final zzbeu zzaFf;
    private boolean zzaFg = false;

    public zzbes(WeakReference<GoogleApiClient> weakReference) {
        zzbo.zzb(weakReference, (Object)"GoogleApiClient reference must not be null");
        this.zzaBY = weakReference;
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzaBY.get();
        this.zzaFf = new zzbeu(this, googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public final <S extends Result> TransformedResult<S> then(@NonNull ResultTransform<? super R, ? extends S> resultTransform) {
        Object object = this.zzaBW;
        synchronized (object) {
            zzbo.zza((this.zzaFa == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            zzbo.zza((this.zzaFc == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zzaFa = resultTransform;
            zzbes<R> zzbes2 = new zzbes<R>(this.zzaBY);
            this.zzaFb = zzbes2;
            this.zzqJ();
            return zzbes2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void andFinally(@NonNull ResultCallbacks<? super R> resultCallbacks) {
        Object object = this.zzaBW;
        synchronized (object) {
            zzbo.zza((this.zzaFc == null ? 1 : 0) != 0, (Object)"Cannot call andFinally() twice.");
            zzbo.zza((this.zzaFa == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zzaFc = resultCallbacks;
            this.zzqJ();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onResult(R r) {
        Object object = this.zzaBW;
        synchronized (object) {
            if (r.getStatus().isSuccess()) {
                if (this.zzaFa != null) {
                    zzbeg.zzqj().submit(new zzbet(this, (Result)r));
                } else if (this.zzqL()) {
                    this.zzaFc.onSuccess(r);
                }
            } else {
                this.zzv(r.getStatus());
                zzbes.zzc(r);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(PendingResult<?> pendingResult) {
        Object object = this.zzaBW;
        synchronized (object) {
            this.zzaFd = pendingResult;
            this.zzqJ();
            return;
        }
    }

    private final void zzqJ() {
        if (this.zzaFa == null && this.zzaFc == null) {
            return;
        }
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzaBY.get();
        if (!this.zzaFg && this.zzaFa != null && googleApiClient != null) {
            googleApiClient.zza(this);
            this.zzaFg = true;
        }
        if (this.zzaFe != null) {
            this.zzw(this.zzaFe);
            return;
        }
        if (this.zzaFd != null) {
            this.zzaFd.setResultCallback(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzv(Status status) {
        Object object = this.zzaBW;
        synchronized (object) {
            this.zzaFe = status;
            this.zzw(this.zzaFe);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzw(Status status) {
        Object object = this.zzaBW;
        synchronized (object) {
            if (this.zzaFa != null) {
                Status status2 = this.zzaFa.onFailure(status);
                zzbo.zzb((Object)status2, (Object)"onFailure must not return null");
                super.zzv(status2);
            } else if (this.zzqL()) {
                this.zzaFc.onFailure(status);
            }
            return;
        }
    }

    final void zzqK() {
        this.zzaFc = null;
    }

    private final boolean zzqL() {
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzaBY.get();
        return this.zzaFc != null && googleApiClient != null;
    }

    private static void zzc(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
                return;
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"TransformedResultImpl", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    static /* synthetic */ ResultTransform zzc(zzbes zzbes2) {
        return zzbes2.zzaFa;
    }

    static /* synthetic */ zzbeu zzd(zzbes zzbes2) {
        return zzbes2.zzaFf;
    }

    static /* synthetic */ void zza(zzbes zzbes2, Result result) {
        zzbes.zzc(result);
    }

    static /* synthetic */ WeakReference zze(zzbes zzbes2) {
        return zzbes2.zzaBY;
    }

    static /* synthetic */ Object zzf(zzbes zzbes2) {
        return zzbes2.zzaBW;
    }

    static /* synthetic */ zzbes zzg(zzbes zzbes2) {
        return zzbes2.zzaFb;
    }

    static /* synthetic */ void zza(zzbes zzbes2, Status status) {
        zzbes2.zzv(status);
    }
}

