/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzad;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzbau;
import com.google.android.gms.internal.zzbay;
import com.google.android.gms.internal.zzbbe;
import com.google.android.gms.internal.zzbbi;
import com.google.android.gms.internal.zzbbk;
import com.google.android.gms.internal.zzbbp;
import com.google.android.gms.internal.zzbcq;
import com.google.android.gms.internal.zzbcr;
import com.google.android.gms.internal.zzbcs;
import com.google.android.gms.internal.zzbct;
import com.google.android.gms.internal.zzbcu;
import com.google.android.gms.internal.zzbcv;
import com.google.android.gms.internal.zzbcx;
import com.google.android.gms.internal.zzbdk;
import com.google.android.gms.internal.zzbdp;
import com.google.android.gms.internal.zzbdq;
import com.google.android.gms.internal.zzbdr;
import com.google.android.gms.internal.zzbdw;
import com.google.android.gms.internal.zzbea;
import com.google.android.gms.internal.zzbei;
import com.google.android.gms.internal.zzben;
import com.google.android.gms.internal.zzbes;
import com.google.android.gms.internal.zzbev;
import com.google.android.gms.internal.zzbfo;
import com.google.android.gms.internal.zzctk;
import com.google.android.gms.internal.zzctl;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;

public final class zzbcp
extends GoogleApiClient
implements zzbdq {
    private final Lock zzaCv;
    private boolean zzaBh;
    private final zzac zzaDy;
    private zzbdp zzaDz = null;
    private final int zzaBb;
    private final Context mContext;
    private final Looper zzrM;
    final Queue<zzbay<?, ?>> zzaCJ = new LinkedList();
    private volatile boolean zzaDA;
    private long zzaDB = 120000L;
    private long zzaDC = 5000L;
    private final zzbcu zzaDD;
    private final GoogleApiAvailability zzaBd;
    private zzbdk zzaDE;
    final Map<Api.zzc<?>, Api.zze> zzaDF;
    Set<Scope> zzaDG = new HashSet<Scope>();
    private zzq zzaCA;
    private Map<Api<?>, Boolean> zzaCD;
    private Api.zza<? extends zzctk, zzctl> zzaBe;
    private final zzbea zzaDH = new zzbea();
    private final ArrayList<zzbbi> zzaDI;
    private Integer zzaDJ = null;
    Set<zzbes> zzaDK = null;
    final zzbev zzaDL;
    private final zzad zzaDM = new zzbcq(this);

    public zzbcp(Context context, Lock lock, Looper looper, zzq zzq2, GoogleApiAvailability googleApiAvailability, Api.zza<? extends zzctk, zzctl> zza2, Map<Api<?>, Boolean> map, List<GoogleApiClient.ConnectionCallbacks> list, List<GoogleApiClient.OnConnectionFailedListener> list2, Map<Api.zzc<?>, Api.zze> map2, int n, int n2, ArrayList<zzbbi> arrayList, boolean bl) {
        this.mContext = context;
        this.zzaCv = lock;
        this.zzaBh = false;
        this.zzaDy = new zzac(looper, this.zzaDM);
        this.zzrM = looper;
        this.zzaDD = new zzbcu(this, looper);
        this.zzaBd = googleApiAvailability;
        this.zzaBb = n;
        if (this.zzaBb >= 0) {
            this.zzaDJ = n2;
        }
        this.zzaCD = map;
        this.zzaDF = map2;
        this.zzaDI = arrayList;
        this.zzaDL = new zzbev(this.zzaDF);
        for (GoogleApiClient.ConnectionCallbacks object : list) {
            this.zzaDy.registerConnectionCallbacks(object);
        }
        for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : list2) {
            this.zzaDy.registerConnectionFailedListener(onConnectionFailedListener);
        }
        this.zzaCA = zzq2;
        this.zzaBe = zza2;
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzbay<R, A>> T zzd(@NonNull T t) {
        zzbo.zzb((t.zzpd() != null ? 1 : 0) != 0, (Object)"This task can not be enqueued (it's probably a Batch or malformed)");
        String string2 = t.zzpg() != null ? t.zzpg().getName() : "the API";
        zzbo.zzb((boolean)this.zzaDF.containsKey(t.zzpd()), (Object)new StringBuilder(65 + String.valueOf(string2).length()).append("GoogleApiClient is not configured to use ").append(string2).append(" required for this call.").toString());
        this.zzaCv.lock();
        try {
            if (this.zzaDz == null) {
                this.zzaCJ.add(t);
                string2 = t;
                return (T)string2;
            }
            string2 = this.zzaDz.zzd(t);
            return (T)string2;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    @Override
    public final <A extends Api.zzb, T extends zzbay<? extends Result, A>> T zze(@NonNull T t) {
        zzbo.zzb((t.zzpd() != null ? 1 : 0) != 0, (Object)"This task can not be executed (it's probably a Batch or malformed)");
        Object object = t.zzpg() != null ? t.zzpg().getName() : "the API";
        zzbo.zzb((boolean)this.zzaDF.containsKey(t.zzpd()), (Object)new StringBuilder(65 + String.valueOf(object).length()).append("GoogleApiClient is not configured to use ").append((String)object).append(" required for this call.").toString());
        this.zzaCv.lock();
        try {
            if (this.zzaDz == null) {
                throw new IllegalStateException("GoogleApiClient is not connected yet.");
            }
            if (this.zzaDA) {
                this.zzaCJ.add(t);
                while (!this.zzaCJ.isEmpty()) {
                    object = this.zzaCJ.remove();
                    this.zzaDL.zzb((zzbbe<? extends Result>)object);
                    ((zzbay)object).zzr(Status.zzaBo);
                }
                object = t;
                return (T)object;
            }
            object = this.zzaDz.zze(t);
            return (T)object;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    @Override
    public final <L> zzbdw<L> zzp(@NonNull L l) {
        this.zzaCv.lock();
        try {
            Looper looper = this.zzrM;
            L l2 = l;
            zzbdw<L> zzbdw2 = this.zzaDH.zza(l2, looper, "NO_TYPE");
            return zzbdw2;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    @Override
    @NonNull
    public final <C extends Api.zze> C zza(@NonNull Api.zzc<C> zzc2) {
        Api.zze zze2 = this.zzaDF.get(zzc2);
        zzbo.zzb((Object)zze2, (Object)"Appropriate Api was not requested.");
        return (C)zze2;
    }

    @Override
    public final boolean zza(@NonNull Api<?> api) {
        return this.zzaDF.containsKey(api.zzpd());
    }

    @Override
    public final boolean hasConnectedApi(@NonNull Api<?> api) {
        if (!this.isConnected()) {
            return false;
        }
        Api.zze zze2 = this.zzaDF.get(api.zzpd());
        return zze2 != null && zze2.isConnected();
    }

    @Override
    @NonNull
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        block6: {
            ConnectionResult connectionResult;
            block7: {
                block8: {
                    this.zzaCv.lock();
                    if (!this.isConnected() && !this.zzaDA) {
                        throw new IllegalStateException("Cannot invoke getConnectionResult unless GoogleApiClient is connected");
                    }
                    if (!this.zzaDF.containsKey(api.zzpd())) break block6;
                    connectionResult = this.zzaDz.getConnectionResult(api);
                    if (connectionResult != null) break block7;
                    if (!this.zzaDA) break block8;
                    ConnectionResult connectionResult2 = ConnectionResult.zzazX;
                    this.zzaCv.unlock();
                    return connectionResult2;
                }
                Log.w((String)"GoogleApiClientImpl", (String)this.zzqg());
                Log.wtf((String)"GoogleApiClientImpl", (String)String.valueOf(api.getName()).concat(" requested in getConnectionResult is not connected but is not present in the failed  connections map"), (Throwable)new Exception());
                ConnectionResult connectionResult3 = new ConnectionResult(8, null);
                return connectionResult3;
            }
            ConnectionResult connectionResult4 = connectionResult;
            this.zzaCv.unlock();
            return connectionResult4;
        }
        try {
            throw new IllegalArgumentException(String.valueOf(api.getName()).concat(" was never registered with GoogleApiClient"));
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    @Override
    public final void connect() {
        this.zzaCv.lock();
        try {
            if (this.zzaBb >= 0) {
                zzbo.zza((this.zzaDJ != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zzaDJ == null) {
                this.zzaDJ = zzbcp.zza(this.zzaDF.values(), false);
            } else if (this.zzaDJ == 2) {
                throw new IllegalStateException("Cannot call connect() when SignInMode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.connect(this.zzaDJ);
            return;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    @Override
    public final void connect(int n) {
        this.zzaCv.lock();
        try {
            zzbo.zzb((n == 3 || n == 1 || n == 2 ? 1 : 0) != 0, (Object)new StringBuilder(33).append("Illegal sign-in mode: ").append(n).toString());
            this.zzap(n);
            this.zzqc();
            return;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect() {
        zzbo.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        this.zzaCv.lock();
        try {
            if (this.zzaBb >= 0) {
                zzbo.zza((this.zzaDJ != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zzaDJ == null) {
                this.zzaDJ = zzbcp.zza(this.zzaDF.values(), false);
            } else if (this.zzaDJ == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zzap(this.zzaDJ);
            this.zzaDy.zzrA();
            ConnectionResult connectionResult = this.zzaDz.blockingConnect();
            return connectionResult;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        zzbo.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        zzbo.zzb((Object)((Object)timeUnit), (Object)"TimeUnit must not be null");
        this.zzaCv.lock();
        try {
            if (this.zzaDJ == null) {
                this.zzaDJ = zzbcp.zza(this.zzaDF.values(), false);
            } else if (this.zzaDJ == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zzap(this.zzaDJ);
            this.zzaDy.zzrA();
            ConnectionResult connectionResult = this.zzaDz.blockingConnect(l, timeUnit);
            return connectionResult;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    @Override
    public final void disconnect() {
        this.zzaCv.lock();
        try {
            this.zzaDL.release();
            if (this.zzaDz != null) {
                this.zzaDz.disconnect();
            }
            this.zzaDH.release();
            for (zzbay zzbay2 : this.zzaCJ) {
                zzbay2.zza(null);
                zzbay2.cancel();
            }
            this.zzaCJ.clear();
            if (this.zzaDz == null) {
                return;
            }
            this.zzqe();
            this.zzaDy.zzrz();
            return;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    @Override
    public final void reconnect() {
        this.disconnect();
        this.connect();
    }

    @Override
    public final PendingResult<Status> clearDefaultAccountAndReconnect() {
        zzbo.zza((boolean)this.isConnected(), (Object)"GoogleApiClient is not connected yet.");
        zzbo.zza((this.zzaDJ != 2 ? 1 : 0) != 0, (Object)"Cannot use clearDefaultAccountAndReconnect with GOOGLE_SIGN_IN_API");
        zzben zzben2 = new zzben(this);
        if (this.zzaDF.containsKey(zzbfo.zzajR)) {
            this.zza(this, zzben2, false);
        } else {
            AtomicReference<GoogleApiClient> atomicReference = new AtomicReference<GoogleApiClient>();
            zzbcr zzbcr2 = new zzbcr(this, atomicReference, zzben2);
            zzbcs zzbcs2 = new zzbcs(this, zzben2);
            GoogleApiClient googleApiClient = new GoogleApiClient.Builder(this.mContext).addApi(zzbfo.API).addConnectionCallbacks(zzbcr2).addOnConnectionFailedListener(zzbcs2).setHandler(this.zzaDD).build();
            atomicReference.set(googleApiClient);
            googleApiClient.connect();
        }
        return zzben2;
    }

    private final void zza(GoogleApiClient googleApiClient, zzben zzben2, boolean bl) {
        zzbfo.zzaIy.zzd(googleApiClient).setResultCallback(new zzbct(this, zzben2, bl, googleApiClient));
    }

    @Override
    public final void stopAutoManage(@NonNull FragmentActivity fragmentActivity) {
        zzbdr zzbdr2 = new zzbdr((Activity)fragmentActivity);
        zzbcp zzbcp2 = this;
        if (zzbcp2.zzaBb >= 0) {
            zzbau.zza(zzbdr2).zzal(zzbcp2.zzaBb);
            return;
        }
        throw new IllegalStateException("Called stopAutoManage but automatic lifecycle management is not enabled.");
    }

    @Override
    public final boolean isConnected() {
        return this.zzaDz != null && this.zzaDz.isConnected();
    }

    @Override
    public final boolean isConnecting() {
        return this.zzaDz != null && this.zzaDz.isConnecting();
    }

    private final void zzap(int n) {
        if (this.zzaDJ == null) {
            this.zzaDJ = n;
        } else if (this.zzaDJ != n) {
            String string2 = String.valueOf(zzbcp.zzaq(n));
            String string3 = String.valueOf(zzbcp.zzaq(this.zzaDJ));
            throw new IllegalStateException(new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Cannot use sign-in mode: ").append(string2).append(". Mode was already set to ").append(string3).toString());
        }
        if (this.zzaDz != null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Api.zze zze2 : this.zzaDF.values()) {
            if (zze2.zzmv()) {
                bl = true;
            }
            if (!zze2.zzmG()) continue;
            bl2 = true;
        }
        switch (this.zzaDJ) {
            case 3: {
                break;
            }
            case 1: {
                if (!bl) {
                    throw new IllegalStateException("SIGN_IN_MODE_REQUIRED cannot be used on a GoogleApiClient that does not contain any authenticated APIs. Use connect() instead.");
                }
                if (!bl2) break;
                throw new IllegalStateException("Cannot use SIGN_IN_MODE_REQUIRED with GOOGLE_SIGN_IN_API. Use connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            case 2: {
                if (!bl) break;
                if (this.zzaBh) {
                    this.zzaDz = new zzbbp(this.mContext, this.zzaCv, this.zzrM, this.zzaBd, this.zzaDF, this.zzaCA, this.zzaCD, this.zzaBe, this.zzaDI, this, true);
                    return;
                }
                this.zzaDz = zzbbk.zza(this.mContext, this, this.zzaCv, this.zzrM, this.zzaBd, this.zzaDF, this.zzaCA, this.zzaCD, this.zzaBe, this.zzaDI);
                return;
            }
        }
        if (this.zzaBh && !bl2) {
            this.zzaDz = new zzbbp(this.mContext, this.zzaCv, this.zzrM, this.zzaBd, this.zzaDF, this.zzaCA, this.zzaCD, this.zzaBe, this.zzaDI, this, false);
            return;
        }
        this.zzaDz = new zzbcx(this.mContext, this, this.zzaCv, this.zzrM, this.zzaBd, this.zzaDF, this.zzaCA, this.zzaCD, this.zzaBe, this.zzaDI, this);
    }

    private final void zzqc() {
        this.zzaDy.zzrA();
        this.zzaDz.connect();
    }

    private final void resume() {
        this.zzaCv.lock();
        try {
            if (this.zzaDA) {
                this.zzqc();
            }
            return;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    private final void zzqd() {
        this.zzaCv.lock();
        try {
            if (this.zzqe()) {
                this.zzqc();
            }
            return;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    final boolean zzqe() {
        if (!this.zzaDA) {
            return false;
        }
        this.zzaDA = false;
        this.zzaDD.removeMessages(2);
        this.zzaDD.removeMessages(1);
        if (this.zzaDE != null) {
            this.zzaDE.unregister();
            this.zzaDE = null;
        }
        return true;
    }

    @Override
    public final void registerConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zzaDy.registerConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public final boolean isConnectionCallbacksRegistered(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        return this.zzaDy.isConnectionCallbacksRegistered(connectionCallbacks);
    }

    @Override
    public final void unregisterConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zzaDy.unregisterConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public final void registerConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zzaDy.registerConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    public final boolean isConnectionFailedListenerRegistered(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return this.zzaDy.isConnectionFailedListenerRegistered(onConnectionFailedListener);
    }

    @Override
    public final void unregisterConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zzaDy.unregisterConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    public final void zzm(Bundle bundle) {
        while (!this.zzaCJ.isEmpty()) {
            this.zze(this.zzaCJ.remove());
        }
        this.zzaDy.zzn(bundle);
    }

    @Override
    public final void zzc(ConnectionResult connectionResult) {
        if (!zze.zze((Context)this.mContext, (int)connectionResult.getErrorCode())) {
            this.zzqe();
        }
        if (!this.zzaDA) {
            this.zzaDy.zzk(connectionResult);
            this.zzaDy.zzrz();
        }
    }

    @Override
    public final void zze(int n, boolean bl) {
        if (n == 1 && !bl) {
            zzbcp zzbcp2 = this;
            if (!zzbcp2.zzaDA) {
                zzbcp2.zzaDA = true;
                if (zzbcp2.zzaDE == null) {
                    zzbcp2.zzaDE = GoogleApiAvailability.zza(zzbcp2.mContext.getApplicationContext(), new zzbcv(zzbcp2));
                }
                zzbcp2.zzaDD.sendMessageDelayed(zzbcp2.zzaDD.obtainMessage(1), zzbcp2.zzaDB);
                zzbcp2.zzaDD.sendMessageDelayed(zzbcp2.zzaDD.obtainMessage(2), zzbcp2.zzaDC);
            }
        }
        this.zzaDL.zzqM();
        this.zzaDy.zzaA(n);
        this.zzaDy.zzrz();
        if (n == 2) {
            this.zzqc();
        }
    }

    @Override
    public final Context getContext() {
        return this.mContext;
    }

    @Override
    public final Looper getLooper() {
        return this.zzrM;
    }

    @Override
    public final boolean zza(zzbei zzbei2) {
        return this.zzaDz != null && this.zzaDz.zza(zzbei2);
    }

    @Override
    public final void zzpl() {
        if (this.zzaDz != null) {
            this.zzaDz.zzpl();
        }
    }

    @Override
    public final void zza(zzbes zzbes2) {
        this.zzaCv.lock();
        try {
            if (this.zzaDK == null) {
                this.zzaDK = new HashSet<zzbes>();
            }
            this.zzaDK.add(zzbes2);
            return;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    @Override
    public final void zzb(zzbes zzbes2) {
        this.zzaCv.lock();
        try {
            if (this.zzaDK == null) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Attempted to remove pending transform when no transforms are registered.", (Throwable)new Exception());
            } else if (!this.zzaDK.remove(zzbes2)) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Failed to remove pending transform - this may lead to memory leaks!", (Throwable)new Exception());
            } else if (!this.zzqf()) {
                this.zzaDz.zzpE();
            }
            return;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    final boolean zzqf() {
        this.zzaCv.lock();
        try {
            if (this.zzaDK == null) {
                return false;
            }
            boolean bl = !this.zzaDK.isEmpty();
            return bl;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    final String zzqg() {
        StringWriter stringWriter = new StringWriter();
        this.dump("", null, new PrintWriter(stringWriter), null);
        return stringWriter.toString();
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("mContext=").println(this.mContext);
        printWriter.append(string2).append("mResuming=").print(this.zzaDA);
        printWriter.append(" mWorkQueue.size()=").print(this.zzaCJ.size());
        PrintWriter printWriter2 = printWriter;
        zzbev zzbev2 = this.zzaDL;
        printWriter2.append(" mUnconsumedApiCalls.size()=").println(zzbev2.zzaFl.size());
        if (this.zzaDz != null) {
            this.zzaDz.dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    public static int zza(Iterable<Api.zze> iterable, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (Api.zze zze2 : iterable) {
            if (zze2.zzmv()) {
                bl2 = true;
            }
            if (!zze2.zzmG()) continue;
            bl3 = true;
        }
        if (bl2) {
            if (bl3 && bl) {
                return 2;
            }
            return 1;
        }
        return 3;
    }

    private static String zzaq(int n) {
        switch (n) {
            case 3: {
                return "SIGN_IN_MODE_NONE";
            }
            case 1: {
                return "SIGN_IN_MODE_REQUIRED";
            }
            case 2: {
                return "SIGN_IN_MODE_OPTIONAL";
            }
        }
        return "UNKNOWN";
    }

    static /* synthetic */ void zza(zzbcp zzbcp2) {
        zzbcp2.resume();
    }

    static /* synthetic */ void zzb(zzbcp zzbcp2) {
        zzbcp2.zzqd();
    }

    static /* synthetic */ void zza(zzbcp zzbcp2, GoogleApiClient googleApiClient, zzben zzben2, boolean bl) {
        zzbcp2.zza(googleApiClient, zzben2, true);
    }

    static /* synthetic */ Context zzc(zzbcp zzbcp2) {
        return zzbcp2.mContext;
    }
}

