/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.internal.zzbbb;
import com.google.android.gms.internal.zzbbc;
import com.google.android.gms.internal.zzbds;
import com.google.android.gms.internal.zzbdt;
import java.util.concurrent.atomic.AtomicReference;

public abstract class zzbba
extends zzbds
implements DialogInterface.OnCancelListener {
    protected volatile boolean mStarted;
    protected final AtomicReference<zzbbb> zzaBN = new AtomicReference<Object>(null);
    private final Handler zzaBO = new Handler(Looper.getMainLooper());
    protected final GoogleApiAvailability zzaBd;

    protected zzbba(zzbdt zzbdt2) {
        this(zzbdt2, GoogleApiAvailability.getInstance());
    }

    private zzbba(zzbdt zzbdt2, GoogleApiAvailability googleApiAvailability) {
        super(zzbdt2);
        this.zzaBd = googleApiAvailability;
    }

    public void onCancel(DialogInterface dialogInterface) {
        this.zza(new ConnectionResult(13, null), zzbba.zza(this.zzaBN.get()));
        this.zzpx();
    }

    public final void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        if (bundle != null) {
            zzbbb zzbbb2;
            Bundle bundle2 = bundle;
            if (bundle2.getBoolean("resolving_error", false)) {
                ConnectionResult connectionResult = new ConnectionResult(bundle2.getInt("failed_status"), (PendingIntent)bundle2.getParcelable("failed_resolution"));
                int n = bundle2.getInt("failed_client_id", -1);
                zzbbb2 = new zzbbb(connectionResult, n);
            } else {
                zzbbb2 = null;
            }
            this.zzaBN.set(zzbbb2);
        }
    }

    public final void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        Bundle bundle2 = bundle;
        zzbbb zzbbb2 = this.zzaBN.get();
        if (zzbbb2 != null) {
            bundle2.putBoolean("resolving_error", true);
            bundle2.putInt("failed_client_id", zzbbb2.zzpy());
            bundle2.putInt("failed_status", zzbbb2.zzpz().getErrorCode());
            bundle2.putParcelable("failed_resolution", (Parcelable)zzbbb2.zzpz().getResolution());
        }
    }

    public void onStart() {
        super.onStart();
        this.mStarted = true;
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
        boolean bl = false;
        zzbbb zzbbb2 = this.zzaBN.get();
        switch (n) {
            case 2: {
                int n3 = this.zzaBd.isGooglePlayServicesAvailable((Context)this.getActivity());
                if (n3 == 0) {
                    bl = true;
                }
                if (zzbbb2 == null) {
                    return;
                }
                if (zzbbb2.zzpz().getErrorCode() != 18 || n3 != 18) break;
                return;
            }
            case 1: {
                if (n2 == -1) {
                    bl = true;
                    break;
                }
                if (n2 != 0) break;
                int n4 = 13;
                if (intent != null) {
                    n4 = intent.getIntExtra("<<ResolutionFailureErrorDetail>>", 13);
                }
                zzbbb2 = new zzbbb(new ConnectionResult(n4, null), zzbba.zza(zzbbb2));
                this.zzaBN.set(zzbbb2);
            }
        }
        if (bl) {
            this.zzpx();
            return;
        }
        if (zzbbb2 != null) {
            this.zza(zzbbb2.zzpz(), zzbbb2.zzpy());
        }
    }

    public void onStop() {
        super.onStop();
        this.mStarted = false;
    }

    protected abstract void zza(ConnectionResult var1, int var2);

    protected abstract void zzps();

    protected final void zzpx() {
        this.zzaBN.set(null);
        this.zzps();
    }

    public final void zzb(ConnectionResult connectionResult, int n) {
        zzbbb zzbbb2 = new zzbbb(connectionResult, n);
        if (this.zzaBN.compareAndSet(null, zzbbb2)) {
            this.zzaBO.post((Runnable)new zzbbc(this, zzbbb2));
        }
    }

    private static int zza(@Nullable zzbbb zzbbb2) {
        if (zzbbb2 == null) {
            return -1;
        }
        return zzbbb2.zzpy();
    }
}

