/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.accounts.Account;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.internal.zzy;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzal;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.internal.zzd;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzm;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.internal.zzctj;
import com.google.android.gms.internal.zzctk;
import com.google.android.gms.internal.zzctp;
import com.google.android.gms.internal.zzctr;
import com.google.android.gms.internal.zzcts;
import com.google.android.gms.internal.zzctu;
import com.google.android.gms.internal.zzctw;

public final class zzctt
extends zzz<zzctr>
implements zzctj {
    private final boolean zzbCT;
    private final zzq zzaCA;
    private final Bundle zzbCL;
    private Integer zzaHn;

    public zzctt(Context context, Looper looper, boolean bl, zzq zzq2, Bundle bundle, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 44, zzq2, connectionCallbacks, onConnectionFailedListener);
        this.zzbCT = bl;
        this.zzaCA = zzq2;
        this.zzbCL = bundle;
        this.zzaHn = zzq2.zzru();
    }

    public zzctt(Context context, Looper looper, boolean bl, zzq zzq2, zzctk zzctk2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this(context, looper, true, zzq2, zzctt.zza(zzq2), connectionCallbacks, onConnectionFailedListener);
    }

    @Override
    public final boolean zzmv() {
        return this.zzbCT;
    }

    @Override
    public final void zza(zzal zzal2, boolean bl) {
        try {
            ((zzctr)this.zzrf()).zza(zzal2, this.zzaHn, bl);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when saveDefaultAccount is called");
            return;
        }
    }

    @Override
    public final void zzAq() {
        try {
            ((zzctr)this.zzrf()).zzbv(this.zzaHn);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when clearAccountFromSessionStore is called");
            return;
        }
    }

    @Override
    public final void zza(zzctp zzctp2) {
        zzbo.zzb((Object)zzctp2, (Object)"Expecting a valid ISignInCallbacks");
        try {
            zzctt zzctt2 = this;
            Account account = zzctt2.zzaCA.zzrl();
            GoogleSignInAccount googleSignInAccount = null;
            if ("<<default account>>".equals(account.name)) {
                googleSignInAccount = zzy.zzaj(zzctt2.getContext()).zzmN();
            }
            zzbp zzbp2 = new zzbp(account, zzctt2.zzaHn, googleSignInAccount);
            ((zzctr)this.zzrf()).zza(new zzctu(zzbp2), zzctp2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when signIn is called");
            try {
                zzctp2.zzb(new zzctw(8));
                return;
            }
            catch (RemoteException remoteException2) {
                Log.wtf((String)"SignInClientImpl", (String)"ISignInCallbacks#onSignInComplete should be executed from the same process, unexpected RemoteException.", (Throwable)remoteException);
                return;
            }
        }
    }

    protected final String zzdb() {
        return "com.google.android.gms.signin.service.START";
    }

    protected final String zzdc() {
        return "com.google.android.gms.signin.internal.ISignInService";
    }

    protected final Bundle zzmo() {
        String string2 = this.zzaCA.zzrq();
        if (!this.getContext().getPackageName().equals(string2)) {
            this.zzbCL.putString("com.google.android.gms.signin.internal.realClientPackageName", this.zzaCA.zzrq());
        }
        return this.zzbCL;
    }

    @Override
    public final void connect() {
        this.zza((zzj)new zzm((zzd)this));
    }

    public static Bundle zza(zzq zzq2) {
        zzctk zzctk2 = zzq2.zzrt();
        Integer n = zzq2.zzru();
        Bundle bundle = new Bundle();
        bundle.putParcelable("com.google.android.gms.signin.internal.clientRequestedAccount", (Parcelable)zzq2.getAccount());
        if (n != null) {
            bundle.putInt("com.google.android.gms.common.internal.ClientSettings.sessionId", n.intValue());
        }
        if (zzctk2 != null) {
            bundle.putBoolean("com.google.android.gms.signin.internal.offlineAccessRequested", zzctk2.zzAr());
            bundle.putBoolean("com.google.android.gms.signin.internal.idTokenRequested", zzctk2.isIdTokenRequested());
            bundle.putString("com.google.android.gms.signin.internal.serverClientId", zzctk2.getServerClientId());
            bundle.putBoolean("com.google.android.gms.signin.internal.usePromptModeForAuthCode", true);
            bundle.putBoolean("com.google.android.gms.signin.internal.forceCodeForRefreshToken", zzctk2.zzAs());
            bundle.putString("com.google.android.gms.signin.internal.hostedDomain", zzctk2.zzAt());
            bundle.putBoolean("com.google.android.gms.signin.internal.waitForAccessTokenRefresh", zzctk2.zzAu());
            if (zzctk2.zzAv() != null) {
                bundle.putLong("com.google.android.gms.signin.internal.authApiSignInModuleVersion", zzctk2.zzAv().longValue());
            }
            if (zzctk2.zzAw() != null) {
                bundle.putLong("com.google.android.gms.signin.internal.realClientLibraryVersion", zzctk2.zzAw().longValue());
            }
        }
        return bundle;
    }

    protected final /* synthetic */ IInterface zzd(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.signin.internal.ISignInService");
        if (iInterface instanceof zzctr) {
            return (zzctr)iInterface;
        }
        return new zzcts(iBinder2);
    }
}

