/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.internal.zzbba;
import com.google.android.gms.internal.zzbbb;
import com.google.android.gms.internal.zzbdr;
import com.google.android.gms.internal.zzbds;
import java.util.concurrent.atomic.AtomicReference;

public abstract class zzbaz
extends zzbdr
implements DialogInterface.OnCancelListener {
    protected volatile boolean mStarted;
    protected final AtomicReference<zzbba> zzaBN = new AtomicReference<Object>(null);
    private final Handler zzaBO = new Handler(Looper.getMainLooper());
    protected final GoogleApiAvailability zzaBd;

    protected zzbaz(zzbds zzbds2) {
        this(zzbds2, GoogleApiAvailability.getInstance());
    }

    private zzbaz(zzbds zzbds2, GoogleApiAvailability googleApiAvailability) {
        super(zzbds2);
        this.zzaBd = googleApiAvailability;
    }

    public void onCancel(DialogInterface dialogInterface) {
        this.zza(new ConnectionResult(13, null), zzbaz.zza(this.zzaBN.get()));
        this.zzpx();
    }

    public final void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        if (bundle != null) {
            zzbba zzbba2;
            Bundle bundle2 = bundle;
            if (bundle2.getBoolean("resolving_error", false)) {
                ConnectionResult connectionResult = new ConnectionResult(bundle2.getInt("failed_status"), (PendingIntent)bundle2.getParcelable("failed_resolution"));
                int n = bundle2.getInt("failed_client_id", -1);
                zzbba2 = new zzbba(connectionResult, n);
            } else {
                zzbba2 = null;
            }
            this.zzaBN.set(zzbba2);
        }
    }

    public final void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        Bundle bundle2 = bundle;
        zzbba zzbba2 = this.zzaBN.get();
        if (zzbba2 != null) {
            bundle2.putBoolean("resolving_error", true);
            bundle2.putInt("failed_client_id", zzbba2.zzpy());
            bundle2.putInt("failed_status", zzbba2.zzpz().getErrorCode());
            bundle2.putParcelable("failed_resolution", (Parcelable)zzbba2.zzpz().getResolution());
        }
    }

    public void onStart() {
        super.onStart();
        this.mStarted = true;
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
        boolean bl = false;
        zzbba zzbba2 = this.zzaBN.get();
        switch (n) {
            case 2: {
                int n3 = this.zzaBd.isGooglePlayServicesAvailable((Context)this.getActivity());
                if (n3 == 0) {
                    bl = true;
                }
                if (zzbba2 == null) {
                    return;
                }
                if (zzbba2.zzpz().getErrorCode() != 18 || n3 != 18) break;
                return;
            }
            case 1: {
                if (n2 == -1) {
                    bl = true;
                    break;
                }
                if (n2 != 0) break;
                int n4 = 13;
                if (intent != null) {
                    n4 = intent.getIntExtra("<<ResolutionFailureErrorDetail>>", 13);
                }
                zzbba2 = new zzbba(new ConnectionResult(n4, null), zzbaz.zza(zzbba2));
                this.zzaBN.set(zzbba2);
            }
        }
        if (bl) {
            this.zzpx();
            return;
        }
        if (zzbba2 != null) {
            this.zza(zzbba2.zzpz(), zzbba2.zzpy());
        }
    }

    public void onStop() {
        super.onStop();
        this.mStarted = false;
    }

    protected abstract void zza(ConnectionResult var1, int var2);

    protected abstract void zzps();

    protected final void zzpx() {
        this.zzaBN.set(null);
        this.zzps();
    }

    public final void zzb(ConnectionResult connectionResult, int n) {
        zzbba zzbba2 = new zzbba(connectionResult, n);
        if (this.zzaBN.compareAndSet(null, zzbba2)) {
            this.zzaBO.post((Runnable)new zzbbb(this, zzbba2));
        }
    }

    private static int zza(@Nullable zzbba zzbba2) {
        if (zzbba2 == null) {
            return -1;
        }
        return zzbba2.zzpy();
    }
}

