/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbcu;
import com.google.android.gms.internal.zzbcv;
import com.google.android.gms.internal.zzbdm;
import com.google.android.gms.internal.zzbdp;
import com.google.android.gms.internal.zzbea;
import com.google.android.gms.internal.zzbeb;
import com.google.android.gms.internal.zzbei;
import com.google.android.gms.internal.zzbek;
import com.google.android.gms.internal.zzbel;
import com.google.android.gms.internal.zzbfb;
import com.google.android.gms.internal.zzbfc;
import com.google.android.gms.internal.zzbfu;
import com.google.android.gms.internal.zzcuw;
import com.google.android.gms.internal.zzcux;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public final class zzbej
implements zzbcv,
zzbfb {
    private final Lock zzaCx;
    private final Condition zzaDU;
    private final Context mContext;
    private final zze zzaCH;
    private final zzbel zzaDV;
    final Map<Api.zzc<?>, Api.zze> zzaDH;
    final Map<Api.zzc<?>, ConnectionResult> zzaDW = new HashMap();
    private zzq zzaCC;
    private Map<Api<?>, Boolean> zzaCF;
    private Api.zza<? extends zzcuw, zzcux> zzaBg;
    private volatile zzbei zzaDX;
    private ConnectionResult zzaDY = null;
    int zzaDZ;
    final zzbeb zzaCn;
    final zzbfc zzaEa;

    public zzbej(Context context, zzbeb zzbeb2, Lock lock, Looper looper, zze zze2, Map<Api.zzc<?>, Api.zze> map, zzq zzq2, Map<Api<?>, Boolean> map2, Api.zza<? extends zzcuw, zzcux> zza2, ArrayList<zzbcu> arrayList, zzbfc zzbfc2) {
        this.mContext = context;
        this.zzaCx = lock;
        this.zzaCH = zze2;
        this.zzaDH = map;
        this.zzaCC = zzq2;
        this.zzaCF = map2;
        this.zzaBg = zza2;
        this.zzaCn = zzbeb2;
        this.zzaEa = zzbfc2;
        ArrayList<zzbcu> arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            zzbcu zzbcu2 = arrayList2.get(i);
            zzbcu2.zza(this);
        }
        this.zzaDV = new zzbel(this, looper);
        this.zzaDU = lock.newCondition();
        this.zzaDX = new zzbea(this);
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzbck<R, A>> T zzd(@NonNull T t) {
        t.zzpA();
        return this.zzaDX.zzd(t);
    }

    @Override
    public final <A extends Api.zzb, T extends zzbck<? extends Result, A>> T zze(@NonNull T t) {
        t.zzpA();
        return this.zzaDX.zze(t);
    }

    @Override
    public final void connect() {
        this.zzaDX.connect();
    }

    @Override
    public final ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.zzaDU.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzazZ;
        }
        if (this.zzaDY != null) {
            return this.zzaDY;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final ConnectionResult blockingConnect(long l, TimeUnit timeUnit) {
        this.connect();
        long l2 = timeUnit.toNanos(l);
        while (this.isConnecting()) {
            try {
                if (l2 <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l2 = this.zzaDU.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzazZ;
        }
        if (this.zzaDY != null) {
            return this.zzaDY;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final void disconnect() {
        if (this.zzaDX.disconnect()) {
            this.zzaDW.clear();
        }
    }

    @Override
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        Api.zzc<?> zzc2 = api.zzpb();
        if (this.zzaDH.containsKey(zzc2)) {
            if (this.zzaDH.get(zzc2).isConnected()) {
                return ConnectionResult.zzazZ;
            }
            if (this.zzaDW.containsKey(zzc2)) {
                return this.zzaDW.get(zzc2);
            }
        }
        return null;
    }

    final void zzqf() {
        this.zzaCx.lock();
        try {
            this.zzaDX = new zzbdp(this, this.zzaCC, this.zzaCF, this.zzaCH, this.zzaBg, this.zzaCx, this.mContext);
            this.zzaDX.begin();
            this.zzaDU.signalAll();
            return;
        }
        finally {
            this.zzaCx.unlock();
        }
    }

    final void zzqg() {
        this.zzaCx.lock();
        try {
            this.zzaCn.zzqc();
            this.zzaDX = new zzbdm(this);
            this.zzaDX.begin();
            this.zzaDU.signalAll();
            return;
        }
        finally {
            this.zzaCx.unlock();
        }
    }

    final void zzg(ConnectionResult connectionResult) {
        this.zzaCx.lock();
        try {
            this.zzaDY = connectionResult;
            this.zzaDX = new zzbea(this);
            this.zzaDX.begin();
            this.zzaDU.signalAll();
            return;
        }
        finally {
            this.zzaCx.unlock();
        }
    }

    @Override
    public final boolean isConnected() {
        return this.zzaDX instanceof zzbdm;
    }

    @Override
    public final boolean isConnecting() {
        return this.zzaDX instanceof zzbdp;
    }

    @Override
    public final boolean zza(zzbfu zzbfu2) {
        return false;
    }

    @Override
    public final void zzpj() {
    }

    @Override
    public final void zzpC() {
        if (this.isConnected()) {
            ((zzbdm)this.zzaDX).zzpS();
        }
    }

    @Override
    public final void zza(@NonNull ConnectionResult connectionResult, @NonNull Api<?> api, boolean bl) {
        this.zzaCx.lock();
        try {
            this.zzaDX.zza(connectionResult, api, bl);
            return;
        }
        finally {
            this.zzaCx.unlock();
        }
    }

    @Override
    public final void onConnected(@Nullable Bundle bundle) {
        this.zzaCx.lock();
        try {
            this.zzaDX.onConnected(bundle);
            return;
        }
        finally {
            this.zzaCx.unlock();
        }
    }

    @Override
    public final void onConnectionSuspended(int n) {
        this.zzaCx.lock();
        try {
            this.zzaDX.onConnectionSuspended(n);
            return;
        }
        finally {
            this.zzaCx.unlock();
        }
    }

    final void zza(zzbek zzbek2) {
        Message message = this.zzaDV.obtainMessage(1, zzbek2);
        this.zzaDV.sendMessage(message);
    }

    final void zza(RuntimeException runtimeException) {
        Message message = this.zzaDV.obtainMessage(2, runtimeException);
        this.zzaDV.sendMessage(message);
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3 = String.valueOf(string2).concat("  ");
        printWriter.append(string2).append("mState=").println(this.zzaDX);
        for (Api<?> api : this.zzaCF.keySet()) {
            printWriter.append(string2).append(api.getName()).println(":");
            this.zzaDH.get(api.zzpb()).dump(string3, fileDescriptor, printWriter, stringArray);
        }
    }

    static /* synthetic */ Lock zza(zzbej zzbej2) {
        return zzbej2.zzaCx;
    }

    static /* synthetic */ zzbei zzb(zzbej zzbej2) {
        return zzbej2.zzaDX;
    }
}

