/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.zzc;
import com.google.android.gms.common.api.zzd;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.internal.zzbce;
import com.google.android.gms.internal.zzbcf;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbdi;
import com.google.android.gms.internal.zzben;
import com.google.android.gms.internal.zzbep;
import com.google.android.gms.internal.zzbev;
import com.google.android.gms.internal.zzbfv;
import com.google.android.gms.internal.zzbfy;
import com.google.android.gms.internal.zzbgc;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;

public class GoogleApi<O extends Api.ApiOptions> {
    private final Context mContext;
    private final Api<O> zzayY;
    private final O zzaAL;
    private final zzbcf<O> zzaAM;
    private final Looper zzrP;
    private final int mId;
    private final GoogleApiClient zzaAN;
    private final zzbfy zzaAO;
    private final Account zzajd;
    protected final zzben zzaAP;

    protected GoogleApi(@NonNull Context context, Api<O> api, Looper looper) {
        zzbr.zzb((Object)context, (Object)"Null context is not permitted.");
        zzbr.zzb(api, (Object)"Api must not be null.");
        zzbr.zzb((Object)looper, (Object)"Looper must not be null.");
        this.mContext = context.getApplicationContext();
        this.zzayY = api;
        this.zzaAL = null;
        this.zzrP = looper;
        this.zzaAM = zzbcf.zzb(api);
        this.zzaAN = new zzbev(this);
        this.zzaAP = zzben.zzay(this.mContext);
        this.mId = this.zzaAP.zzqk();
        this.zzaAO = new zzbce();
        this.zzajd = null;
    }

    @Deprecated
    public GoogleApi(@NonNull Context context, Api<O> api, O o, Looper looper, zzbfy zzbfy2) {
        this(context, api, null, new zzd().zza(looper).zza(zzbfy2).zzph());
    }

    @MainThread
    private GoogleApi(@NonNull Activity activity, Api<O> api, O o, zza zza2) {
        zzbr.zzb((Object)activity, (Object)"Null activity is not permitted.");
        zzbr.zzb(api, (Object)"Api must not be null.");
        zzbr.zzb((Object)zza2, (Object)"Settings must not be null; use Settings.DEFAULT_SETTINGS instead.");
        this.mContext = activity.getApplicationContext();
        this.zzayY = api;
        this.zzaAL = null;
        this.zzrP = zza2.zzaAS;
        this.zzaAM = zzbcf.zza(this.zzayY, this.zzaAL);
        this.zzaAN = new zzbev(this);
        this.zzaAP = zzben.zzay(this.mContext);
        this.mId = this.zzaAP.zzqk();
        this.zzaAO = zza2.zzaAR;
        this.zzajd = zza2.account;
        zzbdi.zza(activity, this.zzaAP, this.zzaAM);
        this.zzaAP.zzb(this);
    }

    public GoogleApi(@NonNull Context context, Api<O> api, O o, zza zza2) {
        zzbr.zzb((Object)context, (Object)"Null context is not permitted.");
        zzbr.zzb(api, (Object)"Api must not be null.");
        zzbr.zzb((Object)zza2, (Object)"Settings must not be null; use Settings.DEFAULT_SETTINGS instead.");
        this.mContext = context.getApplicationContext();
        this.zzayY = api;
        this.zzaAL = o;
        this.zzrP = zza2.zzaAS;
        this.zzaAM = zzbcf.zza(this.zzayY, this.zzaAL);
        this.zzaAN = new zzbev(this);
        this.zzaAP = zzben.zzay(this.mContext);
        this.mId = this.zzaAP.zzqk();
        this.zzaAO = zza2.zzaAR;
        this.zzajd = zza2.account;
        this.zzaAP.zzb(this);
    }

    @Deprecated
    public GoogleApi(@NonNull Activity activity, Api<O> api, O o, zzbfy zzbfy2) {
        this(activity, api, null, new zzd().zza(zzbfy2).zza(activity.getMainLooper()).zzph());
    }

    @Deprecated
    public GoogleApi(@NonNull Context context, Api<O> api, O o, zzbfy zzbfy2) {
        this(context, api, o, new zzd().zza(zzbfy2).zzph());
    }

    private final <A extends Api.zzb, T extends zzbck<? extends Result, A>> T zza(int n, @NonNull T t) {
        t.zzpA();
        this.zzaAP.zza(this, n, t);
        return t;
    }

    private final <TResult, A extends Api.zzb> Task<TResult> zza(int n, @NonNull zzbgc<A, TResult> zzbgc2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzaAP.zza(this, n, zzbgc2, taskCompletionSource, this.zzaAO);
        return taskCompletionSource.getTask();
    }

    public final <A extends Api.zzb, T extends zzbck<? extends Result, A>> T zza(@NonNull T t) {
        return this.zza(0, t);
    }

    public final <TResult, A extends Api.zzb> Task<TResult> zza(zzbgc<A, TResult> zzbgc2) {
        return this.zza(0, zzbgc2);
    }

    public final <A extends Api.zzb, T extends zzbck<? extends Result, A>> T zzb(@NonNull T t) {
        return this.zza(1, t);
    }

    public final <TResult, A extends Api.zzb> Task<TResult> zzb(zzbgc<A, TResult> zzbgc2) {
        return this.zza(1, zzbgc2);
    }

    public final <A extends Api.zzb, T extends zzbck<? extends Result, A>> T zzc(@NonNull T t) {
        return this.zza(2, t);
    }

    @WorkerThread
    public Api.zze zza(Looper looper, zzbep<O> zzbep2) {
        zzq zzq2 = new GoogleApiClient.Builder(this.mContext).zze(this.zzajd).zzpl();
        return this.zzayY.zzpa().zza(this.mContext, looper, zzq2, this.zzaAL, zzbep2, zzbep2);
    }

    public final Api<O> zzpe() {
        return this.zzayY;
    }

    public final zzbcf<O> zzpf() {
        return this.zzaAM;
    }

    public final int getInstanceId() {
        return this.mId;
    }

    public final GoogleApiClient zzpg() {
        return this.zzaAN;
    }

    public final Looper getLooper() {
        return this.zzrP;
    }

    public final Context getApplicationContext() {
        return this.mContext;
    }

    public zzbfv zza(Context context, Handler handler) {
        return new zzbfv(context, handler);
    }

    public static final class zza {
        public static final zza zzaAQ = new zzd().zzph();
        public final zzbfy zzaAR;
        public final Account account;
        public final Looper zzaAS;

        private zza(zzbfy zzbfy2, Account account, Looper looper) {
            this.zzaAR = zzbfy2;
            this.account = account;
            this.zzaAS = looper;
        }

        /* synthetic */ zza(zzbfy zzbfy2, Account account, Looper looper, zzc zzc2) {
            this(zzbfy2, null, looper);
        }
    }
}

