/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Dialog;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.annotation.MainThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.GoogleApiActivity;
import com.google.android.gms.internal.zzaaz;
import com.google.android.gms.internal.zzabe;
import com.google.android.gms.internal.zzabf;

public abstract class zzaae
extends zzabe
implements DialogInterface.OnCancelListener {
    protected boolean mStarted;
    protected boolean zzazZ;
    private ConnectionResult zzaAa;
    private int zzaAb = -1;
    private final Handler zzaAc = new Handler(Looper.getMainLooper());
    protected final GoogleApiAvailability zzazn;

    protected zzaae(zzabf zzabf2) {
        this(zzabf2, GoogleApiAvailability.getInstance());
    }

    zzaae(zzabf zzabf2, GoogleApiAvailability googleApiAvailability) {
        super(zzabf2);
        this.zzazn = googleApiAvailability;
    }

    public void onCancel(DialogInterface dialogInterface) {
        this.zza(new ConnectionResult(13, null), this.zzaAb);
        this.zzvD();
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        if (bundle != null) {
            this.zzazZ = bundle.getBoolean("resolving_error", false);
            if (this.zzazZ) {
                this.zzaAb = bundle.getInt("failed_client_id", -1);
                this.zzaAa = new ConnectionResult(bundle.getInt("failed_status"), (PendingIntent)bundle.getParcelable("failed_resolution"));
            }
        }
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putBoolean("resolving_error", this.zzazZ);
        if (this.zzazZ) {
            bundle.putInt("failed_client_id", this.zzaAb);
            bundle.putInt("failed_status", this.zzaAa.getErrorCode());
            bundle.putParcelable("failed_resolution", (Parcelable)this.zzaAa.getResolution());
        }
    }

    public void onStart() {
        super.onStart();
        this.mStarted = true;
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        boolean bl = false;
        switch (n) {
            case 2: {
                int n3 = this.zzazn.isGooglePlayServicesAvailable((Context)this.getActivity());
                if (n3 == 0) {
                    bl = true;
                }
                if (this.zzaAa.getErrorCode() != 18 || n3 != 18) break;
                return;
            }
            case 1: {
                if (n2 == -1) {
                    bl = true;
                    break;
                }
                if (n2 != 0) break;
                int n4 = 13;
                if (intent != null) {
                    n4 = intent.getIntExtra("<<ResolutionFailureErrorDetail>>", 13);
                }
                this.zzaAa = new ConnectionResult(n4, null);
            }
        }
        if (bl) {
            this.zzvD();
        } else {
            this.zza(this.zzaAa, this.zzaAb);
        }
    }

    public void onStop() {
        super.onStop();
        this.mStarted = false;
    }

    protected abstract void zza(ConnectionResult var1, int var2);

    protected abstract void zzvx();

    protected void zzvD() {
        this.zzaAb = -1;
        this.zzazZ = false;
        this.zzaAa = null;
        this.zzvx();
    }

    public void zzb(ConnectionResult connectionResult, int n) {
        if (!this.zzazZ) {
            this.zzazZ = true;
            this.zzaAb = n;
            this.zzaAa = connectionResult;
            this.zzaAc.post((Runnable)new zza());
        }
    }

    private class zza
    implements Runnable {
        private zza() {
        }

        @Override
        @MainThread
        public void run() {
            if (!zzaae.this.mStarted) {
                return;
            }
            if (zzaae.this.zzaAa.hasResolution()) {
                zzaae.this.zzaCR.startActivityForResult(GoogleApiActivity.zzb((Context)zzaae.this.getActivity(), zzaae.this.zzaAa.getResolution(), zzaae.this.zzaAb, false), 1);
            } else if (zzaae.this.zzazn.isUserResolvableError(zzaae.this.zzaAa.getErrorCode())) {
                zzaae.this.zzazn.zza(zzaae.this.getActivity(), zzaae.this.zzaCR, zzaae.this.zzaAa.getErrorCode(), 2, zzaae.this);
            } else if (zzaae.this.zzaAa.getErrorCode() == 18) {
                final Dialog dialog = zzaae.this.zzazn.zza(zzaae.this.getActivity(), zzaae.this);
                zzaae.this.zzazn.zza(zzaae.this.getActivity().getApplicationContext(), new zzaaz.zza(){

                    @Override
                    public void zzvE() {
                        zzaae.this.zzvD();
                        if (dialog.isShowing()) {
                            dialog.dismiss();
                        }
                    }
                });
            } else {
                zzaae.this.zza(zzaae.this.zzaAa, zzaae.this.zzaAb);
            }
        }
    }
}

