/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzaad;
import com.google.android.gms.internal.zzaag;
import com.google.android.gms.internal.zzaat;
import com.google.android.gms.internal.zzaav;
import com.google.android.gms.internal.zzabc;
import com.google.android.gms.internal.zzabq;
import com.google.android.gms.internal.zzbai;
import com.google.android.gms.internal.zzbaj;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;

final class zzaai
implements zzabc {
    private final Context mContext;
    private final zzaat zzaAw;
    private final Looper zzrs;
    private final zzaav zzaAx;
    private final zzaav zzaAy;
    private final Map<Api.zzc<?>, zzaav> zzaAz;
    private final Set<zzabq> zzaAA = Collections.newSetFromMap(new WeakHashMap());
    private final Api.zze zzaAB;
    private Bundle zzaAC;
    private ConnectionResult zzaAD = null;
    private ConnectionResult zzaAE = null;
    private boolean zzaAF = false;
    private final Lock zzaAG;
    private int zzaAH = 0;

    public static zzaai zza(Context context, zzaat zzaat2, Lock lock, Looper looper, zze zze2, Map<Api.zzc<?>, Api.zze> map, zzg zzg2, Map<Api<?>, Boolean> map2, Api.zza<? extends zzbai, zzbaj> zza2, ArrayList<zzaag> arrayList) {
        Object object;
        Api.zze zze3 = null;
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        for (Map.Entry<Api.zzc<?>, Api.zze> arrayMap4 : map.entrySet()) {
            object = arrayMap4.getValue();
            if (object.zzrr()) {
                zze3 = object;
            }
            if (object.zzrd()) {
                arrayMap2.put(arrayMap4.getKey(), object);
                continue;
            }
            arrayMap3.put(arrayMap4.getKey(), object);
        }
        zzac.zza((!arrayMap2.isEmpty() ? 1 : 0) != 0, (Object)"CompositeGoogleApiClient should not be used without any APIs that require sign-in.");
        ArrayMap arrayMap5 = new ArrayMap();
        ArrayMap arrayMap = new ArrayMap();
        for (Api api : map2.keySet()) {
            Api.zzc<?> zzc2 = api.zzvg();
            if (arrayMap2.containsKey(zzc2)) {
                arrayMap5.put(api, map2.get(api));
                continue;
            }
            if (arrayMap3.containsKey(zzc2)) {
                arrayMap.put(api, map2.get(api));
                continue;
            }
            throw new IllegalStateException("Each API in the isOptionalMap must have a corresponding client in the clients map.");
        }
        object = new ArrayList<zzaag>();
        ArrayList<zzaag> arrayList2 = new ArrayList<zzaag>();
        for (zzaag zzaag2 : arrayList) {
            if (arrayMap5.containsKey(zzaag2.zzaxf)) {
                ((ArrayList)object).add(zzaag2);
                continue;
            }
            if (arrayMap.containsKey(zzaag2.zzaxf)) {
                arrayList2.add(zzaag2);
                continue;
            }
            throw new IllegalStateException("Each ClientCallbacks must have a corresponding API in the isOptionalMap");
        }
        return new zzaai(context, zzaat2, lock, looper, zze2, (Map<Api.zzc<?>, Api.zze>)arrayMap2, (Map<Api.zzc<?>, Api.zze>)arrayMap3, zzg2, zza2, zze3, (ArrayList<zzaag>)object, arrayList2, (Map<Api<?>, Boolean>)arrayMap5, (Map<Api<?>, Boolean>)arrayMap);
    }

    private zzaai(Context context, zzaat zzaat2, Lock lock, Looper looper, zze zze2, Map<Api.zzc<?>, Api.zze> map, Map<Api.zzc<?>, Api.zze> map2, zzg zzg2, Api.zza<? extends zzbai, zzbaj> zza2, Api.zze zze3, ArrayList<zzaag> arrayList, ArrayList<zzaag> arrayList2, Map<Api<?>, Boolean> map3, Map<Api<?>, Boolean> map4) {
        this.mContext = context;
        this.zzaAw = zzaat2;
        this.zzaAG = lock;
        this.zzrs = looper;
        this.zzaAB = zze3;
        this.zzaAx = new zzaav(context, this.zzaAw, lock, looper, zze2, map2, null, map4, null, arrayList2, new zza());
        this.zzaAy = new zzaav(context, this.zzaAw, lock, looper, zze2, map, zzg2, map3, zza2, arrayList, new zzb());
        ArrayMap arrayMap = new ArrayMap();
        for (Api.zzc<?> zzc2 : map2.keySet()) {
            arrayMap.put(zzc2, (Object)this.zzaAx);
        }
        for (Api.zzc<?> zzc2 : map.keySet()) {
            arrayMap.put(zzc2, (Object)this.zzaAy);
        }
        this.zzaAz = Collections.unmodifiableMap(arrayMap);
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zzaad.zza<R, A>> T zza(@NonNull T t) {
        if (this.zzc(t)) {
            if (this.zzvS()) {
                t.zzB(new Status(4, null, this.zzvT()));
                return t;
            }
            return this.zzaAy.zza(t);
        }
        return this.zzaAx.zza(t);
    }

    @Override
    public <A extends Api.zzb, T extends zzaad.zza<? extends Result, A>> T zzb(@NonNull T t) {
        if (this.zzc(t)) {
            if (this.zzvS()) {
                t.zzB(new Status(4, null, this.zzvT()));
                return t;
            }
            return this.zzaAy.zzb(t);
        }
        return this.zzaAx.zzb(t);
    }

    @Override
    @Nullable
    public ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        if (this.zzaAz.get(api.zzvg()).equals(this.zzaAy)) {
            if (this.zzvS()) {
                return new ConnectionResult(4, this.zzvT());
            }
            return this.zzaAy.getConnectionResult(api);
        }
        return this.zzaAx.getConnectionResult(api);
    }

    @Override
    public void connect() {
        this.zzaAH = 2;
        this.zzaAF = false;
        this.zzvO();
    }

    @Override
    public ConnectionResult blockingConnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void disconnect() {
        this.zzaAE = null;
        this.zzaAD = null;
        this.zzaAH = 0;
        this.zzaAx.disconnect();
        this.zzaAy.disconnect();
        this.zzvR();
    }

    @Override
    public boolean isConnected() {
        this.zzaAG.lock();
        try {
            boolean bl = this.zzaAx.isConnected() && (this.zzvN() || this.zzvS() || this.zzaAH == 1);
            return bl;
        }
        finally {
            this.zzaAG.unlock();
        }
    }

    @Override
    public boolean isConnecting() {
        this.zzaAG.lock();
        try {
            boolean bl = this.zzaAH == 2;
            return bl;
        }
        finally {
            this.zzaAG.unlock();
        }
    }

    @Override
    public boolean zza(zzabq zzabq2) {
        this.zzaAG.lock();
        try {
            if ((this.isConnecting() || this.isConnected()) && !this.zzvN()) {
                this.zzaAA.add(zzabq2);
                if (this.zzaAH == 0) {
                    this.zzaAH = 1;
                }
                this.zzaAE = null;
                this.zzaAy.connect();
                return true;
            }
        }
        finally {
            this.zzaAG.unlock();
        }
        return false;
    }

    @Override
    public void zzvM() {
        this.zzaAx.zzvM();
        this.zzaAy.zzvM();
    }

    @Override
    public void zzvn() {
        this.zzaAG.lock();
        try {
            boolean bl = this.isConnecting();
            this.zzaAy.disconnect();
            this.zzaAE = new ConnectionResult(4);
            if (bl) {
                Handler handler = new Handler(this.zzrs);
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        zzaai.this.zzaAG.lock();
                        try {
                            zzaai.this.zzvP();
                        }
                        finally {
                            zzaai.this.zzaAG.unlock();
                        }
                    }
                });
            } else {
                this.zzvR();
            }
        }
        finally {
            this.zzaAG.unlock();
        }
    }

    public boolean zzvN() {
        return this.zzaAy.isConnected();
    }

    private void zzvO() {
        this.zzaAE = null;
        this.zzaAD = null;
        this.zzaAx.connect();
        this.zzaAy.connect();
    }

    private void zzvP() {
        if (zzaai.zzb(this.zzaAD)) {
            if (zzaai.zzb(this.zzaAE) || this.zzvS()) {
                this.zzvQ();
            } else if (this.zzaAE != null) {
                if (this.zzaAH == 1) {
                    this.zzvR();
                } else {
                    this.zza(this.zzaAE);
                    this.zzaAx.disconnect();
                }
            }
        } else if (this.zzaAD != null && zzaai.zzb(this.zzaAE)) {
            this.zzaAy.disconnect();
            this.zza(this.zzaAD);
        } else if (this.zzaAD != null && this.zzaAE != null) {
            ConnectionResult connectionResult = this.zzaAD;
            if (this.zzaAy.zzaCi < this.zzaAx.zzaCi) {
                connectionResult = this.zzaAE;
            }
            this.zza(connectionResult);
        }
    }

    private void zzvQ() {
        switch (this.zzaAH) {
            case 2: {
                this.zzaAw.zzo(this.zzaAC);
            }
            case 1: {
                this.zzvR();
                break;
            }
            default: {
                Log.wtf((String)"CompositeGAC", (String)"Attempted to call success callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)((Object)new AssertionError()));
            }
        }
        this.zzaAH = 0;
    }

    private void zza(ConnectionResult connectionResult) {
        switch (this.zzaAH) {
            case 2: {
                this.zzaAw.zzc(connectionResult);
            }
            case 1: {
                this.zzvR();
                break;
            }
            default: {
                Log.wtf((String)"CompositeGAC", (String)"Attempted to call failure callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)new Exception());
            }
        }
        this.zzaAH = 0;
    }

    private void zzvR() {
        for (zzabq zzabq2 : this.zzaAA) {
            zzabq2.zzrq();
        }
        this.zzaAA.clear();
    }

    private void zzb(int n, boolean bl) {
        this.zzaAw.zzc(n, bl);
        this.zzaAE = null;
        this.zzaAD = null;
    }

    private boolean zzvS() {
        return this.zzaAE != null && this.zzaAE.getErrorCode() == 4;
    }

    private boolean zzc(zzaad.zza<? extends Result, ? extends Api.zzb> zza2) {
        Api.zzc<? extends Api.zzb> zzc2 = zza2.zzvg();
        zzac.zzb((boolean)this.zzaAz.containsKey(zzc2), (Object)"GoogleApiClient is not configured to use the API required for this call.");
        return this.zzaAz.get(zzc2).equals(this.zzaAy);
    }

    @Nullable
    private PendingIntent zzvT() {
        if (this.zzaAB == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)this.zzaAw.getSessionId(), (Intent)this.zzaAB.zzrs(), (int)0x8000000);
    }

    private void zzn(Bundle bundle) {
        if (this.zzaAC == null) {
            this.zzaAC = bundle;
        } else if (bundle != null) {
            this.zzaAC.putAll(bundle);
        }
    }

    private static boolean zzb(ConnectionResult connectionResult) {
        return connectionResult != null && connectionResult.isSuccess();
    }

    @Override
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("authClient").println(":");
        this.zzaAy.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
        printWriter.append(string2).append("anonClient").println(":");
        this.zzaAx.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
    }

    private class zzb
    implements zzabc.zza {
        private zzb() {
        }

        @Override
        public void zzo(@Nullable Bundle bundle) {
            zzaai.this.zzaAG.lock();
            try {
                zzaai.this.zzaAE = ConnectionResult.zzayj;
                zzaai.this.zzvP();
            }
            finally {
                zzaai.this.zzaAG.unlock();
            }
        }

        @Override
        public void zzc(@NonNull ConnectionResult connectionResult) {
            zzaai.this.zzaAG.lock();
            try {
                zzaai.this.zzaAE = connectionResult;
                zzaai.this.zzvP();
            }
            finally {
                zzaai.this.zzaAG.unlock();
            }
        }

        @Override
        public void zzc(int n, boolean bl) {
            zzaai.this.zzaAG.lock();
            try {
                if (zzaai.this.zzaAF) {
                    zzaai.this.zzaAF = false;
                    zzaai.this.zzb(n, bl);
                    return;
                }
                zzaai.this.zzaAF = true;
                zzaai.this.zzaAx.onConnectionSuspended(n);
            }
            finally {
                zzaai.this.zzaAG.unlock();
            }
        }
    }

    private class zza
    implements zzabc.zza {
        private zza() {
        }

        @Override
        public void zzo(@Nullable Bundle bundle) {
            zzaai.this.zzaAG.lock();
            try {
                zzaai.this.zzn(bundle);
                zzaai.this.zzaAD = ConnectionResult.zzayj;
                zzaai.this.zzvP();
            }
            finally {
                zzaai.this.zzaAG.unlock();
            }
        }

        @Override
        public void zzc(@NonNull ConnectionResult connectionResult) {
            zzaai.this.zzaAG.lock();
            try {
                zzaai.this.zzaAD = connectionResult;
                zzaai.this.zzvP();
            }
            finally {
                zzaai.this.zzaAG.unlock();
            }
        }

        @Override
        public void zzc(int n, boolean bl) {
            zzaai.this.zzaAG.lock();
            try {
                if (zzaai.this.zzaAF || zzaai.this.zzaAE == null || !zzaai.this.zzaAE.isSuccess()) {
                    zzaai.this.zzaAF = false;
                    zzaai.this.zzb(n, bl);
                    return;
                }
                zzaai.this.zzaAF = true;
                zzaai.this.zzaAy.onConnectionSuspended(n);
            }
            finally {
                zzaai.this.zzaAG.unlock();
            }
        }
    }
}

