/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.auth-api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.auth.api.identity.BeginSignInRequest;
import com.google.android.gms.auth.api.identity.BeginSignInResult;
import com.google.android.gms.auth.api.identity.GetPhoneNumberHintIntentRequest;
import com.google.android.gms.auth.api.identity.GetSignInIntentRequest;
import com.google.android.gms.auth.api.identity.SignInClient;
import com.google.android.gms.auth.api.identity.SignInCredential;
import com.google.android.gms.auth.api.identity.zbs;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.GoogleApiManager;
import com.google.android.gms.common.api.internal.IStatusCallback;
import com.google.android.gms.common.api.internal.RemoteCall;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.internal.auth-api.zbag;
import com.google.android.gms.internal.auth-api.zbah;
import com.google.android.gms.internal.auth-api.zbai;
import com.google.android.gms.internal.auth-api.zbaj;
import com.google.android.gms.internal.auth-api.zbak;
import com.google.android.gms.internal.auth-api.zbam;
import com.google.android.gms.internal.auth-api.zbao;
import com.google.android.gms.internal.auth-api.zbaq;
import com.google.android.gms.internal.auth-api.zbar;
import com.google.android.gms.internal.auth-api.zbas;
import com.google.android.gms.internal.auth-api.zbv;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.Iterator;

public final class zbap
extends GoogleApi
implements SignInClient {
    private static final Api.ClientKey zba = new Api.ClientKey();
    private static final Api.AbstractClientBuilder zbb = new zbak();
    private static final Api zbc = new Api("Auth.Api.Identity.SignIn.API", zbb, zba);
    private final String zbd = zbas.zba();

    @Override
    public final SignInCredential getSignInCredentialFromIntent(@Nullable Intent intent) throws ApiException {
        if (intent == null) {
            throw new ApiException(Status.RESULT_INTERNAL_ERROR);
        }
        Object object = (Status)SafeParcelableSerializer.deserializeFromIntentExtra((Intent)intent, (String)"status", (Parcelable.Creator)Status.CREATOR);
        if (object == null) {
            throw new ApiException(Status.RESULT_CANCELED);
        }
        if (!object.isSuccess()) {
            throw new ApiException((Status)object);
        }
        object = (SignInCredential)SafeParcelableSerializer.deserializeFromIntentExtra((Intent)intent, (String)"sign_in_credential", SignInCredential.CREATOR);
        if (object == null) {
            throw new ApiException(Status.RESULT_INTERNAL_ERROR);
        }
        return object;
    }

    @Override
    public final Task<BeginSignInResult> beginSignIn(@NonNull BeginSignInRequest beginSignInRequest) {
        Preconditions.checkNotNull((Object)((Object)beginSignInRequest));
        BeginSignInRequest.Builder builder = BeginSignInRequest.zba(beginSignInRequest);
        builder.zba(this.zbd);
        beginSignInRequest = builder.build();
        return this.doRead(TaskApiCall.builder().setFeatures(new Feature[]{new Feature("auth_api_credentials_begin_sign_in", 8L)}).run((RemoteCall)new zbai(this, beginSignInRequest)).setAutoResolveMissingFeatures(false).setMethodKey(1553).build());
    }

    @Override
    public final Task<PendingIntent> getPhoneNumberHintIntent(@NonNull GetPhoneNumberHintIntentRequest getPhoneNumberHintIntentRequest) {
        Preconditions.checkNotNull((Object)((Object)getPhoneNumberHintIntentRequest));
        return this.doRead(TaskApiCall.builder().setFeatures(new Feature[]{zbar.zbh}).run((RemoteCall)new zbag(this, getPhoneNumberHintIntentRequest)).setMethodKey(1653).build());
    }

    @Override
    public final Task<PendingIntent> getSignInIntent(@NonNull GetSignInIntentRequest getSignInIntentRequest) {
        Preconditions.checkNotNull((Object)((Object)getSignInIntentRequest));
        GetSignInIntentRequest.Builder builder = GetSignInIntentRequest.zba(getSignInIntentRequest);
        builder.zba(this.zbd);
        getSignInIntentRequest = builder.build();
        return this.doRead(TaskApiCall.builder().setFeatures(new Feature[]{zbar.zbf}).run((RemoteCall)new zbaj(this, getSignInIntentRequest)).setMethodKey(1555).build());
    }

    @Override
    public final Task<Void> signOut() {
        this.getApplicationContext().getSharedPreferences("com.google.android.gms.signin", 0).edit().clear().apply();
        Iterator iterator = GoogleApiClient.getAllClients().iterator();
        while (iterator.hasNext()) {
            ((GoogleApiClient)iterator.next()).maybeSignOut();
        }
        GoogleApiManager.reportSignOut();
        return this.doWrite(TaskApiCall.builder().setFeatures(new Feature[]{zbar.zbb}).run((RemoteCall)new zbah(this)).setAutoResolveMissingFeatures(false).setMethodKey(1554).build());
    }

    @Override
    public final String getPhoneNumberFromIntent(@Nullable Intent intent) throws ApiException {
        if (intent == null) {
            throw new ApiException(Status.RESULT_INTERNAL_ERROR);
        }
        Object object = (Status)SafeParcelableSerializer.deserializeFromIntentExtra((Intent)intent, (String)"status", (Parcelable.Creator)Status.CREATOR);
        if (object == null) {
            throw new ApiException(Status.RESULT_CANCELED);
        }
        if (!object.isSuccess()) {
            throw new ApiException((Status)object);
        }
        object = intent.getStringExtra("phone_number_hint_result");
        if (object == null) {
            throw new ApiException(Status.RESULT_INTERNAL_ERROR);
        }
        return object;
    }

    public zbap(@NonNull Activity activity, @NonNull zbs zbs2) {
        super(activity, zbc, (Api.ApiOptions)zbs2, GoogleApi.Settings.DEFAULT_SETTINGS);
    }

    public zbap(@NonNull Context context, @NonNull zbs zbs2) {
        super(context, zbc, (Api.ApiOptions)zbs2, GoogleApi.Settings.DEFAULT_SETTINGS);
    }

    final /* synthetic */ void zba(GetPhoneNumberHintIntentRequest getPhoneNumberHintIntentRequest, zbaq zbaq2, TaskCompletionSource taskCompletionSource) throws RemoteException {
        zbao zbao2 = new zbao(this, taskCompletionSource);
        ((zbv)zbaq2.getService()).zbd(zbao2, getPhoneNumberHintIntentRequest, this.zbd);
    }

    final /* synthetic */ void zbb(zbaq zbaq2, TaskCompletionSource taskCompletionSource) throws RemoteException {
        zbam zbam2 = new zbam(this, taskCompletionSource);
        ((zbv)zbaq2.getService()).zbf((IStatusCallback)zbam2, this.zbd);
    }
}

