/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.identity;

import android.accounts.Account;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.auth.api.identity.zbb;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.util.List;

@SafeParcelable.Class(creator="AuthorizationRequestCreator")
public class AuthorizationRequest
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @NonNull
    public static final Parcelable.Creator<AuthorizationRequest> CREATOR = new zbb();
    @SafeParcelable.Field(id=1, getter="getRequestedScopes")
    private final List zba;
    @SafeParcelable.Field(id=2, getter="getServerClientId")
    @Nullable
    private final String zbb;
    @SafeParcelable.Field(id=3, getter="isOfflineAccessRequested")
    private final boolean zbc;
    @SafeParcelable.Field(id=4, getter="isIdTokenRequested")
    private final boolean zbd;
    @SafeParcelable.Field(id=5, getter="getAccount")
    @Nullable
    private final Account zbe;
    @SafeParcelable.Field(id=6, getter="getHostedDomain")
    @Nullable
    private final String zbf;
    @SafeParcelable.Field(id=7, getter="getSessionId")
    @Nullable
    private final String zbg;
    @SafeParcelable.Field(id=8, getter="isForceCodeForRefreshToken")
    private final boolean zbh;
    @SafeParcelable.Field(id=9, getter="getResourceParameters")
    @Nullable
    private final Bundle zbi;
    @SafeParcelable.Field(id=10, getter="getOptOutIncludingGrantedScopes", defaultValue="false")
    private final boolean zbj;

    public int hashCode() {
        List list = this.zba;
        return Objects.hashCode((Object[])new Object[]{list, this.zbb, this.zbc, this.zbh, this.zbd, this.zbe, this.zbf, this.zbg, this.zbi, this.zbj});
    }

    @Nullable
    public Account getAccount() {
        return this.zbe;
    }

    @Nullable
    public Bundle getResourceParameters() {
        return this.zbi;
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @Nullable
    public String getHostedDomain() {
        return this.zbf;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public String getResourceParameter(@NonNull ResourceParameter resourceParameter) {
        void var1_1;
        AuthorizationRequest this_ = this_.zbi;
        if (this_ == null) {
            return null;
        }
        return this_.getString(var1_1.zba);
    }

    @Nullable
    public String getServerClientId() {
        return this.zbb;
    }

    @NonNull
    public List<Scope> getRequestedScopes() {
        return this.zba;
    }

    /*
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    AuthorizationRequest(@SafeParcelable.Param(id=1) List list, @SafeParcelable.Param(id=2) @Nullable String string, @SafeParcelable.Param(id=3) boolean bl, @SafeParcelable.Param(id=4) boolean bl2, @SafeParcelable.Param(id=5) @Nullable Account account, @SafeParcelable.Param(id=6) @Nullable String string2, @SafeParcelable.Param(id=7) @Nullable String string3, @SafeParcelable.Param(id=8) boolean bl3, @SafeParcelable.Param(id=9) @Nullable Bundle bundle, @SafeParcelable.Param(id=10) boolean bl4) {
        boolean bl5 = list != null ? !list.isEmpty() : false;
        Preconditions.checkArgument((boolean)bl5, (Object)"requestedScopes cannot be null or empty");
        this.zba = list;
        this.zbb = string;
        this.zbc = bl;
        this.zbd = bl2;
        this.zbe = account;
        this.zbf = string2;
        this.zbg = string3;
        this.zbh = bl3;
        this.zbi = bundle;
        this.zbj = bl4;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)1, this.getRequestedScopes(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.getServerClientId(), (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)3, (boolean)this.isOfflineAccessRequested());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)4, (boolean)this.zbd);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)5, (Parcelable)this.getAccount(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)6, (String)this.getHostedDomain(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)7, (String)this.zbg, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)8, (boolean)this.isForceCodeForRefreshToken());
        SafeParcelWriter.writeBundle((Parcel)var1_1, (int)9, (Bundle)this.getResourceParameters(), (boolean)false);
        void v1 = var1_1;
        SafeParcelWriter.writeBoolean((Parcel)v1, (int)10, (boolean)this.getOptOutIncludingGrantedScopes());
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n);
    }

    public boolean equals(@Nullable Object o) {
        block10: {
            Bundle bundle;
            AuthorizationRequest authorizationRequest;
            Bundle bundle2;
            block9: {
                if (!(o instanceof AuthorizationRequest)) {
                    return false;
                }
                authorizationRequest = (AuthorizationRequest)bundle2;
                if (this.zba.size() != authorizationRequest.zba.size() || !this.zba.containsAll(authorizationRequest.zba)) {
                    return false;
                }
                bundle2 = authorizationRequest.zbi;
                bundle = this.zbi;
                if (bundle != null) break block9;
                if (bundle2 != null) break block10;
                bundle2 = null;
            }
            if (bundle == null || bundle2 != null) {
                if (bundle != null) {
                    if (bundle.size() != bundle2.size()) {
                        return false;
                    }
                    for (String string : this.zbi.keySet()) {
                        if (Objects.equal((Object)this.zbi.getString(string), (Object)bundle2.getString(string))) continue;
                        return false;
                    }
                }
                return this.zbc == authorizationRequest.zbc && this.zbh == authorizationRequest.zbh && this.zbd == authorizationRequest.zbd && this.zbj == authorizationRequest.zbj && Objects.equal((Object)this.zbb, (Object)authorizationRequest.zbb) && Objects.equal((Object)this.zbe, (Object)authorizationRequest.zbe) && Objects.equal((Object)this.zbf, (Object)authorizationRequest.zbf) && Objects.equal((Object)this.zbg, (Object)authorizationRequest.zbg);
            }
        }
        return false;
    }

    public boolean getOptOutIncludingGrantedScopes() {
        return this.zbj;
    }

    public boolean isForceCodeForRefreshToken() {
        return this.zbh;
    }

    public boolean isOfflineAccessRequested() {
        return this.zbc;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNull
    public static Builder zba(@NonNull AuthorizationRequest authorizationRequest) {
        String string;
        String string22;
        Preconditions.checkNotNull((Object)((Object)authorizationRequest));
        Builder builder = AuthorizationRequest.builder();
        builder.setRequestedScopes(authorizationRequest.getRequestedScopes());
        Bundle bundle = authorizationRequest.getResourceParameters();
        if (bundle != null) {
            for (String string22 : bundle.keySet()) {
                ResourceParameter resourceParameter;
                block8: {
                    string = bundle.getString(string22);
                    for (ResourceParameter resourceParameter2 : ResourceParameter.values()) {
                        if (!resourceParameter2.zba.equals(string22)) continue;
                        resourceParameter = resourceParameter2;
                        break block8;
                    }
                    resourceParameter = null;
                }
                if (string == null || resourceParameter == null) continue;
                builder.addResourceParameter(resourceParameter, string);
            }
        }
        boolean bl = authorizationRequest.isForceCodeForRefreshToken();
        String string3 = authorizationRequest.zbg;
        String string4 = authorizationRequest.getHostedDomain();
        string22 = authorizationRequest.getAccount();
        string = authorizationRequest.getServerClientId();
        if (string3 != null) {
            builder.zbb(string3);
        }
        if (string4 != null) {
            builder.filterByHostedDomain(string4);
        }
        if (string22 != null) {
            builder.setAccount((Account)string22);
        }
        if (authorizationRequest.zbd && string != null) {
            builder.zba(string);
        }
        if (authorizationRequest.isOfflineAccessRequested() && string != null) {
            builder.requestOfflineAccess(string, bl);
        }
        builder.setOptOutIncludingGrantedScopes(authorizationRequest.zbj);
        return builder;
    }

    public static final class Builder {
        private List zba;
        @Nullable
        private String zbb;
        private boolean zbc;
        private boolean zbd;
        @Nullable
        private Account zbe;
        @Nullable
        private String zbf;
        @Nullable
        private String zbg;
        private boolean zbh;
        @Nullable
        private Bundle zbi;
        private boolean zbj;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addResourceParameter(@NonNull ResourceParameter resourceParameter, @NonNull String resourceParameterValue) {
            void var1_1;
            void var2_2;
            Preconditions.checkNotNull((Object)((Object)resourceParameter), (Object)"Resource parameter cannot be null");
            Preconditions.checkNotNull((Object)var2_2, (Object)"Resource parameter value cannot be null");
            if (this.zbi == null) {
                this.zbi = new Bundle();
            }
            this.zbi.putString(var1_1.zba, (String)var2_2);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder filterByHostedDomain(@NonNull String hostedDomain) {
            void var1_1;
            this.zbf = Preconditions.checkNotEmpty((String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder requestOfflineAccess(@NonNull String serverClientId) {
            void var1_1;
            this.requestOfflineAccess((String)var1_1, false);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder requestOfflineAccess(@NonNull String serverClientId, boolean forceCodeForRefreshToken) {
            void var2_2;
            void var1_1;
            this.zbc((String)var1_1);
            this.zbb = var1_1;
            this.zbc = true;
            this.zbh = var2_2;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAccount(@NonNull Account account) {
            void var1_1;
            this.zbe = (Account)Preconditions.checkNotNull((Object)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setOptOutIncludingGrantedScopes(boolean optOutIncludingGrantedScopes) {
            void var1_1;
            this.zbj = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setRequestedScopes(@NonNull List<Scope> requestedScopes) {
            void var1_1;
            boolean bl = requestedScopes != null ? !var1_1.isEmpty() : false;
            Preconditions.checkArgument((boolean)bl, (Object)"requestedScopes cannot be null or empty");
            this.zba = var1_1;
            return this;
        }

        @NonNull
        public AuthorizationRequest build() {
            return new AuthorizationRequest(this.zba, this.zbb, this.zbc, this.zbd, this.zbe, this.zbf, this.zbg, this.zbh, this.zbi, this.zbj);
        }

        @ShowFirstParty
        @NonNull
        public final Builder zba(@NonNull String string) {
            this.zbc(string);
            this.zbb = string;
            this.zbd = true;
            return this;
        }

        @NonNull
        public final Builder zbb(@NonNull String string) {
            this.zbg = string;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        private final String zbc(String string) {
            Preconditions.checkNotNull((Object)string);
            String string2 = ((Builder)((Object)string2)).zbb;
            boolean bl = string2 != null ? string2.equals(string) : true;
            Preconditions.checkArgument((boolean)bl, (Object)"two different server client ids provided");
            return string;
        }
    }

    public static final class ResourceParameter
    extends Enum<ResourceParameter> {
        @NonNull
        public static final /* enum */ ResourceParameter ACCOUNT_SELECTION_TOKEN;
        @NonNull
        public static final /* enum */ ResourceParameter ACCOUNT_SELECTION_STATE;
        private static final /* synthetic */ ResourceParameter[] zbb;
        final String zba;

        @NonNull
        public static ResourceParameter valueOf(@NonNull String name) {
            String string;
            return Enum.valueOf(ResourceParameter.class, string);
        }

        static {
            String string = "account_selection_token";
            ACCOUNT_SELECTION_TOKEN = new ResourceParameter(string);
            string = "account_selection_state";
            ACCOUNT_SELECTION_STATE = new ResourceParameter(string);
            zbb = new ResourceParameter[]{ACCOUNT_SELECTION_TOKEN, ACCOUNT_SELECTION_STATE};
        }

        private ResourceParameter(String string2) {
            this.zba = string2;
        }

        @NonNull
        public static ResourceParameter[] values() {
            return (ResourceParameter[])zbb.clone();
        }
    }
}

