/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.auth-api;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.auth.api.identity.AuthorizationClient;
import com.google.android.gms.auth.api.identity.AuthorizationRequest;
import com.google.android.gms.auth.api.identity.AuthorizationResult;
import com.google.android.gms.auth.api.identity.zbb;
import com.google.android.gms.auth.api.identity.zbc;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.RemoteCall;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.internal.auth-api.zban;
import com.google.android.gms.internal.auth-api.zbao;
import com.google.android.gms.internal.auth-api.zbbi;
import com.google.android.gms.internal.auth-api.zbbj;
import com.google.android.gms.tasks.Task;

public final class zbaq
extends GoogleApi
implements AuthorizationClient {
    private static final Api.ClientKey zba = new Api.ClientKey();
    private static final Api.AbstractClientBuilder zbb = new zbao();
    private static final Api zbc = new Api("Auth.Api.Identity.Authorization.API", zbb, zba);

    @Override
    public final AuthorizationResult getAuthorizationResultFromIntent(@Nullable Intent intent) throws ApiException {
        if (intent == null) {
            throw new ApiException(Status.RESULT_INTERNAL_ERROR);
        }
        Object object = (Status)SafeParcelableSerializer.deserializeFromIntentExtra((Intent)intent, (String)"status", (Parcelable.Creator)Status.CREATOR);
        if (object == null) {
            throw new ApiException(Status.RESULT_CANCELED);
        }
        if (!object.isSuccess()) {
            throw new ApiException((Status)object);
        }
        object = (AuthorizationResult)SafeParcelableSerializer.deserializeFromIntentExtra((Intent)intent, (String)"authorization_result", AuthorizationResult.CREATOR);
        if (object == null) {
            throw new ApiException(Status.RESULT_INTERNAL_ERROR);
        }
        return object;
    }

    @Override
    public final Task<AuthorizationResult> authorize(@NonNull AuthorizationRequest authorizationRequest) {
        Preconditions.checkNotNull((Object)((Object)authorizationRequest));
        AuthorizationRequest.Builder builder = AuthorizationRequest.zba(authorizationRequest);
        builder.zbb(((zbc)this.getApiOptions()).zbb());
        authorizationRequest = builder.build();
        return this.doRead(TaskApiCall.builder().setFeatures(new Feature[]{zbbi.zbc}).run((RemoteCall)new zban(this, authorizationRequest)).setAutoResolveMissingFeatures(false).setMethodKey(1534).build());
    }

    public zbaq(@NonNull Activity activity, @NonNull zbc zbc2) {
        zbb zbb2 = com.google.android.gms.auth.api.identity.zbb.zbc(zbc2);
        zbb2.zba(zbbj.zba());
        super(activity, zbc, (Api.ApiOptions)zbb2.zbb(), GoogleApi.Settings.DEFAULT_SETTINGS);
    }

    public zbaq(@NonNull Context context, @NonNull zbc zbc2) {
        zbb zbb2 = com.google.android.gms.auth.api.identity.zbb.zbc(zbc2);
        zbb2.zba(zbbj.zba());
        super(context, zbc, (Api.ApiOptions)zbb2.zbb(), GoogleApi.Settings.DEFAULT_SETTINGS);
    }
}

