/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.identity;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.auth.api.identity.SignInPassword;
import com.google.android.gms.auth.api.identity.zzj;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;

@SafeParcelable.Class(creator="SavePasswordRequestCreator")
public class SavePasswordRequest
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<SavePasswordRequest> CREATOR = new zzj();
    @SafeParcelable.Field(id=1, getter="getSignInPassword")
    private final SignInPassword zzbe;
    @SafeParcelable.Field(id=2, getter="getSessionId")
    @Nullable
    private final String zzau;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder zzc(SavePasswordRequest savePasswordRequest) {
        Preconditions.checkNotNull((Object)((Object)savePasswordRequest));
        Builder builder = SavePasswordRequest.builder().setSignInPassword(savePasswordRequest.getSignInPassword());
        String string = savePasswordRequest.zzau;
        if (string != null) {
            builder.zzg(string);
        }
        return builder;
    }

    @SafeParcelable.Constructor
    SavePasswordRequest(@SafeParcelable.Param(id=1) SignInPassword signInPassword, @SafeParcelable.Param(id=2) @Nullable String string) {
        this.zzbe = (SignInPassword)((Object)Preconditions.checkNotNull((Object)((Object)signInPassword)));
        this.zzau = string;
    }

    public SignInPassword getSignInPassword() {
        return this.zzbe;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zzbe, this.zzau});
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof SavePasswordRequest)) {
            return false;
        }
        SavePasswordRequest savePasswordRequest = (SavePasswordRequest)((Object)object);
        return Objects.equal((Object)((Object)this.zzbe), (Object)((Object)savePasswordRequest.zzbe)) && Objects.equal((Object)this.zzau, (Object)savePasswordRequest.zzau);
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        SavePasswordRequest savePasswordRequest = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)1, (Parcelable)savePasswordRequest.getSignInPassword(), (int)n, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)savePasswordRequest.zzau, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public static final class Builder {
        private SignInPassword zzbe;
        @Nullable
        private String zzau;

        public final Builder setSignInPassword(@NonNull SignInPassword signInPassword) {
            this.zzbe = signInPassword;
            return this;
        }

        public final Builder zzg(@NonNull String string) {
            this.zzau = string;
            return this;
        }

        public final SavePasswordRequest build() {
            return new SavePasswordRequest(this.zzbe, this.zzau);
        }
    }
}

