/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin.internal;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.util.Log;
import android.view.accessibility.AccessibilityEvent;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.SignInAccount;
import com.google.android.gms.auth.api.signin.internal.SignInConfiguration;
import com.google.android.gms.auth.api.signin.internal.zzc;
import com.google.android.gms.auth.api.signin.internal.zzp;
import com.google.android.gms.auth.api.signin.internal.zzz;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;

@KeepName
public class SignInHubActivity
extends FragmentActivity {
    private static boolean zzeod = false;
    private boolean zzeoe = false;
    @VisibleForTesting
    private SignInConfiguration zzeof;
    private boolean zzeog;
    private int zzeoh;
    private Intent zzeoi;

    public SignInHubActivity() {
    }

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        Intent intent = this.getIntent();
        String string = intent.getAction();
        if ("com.google.android.gms.auth.NO_IMPL".equals(string)) {
            this.zzaz(12500);
            return;
        }
        if (zzeod) {
            this.setResult(0);
            this.zzaz(12502);
            return;
        }
        zzeod = true;
        if (!string.equals("com.google.android.gms.auth.GOOGLE_SIGN_IN") && !string.equals("com.google.android.gms.auth.APPAUTH_SIGN_IN")) {
            String string2 = String.valueOf(intent.getAction());
            Log.e((String)"AuthSignInClient", (String)(string2.length() != 0 ? "Unknown action: ".concat(string2) : new String("Unknown action: ")));
            this.finish();
            return;
        }
        Bundle bundle2 = intent.getBundleExtra("config");
        this.zzeof = (SignInConfiguration)bundle2.getParcelable("config");
        if (this.zzeof == null) {
            Log.e((String)"AuthSignInClient", (String)"Activity started with invalid configuration.");
            this.setResult(0);
            this.finish();
            return;
        }
        if (bundle == null) {
            String string3 = string;
            SignInHubActivity signInHubActivity = this;
            Intent intent2 = new Intent(string3);
            if (string3.equals("com.google.android.gms.auth.GOOGLE_SIGN_IN")) {
                intent2.setPackage("com.google.android.gms");
            } else {
                intent2.setPackage(signInHubActivity.getPackageName());
            }
            intent2.putExtra("config", (Parcelable)signInHubActivity.zzeof);
            try {
                signInHubActivity.startActivityForResult(intent2, 40962);
                return;
            }
            catch (ActivityNotFoundException activityNotFoundException) {
                signInHubActivity.zzeoe = true;
                Log.w((String)"AuthSignInClient", (String)"Could not launch sign in Intent. Google Play Service is probably being updated...");
                signInHubActivity.zzaz(17);
                return;
            }
        }
        this.zzeog = bundle.getBoolean("signingInGoogleApiClients");
        if (this.zzeog) {
            this.zzeoh = bundle.getInt("signInResultCode");
            this.zzeoi = (Intent)bundle.getParcelable("signInResultData");
            this.zzacw();
        }
    }

    protected void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putBoolean("signingInGoogleApiClients", this.zzeog);
        if (this.zzeog) {
            bundle.putInt("signInResultCode", this.zzeoh);
            bundle.putParcelable("signInResultData", (Parcelable)this.zzeoi);
        }
    }

    protected void onActivityResult(int n, int n2, Intent intent) {
        if (this.zzeoe) {
            return;
        }
        this.setResult(0);
        switch (n) {
            case 40962: {
                Intent intent2 = intent;
                SignInHubActivity signInHubActivity = this;
                if (intent2 != null) {
                    SignInAccount signInAccount = (SignInAccount)intent2.getParcelableExtra("signInAccount");
                    if (signInAccount != null && signInAccount.getGoogleSignInAccount() != null) {
                        GoogleSignInAccount googleSignInAccount = signInAccount.getGoogleSignInAccount();
                        zzp.zzbq((Context)signInHubActivity).zza(signInHubActivity.zzeof.zzacv(), googleSignInAccount);
                        intent2.removeExtra("signInAccount");
                        intent2.putExtra("googleSignInAccount", (Parcelable)googleSignInAccount);
                        signInHubActivity.zzeog = true;
                        signInHubActivity.zzeoh = n2;
                        signInHubActivity.zzeoi = intent2;
                        signInHubActivity.zzacw();
                        return;
                    }
                    if (intent2.hasExtra("errorCode")) {
                        int n3 = intent2.getIntExtra("errorCode", 8);
                        signInHubActivity.zzaz(n3);
                        return;
                    }
                }
                signInHubActivity.zzaz(8);
            }
        }
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        return true;
    }

    private final void zzacw() {
        this.getSupportLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)new zza(this, null));
        zzeod = false;
    }

    private final void zzaz(int n) {
        Status status = new Status(n);
        Intent intent = new Intent();
        intent.putExtra("googleSignInStatus", (Parcelable)status);
        this.setResult(0, intent);
        this.finish();
        zzeod = false;
    }

    final class zza
    implements LoaderManager.LoaderCallbacks<Void> {
        private /* synthetic */ SignInHubActivity zzeoj;

        private zza(SignInHubActivity signInHubActivity) {
            this.zzeoj = signInHubActivity;
        }

        public final Loader<Void> onCreateLoader(int n, Bundle bundle) {
            return new zzc((Context)this.zzeoj, GoogleApiClient.zzahz());
        }

        public final void onLoaderReset(Loader<Void> loader) {
        }

        public final /* synthetic */ void onLoadFinished(Loader loader, Object object) {
            zza zza2 = this;
            zza2.zzeoj.setResult(zza2.zzeoj.zzeoh, zza2.zzeoj.zzeoi);
            zza2.zzeoj.finish();
        }

        /* synthetic */ zza(SignInHubActivity signInHubActivity, zzz zzz2) {
            this(signInHubActivity);
        }
    }
}

