/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.gtm;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.gtm.zzbu;
import com.google.android.gms.internal.gtm.zzbx;
import com.google.android.gms.internal.gtm.zzcv;
import com.google.android.gms.internal.gtm.zzew;
import com.google.android.gms.internal.gtm.zzfw;
import com.google.android.gms.internal.gtm.zzfx;

public final class zzda
extends zzbu {
    private boolean zza;
    private boolean zzb;
    private final AlarmManager zzc = (AlarmManager)this.zzo().getSystemService("alarm");
    private Integer zzd;

    private final int zzf() {
        if (this.zzd == null) {
            String string = String.valueOf(this.zzo().getPackageName());
            this.zzd = "analytics".concat(string).hashCode();
        }
        return this.zzd;
    }

    private final PendingIntent zzg() {
        zzda zzda2 = zzda2.zzo();
        String string = "com.google.android.gms.analytics.AnalyticsReceiver";
        return PendingIntent.getBroadcast((Context)zzda2, (int)0, (Intent)new Intent("com.google.android.gms.analytics.ANALYTICS_DISPATCH").setComponent(new ComponentName((Context)zzda2, string)), (int)zzfw.zza);
    }

    protected zzda(zzbx zzbx2) {
        super(zzbx2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zza() {
        this.zzb = false;
        try {
            this.zzc.cancel(this.zzg());
        }
        catch (NullPointerException nullPointerException) {}
        if (Build.VERSION.SDK_INT >= 24) {
            JobScheduler jobScheduler = (JobScheduler)this.zzo().getSystemService("jobscheduler");
            int n = this.zzf();
            Integer n2 = n;
            this.zzO("Cancelling job. JobID", n2);
            jobScheduler.cancel(n);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected final void zzd() {
        try {
            this.zza();
            this.zzw();
            long l = zzcv.zzd();
            if (l <= 0L) return;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return;
        }
        Context context = this.zzo();
        context = context.getPackageManager().getReceiverInfo(new ComponentName(context, "com.google.android.gms.analytics.AnalyticsReceiver"), 0);
        if (context == null) return;
        boolean bl = context.enabled;
        if (!bl) return;
        this.zzN("Receiver registered for local dispatch.");
        this.zza = true;
    }

    public final void zzb() {
        this.zzV();
        Preconditions.checkState((boolean)this.zza, (Object)"Receiver not registered");
        this.zzw();
        long l = zzcv.zzd();
        if (l > 0L) {
            this.zza();
            long l2 = this.zzC().elapsedRealtime() + l;
            this.zzb = true;
            ((Boolean)zzew.zzR.zzb()).booleanValue();
            if (Build.VERSION.SDK_INT >= 24) {
                this.zzN("Scheduling upload with JobScheduler");
                Context context = this.zzo();
                String string = "com.google.android.gms.analytics.AnalyticsJobService";
                ComponentName componentName = new ComponentName(context, string);
                int n = this.zzf();
                PersistableBundle persistableBundle = new PersistableBundle();
                persistableBundle.putString("action", "com.google.android.gms.analytics.ANALYTICS_DISPATCH");
                long l3 = l;
                JobInfo jobInfo = new JobInfo.Builder(n, componentName).setMinimumLatency(l).setOverrideDeadline(l3 + l3).setExtras(persistableBundle).build();
                Integer n2 = n;
                this.zzO("Scheduling job. JobID", n2);
                zzfx.zza(context, jobInfo, "com.google.android.gms", "DispatchAlarm");
                return;
            }
            this.zzN("Scheduling upload with AlarmManager");
            this.zzc.setInexactRepeating(2, l2, l, this.zzg());
            return;
        }
    }

    public final boolean zzc() {
        return this.zza;
    }

    public final boolean zze() {
        return this.zzb;
    }
}

