/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.analytics.zzg;
import com.google.android.gms.analytics.zzh;
import com.google.android.gms.analytics.zzl;
import com.google.android.gms.analytics.zzn;
import com.google.android.gms.analytics.zzq;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.gtm.zzax;
import com.google.android.gms.internal.gtm.zzbc;
import com.google.android.gms.internal.gtm.zzfu;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

@VisibleForTesting
@SuppressLint(value={"StaticFieldLeak"})
public final class zzr {
    private static volatile zzr zza;
    private final Context zzb;
    private final List zzc;
    private final zzg zzd;
    private final zzn zze;
    private volatile zzax zzf;
    private Thread.UncaughtExceptionHandler zzg;

    public final Context zza() {
        return this.zzb;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static zzr zzb(Context context) {
        Preconditions.checkNotNull((Object)context);
        if (zza != null) return zza;
        Class<zzr> clazz = zzr.class;
        synchronized (clazz) {
            zzr zzr2 = zza;
            if (zzr2 != null) return zza;
            zza = new zzr(context);
            return zza;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final zzax zzc() {
        block10: {
            if (this.zzf != null) break block10;
            synchronized (this) {
                String string;
                zzax zzax2;
                Object object;
                block9: {
                    block8: {
                        object = this.zzf;
                        if (object != null) break block10;
                        zzax2 = new zzax();
                        object = this.zzb.getPackageManager();
                        string = this.zzb.getPackageName();
                        zzax2.zzi(string);
                        zzax2.zzj(object.getInstallerPackageName(string));
                        PackageInfo packageInfo = object.getPackageInfo(this.zzb.getPackageName(), 0);
                        if (packageInfo == null) break block8;
                        boolean bl = TextUtils.isEmpty((CharSequence)(object = object.getApplicationLabel(packageInfo.applicationInfo)));
                        object = !bl ? object.toString() : string;
                        string = packageInfo.versionName;
                        break block9;
                        {
                            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
                        }
                    }
                    object = string;
                    string = null;
                    break block9;
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        object = string;
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("Error retrieving package info: appName set to ");
                        stringBuilder.append((String)object);
                        Log.e((String)"GAv4", (String)stringBuilder.toString());
                        string = null;
                    }
                }
                zzax2.zzk((String)object);
                zzax2.zzl(string);
                this.zzf = zzax2;
            }
        }
        return this.zzf;
    }

    public final zzbc zzd() {
        zzbc zzbc2 = new zzbc();
        DisplayMetrics displayMetrics = this.zzb.getResources().getDisplayMetrics();
        zzbc2.zze(zzfu.zzd(Locale.getDefault()));
        zzbc2.zza = displayMetrics.widthPixels;
        zzbc2.zzb = displayMetrics.heightPixels;
        return zzbc2;
    }

    static /* bridge */ /* synthetic */ Thread.UncaughtExceptionHandler zze(zzr zzr2) {
        return zzr2.zzg;
    }

    static /* bridge */ /* synthetic */ List zzf(zzr zzr2) {
        return zzr2.zzc;
    }

    public final Future zzg(Callable callable) {
        Preconditions.checkNotNull((Object)callable);
        if (Thread.currentThread() instanceof zzq) {
            FutureTask futureTask = new FutureTask(callable);
            futureTask.run();
            return futureTask;
        }
        return this.zze.submit(callable);
    }

    @VisibleForTesting
    zzr(Context context) {
        Context context2 = context.getApplicationContext();
        Preconditions.checkNotNull((Object)context2);
        this.zzb = context2;
        this.zze = new zzn(this);
        this.zzc = new CopyOnWriteArrayList();
        this.zzd = new zzg();
    }

    public static void zzh() {
        if (!(Thread.currentThread() instanceof zzq)) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    public final void zzi(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        this.zze.submit(runnable);
    }

    public final void zzj(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.zzg = uncaughtExceptionHandler;
    }

    final void zzk(zzh zzh2) {
        if (zzh2.zzl()) {
            throw new IllegalStateException("Measurement prototype can't be submitted");
        }
        if (zzh2.zzm()) {
            throw new IllegalStateException("Measurement can only be submitted once");
        }
        zzh zzh3 = new zzh(zzh2);
        zzh3.zzi();
        this.zze.execute(new zzl(this, zzh3));
    }
}

